/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.form;

import com.ironsoftware.ironpdf.edit.PageSelection;
import com.ironsoftware.ironpdf.font.FontTypes;
import com.ironsoftware.ironpdf.form.CheckBoxField;
import com.ironsoftware.ironpdf.form.ComboBoxField;
import com.ironsoftware.ironpdf.form.FormField;
import com.ironsoftware.ironpdf.form.FormFieldsSet;
import com.ironsoftware.ironpdf.form.TextField;
import com.ironsoftware.ironpdf.internal.staticapi.Form_Api;
import com.ironsoftware.ironpdf.internal.staticapi.InternalPdfDocument;
import java.util.ArrayList;

public class FormManager {
    private final InternalPdfDocument internalPdfDocument;

    public FormManager(InternalPdfDocument internalPdfDocument) {
        this.internalPdfDocument = internalPdfDocument;
    }

    public final void flatten() {
        Form_Api.flattenPdfFrom(this.internalPdfDocument);
    }

    public final void flatten(PageSelection pageSelection) {
        Form_Api.flattenPdfFrom(this.internalPdfDocument, pageSelection.getPageList(this.internalPdfDocument));
    }

    public FormFieldsSet getFields() {
        ArrayList<CheckBoxField> checkBoxFields = new ArrayList<CheckBoxField>();
        ArrayList<TextField> textFields = new ArrayList<TextField>();
        ArrayList<ComboBoxField> comboBoxFields = new ArrayList<ComboBoxField>();
        ArrayList<FormField> unknownFields = new ArrayList<FormField>();
        for (FormField anyField : Form_Api.getFields(this.internalPdfDocument)) {
            if (anyField instanceof CheckBoxField) {
                checkBoxFields.add((CheckBoxField)anyField);
                continue;
            }
            if (anyField instanceof TextField) {
                textFields.add((TextField)anyField);
                continue;
            }
            if (anyField instanceof ComboBoxField) {
                comboBoxFields.add((ComboBoxField)anyField);
                continue;
            }
            unknownFields.add(anyField);
        }
        return new FormFieldsSet(checkBoxFields, textFields, comboBoxFields, unknownFields);
    }

    public void renameField(String currentFieldName, String newFieldName) {
        Form_Api.renameField(this.internalPdfDocument, currentFieldName, newFieldName);
    }

    public void setFieldValue(String fieldName, String value) {
        Form_Api.setFieldValue(this.internalPdfDocument, fieldName, value);
    }

    public void setTextFieldFont(String textFieldName, FontTypes font, int fontSize) {
        Form_Api.setTextFieldFont(this.internalPdfDocument, textFieldName, font, fontSize);
    }
}

