/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.internal.staticapi;

import com.google.protobuf.ByteString;
import com.ironsoftware.ironpdf.internal.proto.AddPdfAttachmentRequestStream;
import com.ironsoftware.ironpdf.internal.proto.EmptyResult;
import com.ironsoftware.ironpdf.internal.proto.GetPdfAttachmentCollectionRequest;
import com.ironsoftware.ironpdf.internal.proto.GetPdfAttachmentCollectionResult;
import com.ironsoftware.ironpdf.internal.proto.GetPdfAttachmentDataRequest;
import com.ironsoftware.ironpdf.internal.proto.GetPdfAttachmentDataResultStream;
import com.ironsoftware.ironpdf.internal.proto.RemovePdfAttachmentRequest;
import com.ironsoftware.ironpdf.internal.staticapi.Access;
import com.ironsoftware.ironpdf.internal.staticapi.Exception_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.InternalPdfDocument;
import com.ironsoftware.ironpdf.internal.staticapi.RpcClient;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_ReceivingCustomStreamObserver;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_Util;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;

public final class Attachment_Api {
    public static List<String> getPdfAttachmentCollection(InternalPdfDocument internalPdfDocument) {
        RpcClient client = Access.ensureConnection();
        GetPdfAttachmentCollectionRequest.Builder req = GetPdfAttachmentCollectionRequest.newBuilder();
        req.setDocument(internalPdfDocument.remoteDocument);
        GetPdfAttachmentCollectionResult res = client.blockingStub.pdfDocumentAttachmentGetPdfAttachmentCollection(req.build());
        if (res.getResultOrExceptionCase() == GetPdfAttachmentCollectionResult.ResultOrExceptionCase.EXCEPTION) {
            throw Exception_Converter.fromProto(res.getException());
        }
        return res.getResult().getNamesList();
    }

    public static byte[] getPdfAttachmentData(InternalPdfDocument internalPdfDocument, String name) {
        RpcClient client = Access.ensureConnection();
        GetPdfAttachmentDataRequest.Builder req = GetPdfAttachmentDataRequest.newBuilder();
        req.setDocument(internalPdfDocument.remoteDocument);
        req.setName(name);
        CountDownLatch finishLatch = new CountDownLatch(1);
        ArrayList msgChunks = new ArrayList();
        client.stub.pdfDocumentAttachmentGetPdfAttachmentData(req.build(), new Utils_ReceivingCustomStreamObserver<GetPdfAttachmentDataResultStream>(finishLatch, msgChunks));
        Utils_Util.waitAndCheck(finishLatch, msgChunks);
        List<byte[]> bytesChunks = msgChunks.stream().map(res -> {
            if (res.getResultOrExceptionCase() == GetPdfAttachmentDataResultStream.ResultOrExceptionCase.EXCEPTION) {
                throw Exception_Converter.fromProto(res.getException());
            }
            return res.getResultChunk().toByteArray();
        }).collect(Collectors.toList());
        return Utils_Util.combineChunk(bytesChunks);
    }

    public static void addPdfAttachment(InternalPdfDocument internalPdfDocument, String name, byte[] attachmentBytes) {
        RpcClient client = Access.ensureConnection();
        CountDownLatch finishLatch = new CountDownLatch(1);
        ArrayList<EmptyResult> resultChunks = new ArrayList<EmptyResult>();
        StreamObserver<AddPdfAttachmentRequestStream> requestStream = client.stub.pdfDocumentAttachmentAddPdfAttachment(new Utils_ReceivingCustomStreamObserver<EmptyResult>(finishLatch, resultChunks));
        AddPdfAttachmentRequestStream.Info.Builder info = AddPdfAttachmentRequestStream.Info.newBuilder();
        info.setDocument(internalPdfDocument.remoteDocument);
        info.setName(name);
        AddPdfAttachmentRequestStream.Builder infoMsg = AddPdfAttachmentRequestStream.newBuilder();
        infoMsg.setInfo(info);
        requestStream.onNext((Object)infoMsg.build());
        Iterator<byte[]> it = Utils_Util.chunk(attachmentBytes);
        while (it.hasNext()) {
            byte[] bytes = it.next();
            AddPdfAttachmentRequestStream.Builder attachmentDataMsg = AddPdfAttachmentRequestStream.newBuilder();
            attachmentDataMsg.setAttachmentChunk(ByteString.copyFrom((byte[])bytes));
            requestStream.onNext((Object)attachmentDataMsg.build());
        }
        requestStream.onCompleted();
        Utils_Util.waitAndCheck(finishLatch, resultChunks);
        Utils_Util.handleEmptyResultChunks(resultChunks);
    }

    public static void removePdfAttachment(InternalPdfDocument internalPdfDocument, String name) {
        RpcClient client = Access.ensureConnection();
        RemovePdfAttachmentRequest.Builder req = RemovePdfAttachmentRequest.newBuilder();
        req.setDocument(internalPdfDocument.remoteDocument);
        req.setName(name);
        EmptyResult res = client.blockingStub.pdfDocumentAttachmentRemovePdfAttachment(req.build());
        Utils_Util.handleEmptyResult(res);
    }
}

