/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.internal.staticapi;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigLoader {
    protected static final Logger logger = LoggerFactory.getLogger(ConfigLoader.class);
    protected Properties properties = new Properties();

    public ConfigLoader() {
        Throwable throwable;
        InputStream input;
        Path mainResource = Paths.get("src", "main", "resources", "config.properties");
        if (mainResource.toFile().exists()) {
            try {
                input = Files.newInputStream(mainResource, new OpenOption[0]);
                throwable = null;
                try {
                    this.properties.load(input);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (input != null) {
                        if (throwable != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            input.close();
                        }
                    }
                }
            }
            catch (IOException ex) {
                logger.debug("cannot get main resources path", (Throwable)ex);
            }
        }
        try {
            input = this.getClass().getResourceAsStream("config.properties");
            throwable = null;
            try {
                if (input != null) {
                    this.properties.load(input);
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (input != null) {
                    if (throwable != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        input.close();
                    }
                }
            }
        }
        catch (IOException ex) {
            logger.debug("cannot get class resources path", (Throwable)ex);
        }
        Path testResource = Paths.get("src", "test", "resources", "config.properties");
        if (testResource.toFile().exists()) {
            try (InputStream input2 = Files.newInputStream(testResource, new OpenOption[0]);){
                if (input2 != null) {
                    this.properties.load(input2);
                }
            }
            catch (IOException ex) {
                logger.debug("cannot get main resources path", (Throwable)ex);
            }
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }
}

