/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.internal.staticapi;

import com.ironsoftware.ironpdf.internal.proto.CopyPagesRequest;
import com.ironsoftware.ironpdf.internal.proto.EmptyResult;
import com.ironsoftware.ironpdf.internal.proto.GetPagesRequest;
import com.ironsoftware.ironpdf.internal.proto.GetPagesResult;
import com.ironsoftware.ironpdf.internal.proto.PdfDocumentInsertRequest;
import com.ironsoftware.ironpdf.internal.proto.PdfDocumentMergeRequest;
import com.ironsoftware.ironpdf.internal.proto.PdfDocumentResult;
import com.ironsoftware.ironpdf.internal.proto.RemovePagesRequest;
import com.ironsoftware.ironpdf.internal.proto.RotatePagesRequest;
import com.ironsoftware.ironpdf.internal.staticapi.Access;
import com.ironsoftware.ironpdf.internal.staticapi.Exception_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.InternalPdfDocument;
import com.ironsoftware.ironpdf.internal.staticapi.Page_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.RpcClient;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_Util;
import com.ironsoftware.ironpdf.page.PageInfo;
import com.ironsoftware.ironpdf.page.PageRotation;
import java.util.List;
import java.util.stream.Collectors;

public final class Page_Api {
    public static void removePage(InternalPdfDocument internalPdfDocument, Iterable<Integer> pageIndexes) {
        RpcClient client = Access.ensureConnection();
        RemovePagesRequest.Builder req = RemovePagesRequest.newBuilder();
        req.setDocument(internalPdfDocument.remoteDocument);
        req.addAllPageIndexes(pageIndexes);
        EmptyResult res = client.blockingStub.pdfDocumentPageRemovePages(req.build());
        Utils_Util.handleEmptyResult(res);
    }

    public static InternalPdfDocument mergePage(List<InternalPdfDocument> pdfDocuments) {
        RpcClient client = Access.ensureConnection();
        PdfDocumentMergeRequest.Builder req = PdfDocumentMergeRequest.newBuilder();
        req.addAllDocuments(pdfDocuments.stream().map(x -> x.remoteDocument).collect(Collectors.toList()));
        PdfDocumentResult res = client.blockingStub.pdfDocumentPageMerge(req.build());
        return Utils_Util.handlePdfDocumentResult(res);
    }

    public static void insertPage(InternalPdfDocument internalPdfDocument, InternalPdfDocument anotherPdf) {
        Page_Api.insertPage(internalPdfDocument, anotherPdf, 0);
    }

    public static void insertPage(InternalPdfDocument internalPdfDocument, InternalPdfDocument anotherPdf, int atIndex) {
        RpcClient client = Access.ensureConnection();
        PdfDocumentInsertRequest.Builder req = PdfDocumentInsertRequest.newBuilder();
        req.setMainDocument(internalPdfDocument.remoteDocument);
        req.setInsertionIndex(atIndex);
        req.setInsertedDocument(anotherPdf.remoteDocument);
        EmptyResult res = client.blockingStub.pdfDocumentPageInsertPdf(req.build());
        Utils_Util.handleEmptyResult(res);
    }

    public static void appendPdf(InternalPdfDocument mainPdfDocument, InternalPdfDocument anotherPdf) {
        RpcClient client = Access.ensureConnection();
        PdfDocumentInsertRequest.Builder req = PdfDocumentInsertRequest.newBuilder();
        req.setMainDocument(mainPdfDocument.remoteDocument);
        req.setInsertionIndex(Page_Api.getPagesInfo(mainPdfDocument).size());
        req.setInsertedDocument(anotherPdf.remoteDocument);
        EmptyResult res = client.blockingStub.pdfDocumentPageInsertPdf(req.build());
        Utils_Util.handleEmptyResult(res);
    }

    public static List<PageInfo> getPagesInfo(InternalPdfDocument internalPdfDocument) {
        RpcClient client = Access.ensureConnection();
        GetPagesRequest.Builder req = GetPagesRequest.newBuilder();
        req.setDocument(internalPdfDocument.remoteDocument);
        GetPagesResult res = client.blockingStub.pdfDocumentPageGetPages(req.build());
        if (res.getResultOrExceptionCase() == GetPagesResult.ResultOrExceptionCase.EXCEPTION) {
            throw Exception_Converter.fromProto(res.getException());
        }
        return res.getResult().getPagesList().stream().map(Page_Converter::fromProto).collect(Collectors.toList());
    }

    public static void rotatePage(InternalPdfDocument internalPdfDocument, PageRotation pageRotation) {
        RpcClient client = Access.ensureConnection();
        RotatePagesRequest.Builder req = RotatePagesRequest.newBuilder();
        req.setDocument(internalPdfDocument.remoteDocument);
        req.setPageRotation(Page_Converter.toProto(pageRotation));
        EmptyResult res = client.blockingStub.pdfDocumentPageRotatePages(req.build());
        Utils_Util.handleEmptyResult(res);
    }

    public static void rotatePage(InternalPdfDocument internalPdfDocument, PageRotation pageRotation, Iterable<Integer> pageIndexes) {
        RpcClient client = Access.ensureConnection();
        RotatePagesRequest.Builder req = RotatePagesRequest.newBuilder();
        req.setDocument(internalPdfDocument.remoteDocument);
        req.setPageRotation(Page_Converter.toProto(pageRotation));
        if (pageIndexes != null) {
            req.addAllPageIndexes(pageIndexes);
        }
        EmptyResult res = client.blockingStub.pdfDocumentPageRotatePages(req.build());
        Utils_Util.handleEmptyResult(res);
    }

    public static InternalPdfDocument copyPage(InternalPdfDocument internalPdfDocument, Iterable<Integer> pageIndexes) {
        RpcClient client = Access.ensureConnection();
        CopyPagesRequest.Builder req = CopyPagesRequest.newBuilder();
        req.setDocument(internalPdfDocument.remoteDocument);
        req.addAllPageIndexes(pageIndexes);
        PdfDocumentResult res = client.blockingStub.pdfDocumentPageCopyPages(req.build());
        return Utils_Util.handlePdfDocumentResult(res);
    }
}

