/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.internal.staticapi;

import com.ironsoftware.ironpdf.internal.proto.EmptyResult;
import com.ironsoftware.ironpdf.internal.proto.GetPdfSecuritySettingsRequest;
import com.ironsoftware.ironpdf.internal.proto.GetPdfSecuritySettingsResult;
import com.ironsoftware.ironpdf.internal.proto.PdfSecuritySettings;
import com.ironsoftware.ironpdf.internal.proto.RemovePasswordsAndEncryptionRequest;
import com.ironsoftware.ironpdf.internal.proto.SetPdfSecuritySettingsRequest;
import com.ironsoftware.ironpdf.internal.staticapi.Access;
import com.ironsoftware.ironpdf.internal.staticapi.Exception_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.InternalPdfDocument;
import com.ironsoftware.ironpdf.internal.staticapi.RpcClient;
import com.ironsoftware.ironpdf.internal.staticapi.Security_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_StringHelper;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_Util;
import com.ironsoftware.ironpdf.security.PdfEditSecurity;
import com.ironsoftware.ironpdf.security.PdfPrintSecurity;
import com.ironsoftware.ironpdf.security.SecurityOptions;

public final class Security_Api {
    public static void removePasswordsAndEncryption(InternalPdfDocument internalPdfDocument) {
        RpcClient client = Access.ensureConnection();
        RemovePasswordsAndEncryptionRequest.Builder req = RemovePasswordsAndEncryptionRequest.newBuilder();
        req.setDocument(internalPdfDocument.remoteDocument);
        EmptyResult res = client.blockingStub.pdfDocumentSecurityRemovePasswordsAndEncryption(req.buildPartial());
        Utils_Util.handleEmptyResult(res);
    }

    public static SecurityOptions getPdfSecurityOptions(InternalPdfDocument internalPdfDocument) {
        RpcClient client = Access.ensureConnection();
        GetPdfSecuritySettingsRequest.Builder req = GetPdfSecuritySettingsRequest.newBuilder();
        req.setDocument(internalPdfDocument.remoteDocument);
        GetPdfSecuritySettingsResult res = client.blockingStub.pdfDocumentSecurityGetPdfSecuritySettings(req.build());
        if (res.getResultOrExceptionCase() == GetPdfSecuritySettingsResult.ResultOrExceptionCase.EXCEPTION) {
            throw Exception_Converter.fromProto(res.getException());
        }
        return Security_Converter.fromProto(res.getSecuritySettings());
    }

    public static void makePdfDocumentReadOnly(InternalPdfDocument internalPdfDocument, String ownerPassword) {
        if (Utils_StringHelper.isNullOrWhiteSpace(ownerPassword)) {
            throw new RuntimeException("MakePdfDocumentReadOnly :: A string for owner password is required to enable PDF encryption and all document security options.");
        }
        PdfSecuritySettings.Builder iron = PdfSecuritySettings.newBuilder();
        if (!Utils_StringHelper.isNullOrWhiteSpace(ownerPassword)) {
            iron.setOwnerPassword(ownerPassword);
        }
        iron.setAllowUserCopyPasteContent(false);
        iron.setAllowUserCopyPasteContentForAccessibility(false);
        iron.setAllowUserAnnotations(false);
        iron.setAllowUserEdits(Security_Converter.toProto(PdfEditSecurity.NO_EDIT));
        iron.setAllowUserFormData(false);
        iron.setAllowUserPrinting(Security_Converter.toProto(PdfPrintSecurity.FULL_PRINT_RIGHTS));
        Security_Api.setPdfSecuritySettings(internalPdfDocument, Security_Converter.fromProto(iron.build()));
    }

    public static void setPdfSecuritySettings(InternalPdfDocument internalPdfDocument, SecurityOptions securityOptions) {
        RpcClient client = Access.ensureConnection();
        SetPdfSecuritySettingsRequest.Builder req = SetPdfSecuritySettingsRequest.newBuilder();
        req.setDocument(internalPdfDocument.remoteDocument);
        req.setSecuritySettings(Security_Converter.toProto(securityOptions));
        EmptyResult res = client.blockingStub.pdfDocumentSecuritySetPdfSecuritySettings(req.buildPartial());
        Utils_Util.handleEmptyResult(res);
    }
}

