/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.layout.form.renderer;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.forms.PdfAcroForm;
import com.itextpdf.forms.fields.FormsMetaInfoStaticContainer;
import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.forms.fields.PdfTextFormField;
import com.itextpdf.html2pdf.attach.impl.layout.form.element.InputField;
import com.itextpdf.html2pdf.attach.impl.layout.form.renderer.AbstractOneLineTextFieldRenderer;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.minmaxwidth.MinMaxWidth;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.MetaInfoContainer;
import com.itextpdf.layout.renderer.ParagraphRenderer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputFieldRenderer
extends AbstractOneLineTextFieldRenderer {
    public InputFieldRenderer(InputField modelElement) {
        super(modelElement);
    }

    public IRenderer getNextRenderer() {
        return new InputFieldRenderer((InputField)this.modelElement);
    }

    public int getSize() {
        Integer size = this.getPropertyAsInteger(0x100004);
        return size != null ? size.intValue() : ((Integer)this.modelElement.getDefaultProperty(0x100004)).intValue();
    }

    public boolean isPassword() {
        Boolean password = this.getPropertyAsBoolean(0x100006);
        return password != null ? password.booleanValue() : ((Boolean)this.modelElement.getDefaultProperty(0x100006)).booleanValue();
    }

    @Override
    IRenderer createParagraphRenderer(String defaultValue) {
        if (defaultValue.isEmpty() && null != ((InputField)this.modelElement).getPlaceholder() && !((InputField)this.modelElement).getPlaceholder().isEmpty()) {
            return ((InputField)this.modelElement).getPlaceholder().createRendererSubTree();
        }
        return super.createParagraphRenderer(defaultValue);
    }

    @Override
    protected void adjustFieldLayout(LayoutContext layoutContext) {
        List flatLines = ((ParagraphRenderer)this.flatRenderer).getLines();
        Rectangle flatBBox = this.flatRenderer.getOccupiedArea().getBBox();
        this.updatePdfFont((ParagraphRenderer)this.flatRenderer);
        if (!flatLines.isEmpty() && this.font != null) {
            this.cropContentLines(flatLines, flatBBox);
        } else {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(MessageFormatUtil.format((String)"Error during layout of form filed with type {0}.", (Object[])new Object[]{"text input"}));
            this.setProperty(0x100003, true);
            flatBBox.setY(flatBBox.getTop()).setHeight(0.0f);
        }
        flatBBox.setWidth(this.retrieveWidth(layoutContext.getArea().getBBox().getWidth()).floatValue());
    }

    @Override
    protected IRenderer createFlatRenderer() {
        String defaultValue = this.getDefaultValue();
        boolean flatten = this.isFlatten();
        boolean password = this.isPassword();
        if (flatten && password) {
            defaultValue = this.obfuscatePassword(defaultValue);
        }
        return this.createParagraphRenderer(defaultValue);
    }

    @Override
    protected void applyAcroField(DrawContext drawContext) {
        this.font.setSubset(false);
        boolean password = this.isPassword();
        String value = password ? "" : this.getDefaultValue();
        String name = this.getModelId();
        UnitValue fontSize = this.getPropertyAsUnitValue(24);
        if (!fontSize.isPointValue()) {
            Logger logger = LoggerFactory.getLogger(InputFieldRenderer.class);
            logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{24}));
        }
        PdfDocument doc = drawContext.getDocument();
        Rectangle area = this.flatRenderer.getOccupiedArea().getBBox().clone();
        PdfPage page = doc.getPage(this.occupiedArea.getPageNumber());
        float fontSizeValue = fontSize.getValue();
        FormsMetaInfoStaticContainer.useMetaInfoDuringTheAction((MetaInfoContainer)this.getMetaInfo(), () -> {
            PdfTextFormField inputField = PdfFormField.createText((PdfDocument)doc, (Rectangle)area, (String)name, (String)value, (PdfFont)this.font, (float)fontSizeValue);
            if (password) {
                inputField.setFieldFlag(PdfFormField.FF_PASSWORD, true);
            } else {
                inputField.setDefaultValue((PdfObject)new PdfString(value));
            }
            this.applyDefaultFieldProperties((PdfFormField)inputField);
            PdfAcroForm.getAcroForm((PdfDocument)doc, (boolean)true).addField((PdfFormField)inputField, page);
        });
        this.writeAcroFormFieldLangAttribute(doc);
    }

    public <T1> T1 getProperty(int key) {
        if (key == 77) {
            Object width = super.getProperty(77);
            if (width == null) {
                UnitValue fontSize = this.getPropertyAsUnitValue(24);
                if (!fontSize.isPointValue()) {
                    Logger logger = LoggerFactory.getLogger(InputFieldRenderer.class);
                    logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{24}));
                }
                int size = this.getSize();
                return (T1)UnitValue.createPointValue((float)this.updateHtmlColsSizeBasedWidth(fontSize.getValue() * ((float)size * 0.5f + 2.0f) + 2.0f));
            }
            return (T1)width;
        }
        return (T1)super.getProperty(key);
    }

    protected boolean setMinMaxWidthBasedOnFixedWidth(MinMaxWidth minMaxWidth) {
        boolean result = false;
        if (this.hasRelativeUnitValue(77)) {
            UnitValue widthUV = (UnitValue)this.getProperty(77);
            boolean restoreWidth = this.hasOwnProperty(77);
            this.setProperty(77, null);
            Float width = this.retrieveWidth(0.0f);
            if (width != null) {
                minMaxWidth.setChildrenMaxWidth(width.floatValue());
                result = true;
            }
            if (restoreWidth) {
                this.setProperty(77, widthUV);
            } else {
                this.deleteOwnProperty(77);
            }
        } else {
            result = super.setMinMaxWidthBasedOnFixedWidth(minMaxWidth);
        }
        return result;
    }

    private String obfuscatePassword(String text) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            builder.append('*');
        }
        return builder.toString();
    }
}

