/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.util;

import java.util.ArrayList;

public class RowColHelper {
    private ArrayList<Integer> lastEmptyRow = new ArrayList();
    private int currRow = -1;
    private int currCol = 0;

    public void newRow() {
        ++this.currRow;
        this.currCol = 0;
    }

    public void updateCurrentPosition(int colspan, int rowspan) {
        this.ensureRowIsStarted();
        while (this.lastEmptyRow.size() < this.currCol) {
            this.lastEmptyRow.add(this.currRow);
        }
        int value = this.currRow + rowspan;
        int end = this.currCol + colspan;
        int middle = Math.min(this.lastEmptyRow.size(), end);
        for (int i = this.currCol; i < middle; ++i) {
            this.lastEmptyRow.set(i, Math.max(value, this.lastEmptyRow.get(i)));
        }
        while (this.lastEmptyRow.size() < end) {
            this.lastEmptyRow.add(value);
        }
        this.currCol = end;
    }

    public int moveToNextEmptyCol() {
        this.ensureRowIsStarted();
        while (!this.canPutCell(this.currCol)) {
            ++this.currCol;
        }
        return this.currCol;
    }

    private boolean canPutCell(int col) {
        this.ensureRowIsStarted();
        if (col >= this.lastEmptyRow.size()) {
            return true;
        }
        return this.lastEmptyRow.get(col) <= this.currRow;
    }

    private void ensureRowIsStarted() {
        if (this.currRow == -1) {
            this.newRow();
        }
    }
}

