/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.tagutils;

import com.itextpdf.kernel.pdf.tagging.PdfNamespace;
import com.itextpdf.kernel.pdf.tagging.PdfStructureAttributes;
import com.itextpdf.kernel.pdf.tagutils.AccessibilityProperties;
import com.itextpdf.kernel.pdf.tagutils.TagTreePointer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DefaultAccessibilityProperties
extends AccessibilityProperties {
    protected String role;
    protected String language;
    protected String actualText;
    protected String alternateDescription;
    protected String expansion;
    protected List<PdfStructureAttributes> attributesList = new ArrayList<PdfStructureAttributes>();
    protected String phoneme;
    protected String phoneticAlphabet;
    protected PdfNamespace namespace;
    protected List<TagTreePointer> refs = new ArrayList<TagTreePointer>();

    public DefaultAccessibilityProperties(String role) {
        this.role = role;
    }

    @Override
    public String getRole() {
        return this.role;
    }

    @Override
    public AccessibilityProperties setRole(String role) {
        this.role = role;
        return this;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public AccessibilityProperties setLanguage(String language) {
        this.language = language;
        return this;
    }

    @Override
    public String getActualText() {
        return this.actualText;
    }

    @Override
    public AccessibilityProperties setActualText(String actualText) {
        this.actualText = actualText;
        return this;
    }

    @Override
    public String getAlternateDescription() {
        return this.alternateDescription;
    }

    @Override
    public AccessibilityProperties setAlternateDescription(String alternateDescription) {
        this.alternateDescription = alternateDescription;
        return this;
    }

    @Override
    public String getExpansion() {
        return this.expansion;
    }

    @Override
    public AccessibilityProperties setExpansion(String expansion) {
        this.expansion = expansion;
        return this;
    }

    @Override
    public AccessibilityProperties addAttributes(PdfStructureAttributes attributes) {
        return this.addAttributes(-1, attributes);
    }

    @Override
    public AccessibilityProperties addAttributes(int index, PdfStructureAttributes attributes) {
        if (attributes != null) {
            if (index > 0) {
                this.attributesList.add(index, attributes);
            } else {
                this.attributesList.add(attributes);
            }
        }
        return this;
    }

    @Override
    public AccessibilityProperties clearAttributes() {
        this.attributesList.clear();
        return this;
    }

    @Override
    public List<PdfStructureAttributes> getAttributesList() {
        return this.attributesList;
    }

    @Override
    public String getPhoneme() {
        return this.phoneme;
    }

    @Override
    public AccessibilityProperties setPhoneme(String phoneme) {
        this.phoneme = phoneme;
        return this;
    }

    @Override
    public String getPhoneticAlphabet() {
        return this.phoneticAlphabet;
    }

    @Override
    public AccessibilityProperties setPhoneticAlphabet(String phoneticAlphabet) {
        this.phoneticAlphabet = phoneticAlphabet;
        return this;
    }

    @Override
    public PdfNamespace getNamespace() {
        return this.namespace;
    }

    @Override
    public AccessibilityProperties setNamespace(PdfNamespace namespace) {
        this.namespace = namespace;
        return this;
    }

    @Override
    public AccessibilityProperties addRef(TagTreePointer treePointer) {
        this.refs.add(new TagTreePointer(treePointer));
        return this;
    }

    @Override
    public List<TagTreePointer> getRefsList() {
        return Collections.unmodifiableList(this.refs);
    }

    @Override
    public AccessibilityProperties clearRefs() {
        this.refs.clear();
        return this;
    }
}

