/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.kernel.colors.ColorConstants;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.borders.SolidBorder;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.margincollapse.MarginsCollapseHandler;
import com.itextpdf.layout.minmaxwidth.MinMaxWidth;
import com.itextpdf.layout.property.ClearPropertyValue;
import com.itextpdf.layout.property.FloatPropertyValue;
import com.itextpdf.layout.property.OverflowPropertyValue;
import com.itextpdf.layout.property.UnitValue;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.TableRenderer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FloatingHelper {
    private FloatingHelper() {
    }

    static void adjustLineAreaAccordingToFloats(List<Rectangle> floatRendererAreas, Rectangle layoutBox) {
        FloatingHelper.adjustLayoutBoxAccordingToFloats(floatRendererAreas, layoutBox, null, 0.0f, null);
    }

    static float adjustLayoutBoxAccordingToFloats(List<Rectangle> floatRendererAreas, Rectangle layoutBox, Float boxWidth, float clearHeightCorrection, MarginsCollapseHandler marginsCollapseHandler) {
        float left;
        float right;
        float topShift = clearHeightCorrection;
        Rectangle[] lastLeftAndRightBoxes = null;
        do {
            List<Rectangle> boxesAtYLevel;
            if (lastLeftAndRightBoxes != null) {
                float bottomLeft = lastLeftAndRightBoxes[0] != null ? lastLeftAndRightBoxes[0].getBottom() : Float.MAX_VALUE;
                float bottomRight = lastLeftAndRightBoxes[1] != null ? lastLeftAndRightBoxes[1].getBottom() : Float.MAX_VALUE;
                float updatedHeight = Math.min(bottomLeft, bottomRight) - layoutBox.getY();
                topShift = layoutBox.getHeight() - updatedHeight;
            }
            if ((boxesAtYLevel = FloatingHelper.getBoxesAtYLevel(floatRendererAreas, layoutBox.getTop() - topShift)).isEmpty()) {
                FloatingHelper.applyClearance(layoutBox, marginsCollapseHandler, topShift, false);
                return topShift;
            }
            lastLeftAndRightBoxes = FloatingHelper.findLastLeftAndRightBoxes(layoutBox, boxesAtYLevel);
            left = lastLeftAndRightBoxes[0] != null ? lastLeftAndRightBoxes[0].getRight() : Float.MIN_VALUE;
            float f = right = lastLeftAndRightBoxes[1] != null ? lastLeftAndRightBoxes[1].getLeft() : Float.MAX_VALUE;
            if (left > right || left > layoutBox.getRight() || right < layoutBox.getLeft()) {
                right = left = layoutBox.getLeft();
                continue;
            }
            if (right > layoutBox.getRight()) {
                right = layoutBox.getRight();
            }
            if (!(left < layoutBox.getLeft())) continue;
            left = layoutBox.getLeft();
        } while (boxWidth != null && boxWidth.floatValue() > right - left);
        if (layoutBox.getWidth() > right - left) {
            layoutBox.setX(left).setWidth(right - left);
        }
        FloatingHelper.applyClearance(layoutBox, marginsCollapseHandler, topShift, false);
        return topShift;
    }

    static Float calculateLineShiftUnderFloats(List<Rectangle> floatRendererAreas, Rectangle layoutBox) {
        float right;
        List<Rectangle> boxesAtYLevel = FloatingHelper.getBoxesAtYLevel(floatRendererAreas, layoutBox.getTop());
        if (boxesAtYLevel.isEmpty()) {
            return null;
        }
        Rectangle[] lastLeftAndRightBoxes = FloatingHelper.findLastLeftAndRightBoxes(layoutBox, boxesAtYLevel);
        float left = lastLeftAndRightBoxes[0] != null ? lastLeftAndRightBoxes[0].getRight() : layoutBox.getLeft();
        float f = right = lastLeftAndRightBoxes[1] != null ? lastLeftAndRightBoxes[1].getLeft() : layoutBox.getRight();
        if (layoutBox.getLeft() < left || layoutBox.getRight() > right) {
            float maxLastFloatBottom = lastLeftAndRightBoxes[0] != null && lastLeftAndRightBoxes[1] != null ? Math.max(lastLeftAndRightBoxes[0].getBottom(), lastLeftAndRightBoxes[1].getBottom()) : (lastLeftAndRightBoxes[0] != null ? lastLeftAndRightBoxes[0].getBottom() : lastLeftAndRightBoxes[1].getBottom());
            return Float.valueOf(layoutBox.getTop() - maxLastFloatBottom + 1.0E-4f);
        }
        return null;
    }

    static void adjustFloatedTableLayoutBox(TableRenderer tableRenderer, Rectangle layoutBox, float tableWidth, List<Rectangle> floatRendererAreas, FloatPropertyValue floatPropertyValue) {
        Logger logger;
        tableRenderer.setProperty(28, null);
        UnitValue[] margins = tableRenderer.getMargins();
        if (!margins[1].isPointValue()) {
            logger = LoggerFactory.getLogger(FloatingHelper.class);
            logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{45}));
        }
        if (!margins[3].isPointValue()) {
            logger = LoggerFactory.getLogger(FloatingHelper.class);
            logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{44}));
        }
        FloatingHelper.adjustBlockAreaAccordingToFloatRenderers(floatRendererAreas, layoutBox, tableWidth + margins[1].getValue() + margins[3].getValue(), FloatPropertyValue.LEFT.equals((Object)floatPropertyValue));
    }

    static Float adjustFloatedBlockLayoutBox(AbstractRenderer renderer, Rectangle parentBBox, Float blockWidth, List<Rectangle> floatRendererAreas, FloatPropertyValue floatPropertyValue, OverflowPropertyValue overflowX) {
        float floatElemWidth;
        renderer.setProperty(28, null);
        boolean overflowFit = AbstractRenderer.isOverflowFit(overflowX);
        if (blockWidth != null) {
            floatElemWidth = blockWidth.floatValue() + AbstractRenderer.calculateAdditionalWidth(renderer);
            if (overflowFit && floatElemWidth > parentBBox.getWidth()) {
                floatElemWidth = parentBBox.getWidth();
            }
        } else {
            MinMaxWidth minMaxWidth = FloatingHelper.calculateMinMaxWidthForFloat(renderer, floatPropertyValue);
            float maxWidth = minMaxWidth.getMaxWidth();
            if (maxWidth > parentBBox.getWidth()) {
                maxWidth = parentBBox.getWidth();
            }
            if (!overflowFit && minMaxWidth.getMinWidth() > parentBBox.getWidth()) {
                maxWidth = minMaxWidth.getMinWidth();
            }
            floatElemWidth = maxWidth + 1.0E-4f;
            blockWidth = Float.valueOf(maxWidth - minMaxWidth.getAdditionalWidth() + 1.0E-4f);
        }
        FloatingHelper.adjustBlockAreaAccordingToFloatRenderers(floatRendererAreas, parentBBox, floatElemWidth, FloatPropertyValue.LEFT.equals((Object)floatPropertyValue));
        return blockWidth;
    }

    private static void adjustBlockAreaAccordingToFloatRenderers(List<Rectangle> floatRendererAreas, Rectangle layoutBox, float blockWidth, boolean isFloatLeft) {
        if (floatRendererAreas.isEmpty()) {
            if (!isFloatLeft) {
                FloatingHelper.adjustBoxForFloatRight(layoutBox, blockWidth);
            }
            return;
        }
        float currY = floatRendererAreas.get(floatRendererAreas.size() - 1).getTop() < layoutBox.getTop() ? floatRendererAreas.get(floatRendererAreas.size() - 1).getTop() : layoutBox.getTop();
        Rectangle[] lastLeftAndRightBoxes = null;
        float left = 0.0f;
        float right = 0.0f;
        while (lastLeftAndRightBoxes == null || right - left < blockWidth) {
            if (lastLeftAndRightBoxes != null) {
                currY = isFloatLeft ? (lastLeftAndRightBoxes[0] != null ? lastLeftAndRightBoxes[0].getBottom() : lastLeftAndRightBoxes[1].getBottom()) : (lastLeftAndRightBoxes[1] != null ? lastLeftAndRightBoxes[1].getBottom() : lastLeftAndRightBoxes[0].getBottom());
            }
            layoutBox.setHeight(currY - layoutBox.getY());
            List<Rectangle> yLevelBoxes = FloatingHelper.getBoxesAtYLevel(floatRendererAreas, currY);
            if (yLevelBoxes.isEmpty()) {
                if (!isFloatLeft) {
                    FloatingHelper.adjustBoxForFloatRight(layoutBox, blockWidth);
                }
                return;
            }
            lastLeftAndRightBoxes = FloatingHelper.findLastLeftAndRightBoxes(layoutBox, yLevelBoxes);
            left = lastLeftAndRightBoxes[0] != null ? lastLeftAndRightBoxes[0].getRight() : layoutBox.getLeft();
            right = lastLeftAndRightBoxes[1] != null ? lastLeftAndRightBoxes[1].getLeft() : layoutBox.getRight();
        }
        layoutBox.setX(left);
        layoutBox.setWidth(right - left);
        if (!isFloatLeft) {
            FloatingHelper.adjustBoxForFloatRight(layoutBox, blockWidth);
        }
    }

    static void removeFloatsAboveRendererBottom(List<Rectangle> floatRendererAreas, IRenderer renderer) {
        if (!FloatingHelper.isRendererFloating(renderer)) {
            float bottom = renderer.getOccupiedArea().getBBox().getBottom();
            for (int i = floatRendererAreas.size() - 1; i >= 0; --i) {
                if (!(floatRendererAreas.get(i).getBottom() >= bottom)) continue;
                floatRendererAreas.remove(i);
            }
        }
    }

    static LayoutArea adjustResultOccupiedAreaForFloatAndClear(IRenderer renderer, List<Rectangle> floatRendererAreas, Rectangle parentBBox, float clearHeightCorrection, boolean marginsCollapsingEnabled) {
        LayoutArea occupiedArea;
        LayoutArea editedArea = occupiedArea = renderer.getOccupiedArea();
        if (FloatingHelper.isRendererFloating(renderer)) {
            editedArea = occupiedArea.clone();
            if (occupiedArea.getBBox().getWidth() > 0.0f) {
                floatRendererAreas.add(occupiedArea.getBBox());
            }
            editedArea.getBBox().setY(parentBBox.getTop());
            editedArea.getBBox().setHeight(0.0f);
        } else if (clearHeightCorrection > 0.0f && !marginsCollapsingEnabled) {
            editedArea = occupiedArea.clone();
            editedArea.getBBox().increaseHeight(clearHeightCorrection);
        }
        return editedArea;
    }

    static void includeChildFloatsInOccupiedArea(List<Rectangle> floatRendererAreas, IRenderer renderer, Set<Rectangle> nonChildFloatingRendererAreas) {
        Rectangle commonRectangle = FloatingHelper.includeChildFloatsInOccupiedArea(floatRendererAreas, renderer.getOccupiedArea().getBBox(), nonChildFloatingRendererAreas);
        renderer.getOccupiedArea().setBBox(commonRectangle);
    }

    static Rectangle includeChildFloatsInOccupiedArea(List<Rectangle> floatRendererAreas, Rectangle occupiedAreaBbox, Set<Rectangle> nonChildFloatingRendererAreas) {
        for (Rectangle floatBox : floatRendererAreas) {
            if (nonChildFloatingRendererAreas.contains(floatBox)) continue;
            occupiedAreaBbox = Rectangle.getCommonRectangle((Rectangle[])new Rectangle[]{occupiedAreaBbox, floatBox});
        }
        return occupiedAreaBbox;
    }

    static MinMaxWidth calculateMinMaxWidthForFloat(AbstractRenderer renderer, FloatPropertyValue floatPropertyVal) {
        boolean floatPropIsRendererOwn = renderer.hasOwnProperty(99);
        renderer.setProperty(99, (Object)FloatPropertyValue.NONE);
        MinMaxWidth kidMinMaxWidth = renderer.getMinMaxWidth();
        if (floatPropIsRendererOwn) {
            renderer.setProperty(99, (Object)floatPropertyVal);
        } else {
            renderer.deleteOwnProperty(99);
        }
        return kidMinMaxWidth;
    }

    static float calculateClearHeightCorrection(IRenderer renderer, List<Rectangle> floatRendererAreas, Rectangle parentBBox) {
        ClearPropertyValue clearPropertyValue = (ClearPropertyValue)((Object)renderer.getProperty(100));
        float clearHeightCorrection = 0.0f;
        if (clearPropertyValue == null || floatRendererAreas.isEmpty()) {
            return clearHeightCorrection;
        }
        float currY = floatRendererAreas.get(floatRendererAreas.size() - 1).getTop() < parentBBox.getTop() ? floatRendererAreas.get(floatRendererAreas.size() - 1).getTop() : parentBBox.getTop();
        List<Rectangle> boxesAtYLevel = FloatingHelper.getBoxesAtYLevel(floatRendererAreas, currY);
        Rectangle[] lastLeftAndRightBoxes = FloatingHelper.findLastLeftAndRightBoxes(parentBBox, boxesAtYLevel);
        float lowestFloatBottom = Float.MAX_VALUE;
        boolean isBoth = clearPropertyValue.equals((Object)ClearPropertyValue.BOTH);
        if ((clearPropertyValue.equals((Object)ClearPropertyValue.LEFT) || isBoth) && lastLeftAndRightBoxes[0] != null) {
            for (Rectangle floatBox : floatRendererAreas) {
                if (!(floatBox.getBottom() < lowestFloatBottom) || !(floatBox.getLeft() <= lastLeftAndRightBoxes[0].getLeft())) continue;
                lowestFloatBottom = floatBox.getBottom();
            }
        }
        if ((clearPropertyValue.equals((Object)ClearPropertyValue.RIGHT) || isBoth) && lastLeftAndRightBoxes[1] != null) {
            for (Rectangle floatBox : floatRendererAreas) {
                if (!(floatBox.getBottom() < lowestFloatBottom) || !(floatBox.getRight() >= lastLeftAndRightBoxes[1].getRight())) continue;
                lowestFloatBottom = floatBox.getBottom();
            }
        }
        if (lowestFloatBottom < Float.MAX_VALUE) {
            clearHeightCorrection = parentBBox.getTop() - lowestFloatBottom + 1.0E-4f;
        }
        return clearHeightCorrection;
    }

    static void applyClearance(Rectangle layoutBox, MarginsCollapseHandler marginsCollapseHandler, float clearHeightAdjustment, boolean isFloat) {
        if (clearHeightAdjustment <= 0.0f) {
            return;
        }
        if (marginsCollapseHandler == null || isFloat) {
            layoutBox.decreaseHeight(clearHeightAdjustment);
        } else {
            marginsCollapseHandler.applyClearance(clearHeightAdjustment);
        }
    }

    static boolean isRendererFloating(IRenderer renderer) {
        return FloatingHelper.isRendererFloating(renderer, (FloatPropertyValue)((Object)renderer.getProperty(99)));
    }

    static boolean isRendererFloating(IRenderer renderer, FloatPropertyValue kidFloatPropertyVal) {
        Integer position = (Integer)renderer.getProperty(52);
        boolean notAbsolutePos = position == null || position != 3;
        return notAbsolutePos && kidFloatPropertyVal != null && !kidFloatPropertyVal.equals((Object)FloatPropertyValue.NONE);
    }

    static boolean isClearanceApplied(List<IRenderer> floatingRenderers, ClearPropertyValue clearPropertyValue) {
        if (clearPropertyValue == null || clearPropertyValue.equals((Object)ClearPropertyValue.NONE)) {
            return false;
        }
        for (IRenderer floatingRenderer : floatingRenderers) {
            FloatPropertyValue floatPropertyValue = (FloatPropertyValue)((Object)floatingRenderer.getProperty(99));
            if (!clearPropertyValue.equals((Object)ClearPropertyValue.BOTH) && (!floatPropertyValue.equals((Object)FloatPropertyValue.LEFT) || !clearPropertyValue.equals((Object)ClearPropertyValue.LEFT)) && (!floatPropertyValue.equals((Object)FloatPropertyValue.RIGHT) || !clearPropertyValue.equals((Object)ClearPropertyValue.RIGHT))) continue;
            return true;
        }
        return false;
    }

    static void removeParentArtifactsOnPageSplitIfOnlyFloatsOverflow(IRenderer overflowRenderer) {
        overflowRenderer.setProperty(6, null);
        overflowRenderer.setProperty(90, null);
        overflowRenderer.setProperty(106, null);
        Border[] borders = AbstractRenderer.getBorders(overflowRenderer);
        overflowRenderer.setProperty(13, null);
        overflowRenderer.setProperty(10, null);
        if (borders[1] != null) {
            overflowRenderer.setProperty(12, new SolidBorder(ColorConstants.BLACK, borders[1].getWidth(), 0.0f));
        }
        if (borders[3] != null) {
            overflowRenderer.setProperty(11, new SolidBorder(ColorConstants.BLACK, borders[3].getWidth(), 0.0f));
        }
        overflowRenderer.setProperty(46, UnitValue.createPointValue(0.0f));
        overflowRenderer.setProperty(43, UnitValue.createPointValue(0.0f));
        overflowRenderer.setProperty(50, UnitValue.createPointValue(0.0f));
        overflowRenderer.setProperty(47, UnitValue.createPointValue(0.0f));
    }

    private static void adjustBoxForFloatRight(Rectangle layoutBox, float blockWidth) {
        layoutBox.setX(layoutBox.getRight() - blockWidth);
        layoutBox.setWidth(blockWidth);
    }

    private static Rectangle[] findLastLeftAndRightBoxes(Rectangle layoutBox, List<Rectangle> yLevelBoxes) {
        Rectangle lastLeftFloatAtY = null;
        Rectangle lastRightFloatAtY = null;
        float left = layoutBox.getLeft();
        for (Rectangle box : yLevelBoxes) {
            if (!(box.getLeft() < left)) continue;
            left = box.getLeft();
        }
        for (Rectangle box : yLevelBoxes) {
            if (left >= box.getLeft() && left < box.getRight()) {
                lastLeftFloatAtY = box;
                left = box.getRight();
                continue;
            }
            lastRightFloatAtY = box;
        }
        return new Rectangle[]{lastLeftFloatAtY, lastRightFloatAtY};
    }

    private static List<Rectangle> getBoxesAtYLevel(List<Rectangle> floatRendererAreas, float currY) {
        ArrayList<Rectangle> yLevelBoxes = new ArrayList<Rectangle>();
        for (Rectangle box : floatRendererAreas) {
            if (!(box.getBottom() + 1.0E-4f < currY) || !(box.getTop() + 1.0E-4f >= currY)) continue;
            yLevelBoxes.add(box);
        }
        return yLevelBoxes;
    }
}

