/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfa.checker;

import com.itextpdf.kernel.pdf.PdfAConformanceLevel;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.pdfa.PdfAConformanceException;
import com.itextpdf.pdfa.checker.PdfA2Checker;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class PdfA3Checker
extends PdfA2Checker {
    protected static final Set<PdfName> allowedAFRelationships = new HashSet<PdfName>(Arrays.asList(PdfName.Source, PdfName.Data, PdfName.Alternative, PdfName.Supplement, PdfName.Unspecified));
    private static final long serialVersionUID = 6280825718658124941L;

    public PdfA3Checker(PdfAConformanceLevel conformanceLevel) {
        super(conformanceLevel);
    }

    @Override
    protected void checkFileSpec(PdfDictionary fileSpec) {
        PdfName relationship = fileSpec.getAsName(PdfName.AFRelationship);
        if (relationship == null || !allowedAFRelationships.contains(relationship)) {
            throw new PdfAConformanceException("File specification dictionary shall contain one of the predefined afrelationship keys");
        }
        if (fileSpec.containsKey(PdfName.EF)) {
            if (!(fileSpec.containsKey(PdfName.F) && fileSpec.containsKey(PdfName.UF) && fileSpec.containsKey(PdfName.Desc))) {
                throw new PdfAConformanceException("File specification dictionary shall contain f key uf key and desc key");
            }
            PdfDictionary ef = fileSpec.getAsDictionary(PdfName.EF);
            PdfStream embeddedFile = ef.getAsStream(PdfName.F);
            if (embeddedFile == null) {
                throw new PdfAConformanceException("Ef key of file specification dictionary shall contain dictionary with valid f key");
            }
            if (!embeddedFile.containsKey(PdfName.Subtype)) {
                throw new PdfAConformanceException("Mime type shall be specified using the subtype key of the file specification stream dictionary");
            }
            PdfDictionary params = embeddedFile.getAsDictionary(PdfName.Params);
            if (params == null) {
                throw new PdfAConformanceException("Embedded file shall contain params key with dictionary as value");
            }
            if (params.getAsString(PdfName.ModDate) == null) {
                throw new PdfAConformanceException("Embedded file shall contain params key with valid moddate key");
            }
        }
    }
}

