/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.v1;

import com.itextpdf.signatures.ICrlClient;
import com.itextpdf.signatures.IOcspClient;
import com.itextpdf.signatures.validation.v1.ValidationCrlClient;
import com.itextpdf.signatures.validation.v1.ValidationOcspClient;
import com.itextpdf.signatures.validation.v1.context.CertificateSource;
import com.itextpdf.signatures.validation.v1.context.CertificateSources;
import com.itextpdf.signatures.validation.v1.context.TimeBasedContext;
import com.itextpdf.signatures.validation.v1.context.TimeBasedContexts;
import com.itextpdf.signatures.validation.v1.context.ValidationContext;
import com.itextpdf.signatures.validation.v1.context.ValidatorContext;
import com.itextpdf.signatures.validation.v1.context.ValidatorContexts;
import com.itextpdf.signatures.validation.v1.extensions.CertificateExtension;
import com.itextpdf.signatures.validation.v1.extensions.DynamicBasicConstraintsExtension;
import com.itextpdf.signatures.validation.v1.extensions.ExtendedKeyUsageExtension;
import com.itextpdf.signatures.validation.v1.extensions.KeyUsage;
import com.itextpdf.signatures.validation.v1.extensions.KeyUsageExtension;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

public class SignatureValidationProperties {
    public static final boolean DEFAULT_CONTINUE_AFTER_FAILURE = true;
    public static final Duration DEFAULT_FRESHNESS_PRESENT_CRL = Duration.ofDays(30L);
    public static final Duration DEFAULT_FRESHNESS_PRESENT_OCSP = Duration.ofDays(30L);
    public static final Duration DEFAULT_FRESHNESS_HISTORICAL = Duration.ofMinutes(1L);
    public static final OnlineFetching DEFAULT_ONLINE_FETCHING = OnlineFetching.FETCH_IF_NO_OTHER_DATA_AVAILABLE;
    private final HashMap<ValidationContext, ContextProperties> properties = new HashMap();
    private final List<IOcspClient> ocspClients = new ArrayList<IOcspClient>();
    private final List<ICrlClient> crlClients = new ArrayList<ICrlClient>();

    public SignatureValidationProperties() {
        this.setContinueAfterFailure(ValidatorContexts.all(), CertificateSources.all(), true);
        this.setRevocationOnlineFetching(ValidatorContexts.all(), CertificateSources.all(), TimeBasedContexts.all(), DEFAULT_ONLINE_FETCHING);
        this.setFreshness(ValidatorContexts.all(), CertificateSources.all(), TimeBasedContexts.of(TimeBasedContext.HISTORICAL, new TimeBasedContext[0]), DEFAULT_FRESHNESS_HISTORICAL);
        this.setFreshness(ValidatorContexts.all(), CertificateSources.all(), TimeBasedContexts.of(TimeBasedContext.PRESENT, new TimeBasedContext[0]), DEFAULT_FRESHNESS_PRESENT_OCSP);
        this.setFreshness(ValidatorContexts.of(ValidatorContext.CRL_VALIDATOR, new ValidatorContext[0]), CertificateSources.all(), TimeBasedContexts.of(TimeBasedContext.PRESENT, new TimeBasedContext[0]), DEFAULT_FRESHNESS_PRESENT_CRL);
        this.setRequiredExtensions(CertificateSources.of(CertificateSource.CRL_ISSUER, new CertificateSource[0]), Collections.singletonList(new KeyUsageExtension(KeyUsage.CRL_SIGN)));
        this.setRequiredExtensions(CertificateSources.of(CertificateSource.OCSP_ISSUER, new CertificateSource[0]), Collections.singletonList(new ExtendedKeyUsageExtension(Collections.singletonList("1.3.6.1.5.5.7.3.9"))));
        this.setRequiredExtensions(CertificateSources.of(CertificateSource.SIGNER_CERT, new CertificateSource[0]), Collections.singletonList(new KeyUsageExtension(KeyUsage.NON_REPUDIATION)));
        ArrayList<CertificateExtension> certIssuerRequiredExtensions = new ArrayList<CertificateExtension>();
        certIssuerRequiredExtensions.add(new KeyUsageExtension(KeyUsage.KEY_CERT_SIGN));
        certIssuerRequiredExtensions.add(new DynamicBasicConstraintsExtension());
        this.setRequiredExtensions(CertificateSources.of(CertificateSource.CERT_ISSUER, new CertificateSource[0]), certIssuerRequiredExtensions);
        this.setRequiredExtensions(CertificateSources.of(CertificateSource.TIMESTAMP, new CertificateSource[0]), Collections.singletonList(new ExtendedKeyUsageExtension(Collections.singletonList("1.3.6.1.5.5.7.3.8"))));
        this.ocspClients.add(new ValidationOcspClient());
        this.crlClients.add(new ValidationCrlClient());
    }

    public Duration getFreshness(ValidationContext validationContext) {
        return this.getParametersValueFor(validationContext.getValidatorContext(), validationContext.getCertificateSource(), validationContext.getTimeBasedContext(), p -> p.getFreshness());
    }

    public final SignatureValidationProperties setFreshness(ValidatorContexts validatorContexts, CertificateSources certificateSources, TimeBasedContexts timeBasedContexts, Duration value) {
        this.setParameterValueFor(validatorContexts.getSet(), certificateSources.getSet(), timeBasedContexts.getSet(), p -> p.setFreshness(value));
        return this;
    }

    public boolean getContinueAfterFailure(ValidationContext validationContext) {
        return this.getParametersValueFor(validationContext.getValidatorContext(), validationContext.getCertificateSource(), validationContext.getTimeBasedContext(), p -> p.getContinueAfterFailure());
    }

    public final SignatureValidationProperties setContinueAfterFailure(ValidatorContexts validatorContexts, CertificateSources certificateSources, boolean value) {
        this.setParameterValueFor(validatorContexts.getSet(), certificateSources.getSet(), TimeBasedContexts.all().getSet(), p -> p.setContinueAfterFailure(value));
        return this;
    }

    public OnlineFetching getRevocationOnlineFetching(ValidationContext validationContext) {
        return this.getParametersValueFor(validationContext.getValidatorContext(), validationContext.getCertificateSource(), validationContext.getTimeBasedContext(), p -> p.getOnlineFetching());
    }

    public final SignatureValidationProperties setRevocationOnlineFetching(ValidatorContexts validatorContexts, CertificateSources certificateSources, TimeBasedContexts timeBasedContexts, OnlineFetching onlineFetching) {
        this.setParameterValueFor(validatorContexts.getSet(), certificateSources.getSet(), timeBasedContexts.getSet(), p -> p.setOnlineFetching(onlineFetching));
        return this;
    }

    public List<CertificateExtension> getRequiredExtensions(ValidationContext validationContext) {
        return this.getParametersValueFor(validationContext.getValidatorContext(), validationContext.getCertificateSource(), validationContext.getTimeBasedContext(), p -> p.getRequiredExtensions());
    }

    public final SignatureValidationProperties setRequiredExtensions(CertificateSources certificateSources, List<CertificateExtension> requiredExtensions) {
        List<CertificateExtension> copy = Collections.unmodifiableList(new ArrayList<CertificateExtension>(requiredExtensions));
        this.setParameterValueFor(ValidatorContexts.all().getSet(), certificateSources.getSet(), TimeBasedContexts.all().getSet(), p -> p.setRequiredExtensions(copy));
        return this;
    }

    public List<ICrlClient> getCrlClients() {
        return Collections.unmodifiableList(this.crlClients);
    }

    public final SignatureValidationProperties addCrlClient(ICrlClient crlClient) {
        this.crlClients.add(crlClient);
        return this;
    }

    public List<IOcspClient> getOcspClients() {
        return Collections.unmodifiableList(this.ocspClients);
    }

    public final SignatureValidationProperties addOcspClient(IOcspClient ocspClient) {
        this.ocspClients.add(ocspClient);
        return this;
    }

    final void setParameterValueFor(EnumSet<ValidatorContext> validatorContexts, EnumSet<CertificateSource> certificateSources, EnumSet<TimeBasedContext> timeBasedContexts, Consumer<ContextProperties> setter) {
        for (ValidatorContext validatorContext : validatorContexts) {
            for (CertificateSource certificateSource : certificateSources) {
                for (TimeBasedContext timeBasedContext : timeBasedContexts) {
                    ValidationContext vc = new ValidationContext(validatorContext, certificateSource, timeBasedContext);
                    ContextProperties cProperties = this.properties.computeIfAbsent(vc, unused -> new ContextProperties());
                    setter.accept(cProperties);
                }
            }
        }
    }

    <T> T getParametersValueFor(ValidatorContext validatorContext, CertificateSource certSource, TimeBasedContext timeBasedContext, Function<ContextProperties, T> getter) {
        ValidationContext c = new ValidationContext(validatorContext, certSource, timeBasedContext);
        if (this.properties.containsKey(c)) {
            return getter.apply(this.properties.get(c));
        }
        return null;
    }

    static class ContextProperties {
        private Duration freshness;
        private Boolean continueAfterFailure;
        private OnlineFetching onlineFetching;
        private List<CertificateExtension> requiredExtensions;

        public Boolean getContinueAfterFailure() {
            return this.continueAfterFailure;
        }

        public void setContinueAfterFailure(Boolean continueAfterFailure) {
            this.continueAfterFailure = continueAfterFailure;
        }

        public Duration getFreshness() {
            return this.freshness;
        }

        public void setFreshness(Duration value) {
            this.freshness = value;
        }

        public OnlineFetching getOnlineFetching() {
            return this.onlineFetching;
        }

        public void setOnlineFetching(OnlineFetching onlineFetching) {
            this.onlineFetching = onlineFetching;
        }

        public List<CertificateExtension> getRequiredExtensions() {
            return this.requiredExtensions;
        }

        public void setRequiredExtensions(List<CertificateExtension> requiredExtensions) {
            this.requiredExtensions = requiredExtensions;
        }
    }

    public static enum OnlineFetching {
        ALWAYS_FETCH,
        FETCH_IF_NO_OTHER_DATA_AVAILABLE,
        NEVER_FETCH;

    }
}

