/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.svg.graphic;

import com.itextpdf.awt.geom.AffineTransform;
import com.itextpdf.text.Element;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.tool.xml.svg.tags.Graphic;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Group
extends Graphic {
    final List<Element> list;
    final float width;
    final float height;
    final float x;
    final float y;
    final boolean applyCSSToElements;

    public Group(List<Element> list, float x, float y, float width, float height, Map<String, String> css, boolean applyCSSToElements) {
        super(css);
        this.list = list;
        this.width = width;
        this.height = height;
        this.x = x;
        this.y = y;
        this.applyCSSToElements = applyCSSToElements;
    }

    @Override
    public void draw(PdfContentByte cb) {
        PdfTemplate template = cb.createTemplate(500.0f, 500.0f);
        for (Element elem : this.list) {
            Graphic graphic = (Graphic)elem;
            if (this.applyCSSToElements) {
                graphic.draw((PdfContentByte)template, this.getCombinedCss(graphic.getCss(), this.getCss()));
                continue;
            }
            graphic.draw((PdfContentByte)template, graphic.getCss());
        }
        cb.concatCTM(AffineTransform.getTranslateInstance((double)this.x, (double)this.y));
        cb.add((PdfContentByte)template);
    }

    private Map<String, String> getCombinedCss(Map<String, String> element, Map<String, String> parent) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.putAll(parent);
        result.putAll(element);
        return result;
    }
}

