/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.reader.filter;

import com.jayway.jsonpath.reader.filter.Filter;
import com.jayway.jsonpath.spi.JsonProvider;
import java.util.List;

public class ArrayIndexFilter
extends Filter {
    public ArrayIndexFilter(String condition) {
        super(condition);
    }

    public Object filter(Object obj, JsonProvider jsonProvider) {
        List<Object> src = jsonProvider.toList(obj);
        List<Object> result = jsonProvider.createList();
        String trimmedCondition = this.trim(this.condition, 1, 1);
        if (trimmedCondition.contains("@.length")) {
            trimmedCondition = this.trim(trimmedCondition, 1, 1);
            trimmedCondition = trimmedCondition.replace("@.length", "");
            trimmedCondition = trimmedCondition + ":";
        }
        if (trimmedCondition.startsWith(":")) {
            trimmedCondition = this.trim(trimmedCondition, 1, 0);
            int get = Integer.parseInt(trimmedCondition);
            for (int i = 0; i < get; ++i) {
                result.add(src.get(i));
            }
            return result;
        }
        if (trimmedCondition.endsWith(":")) {
            trimmedCondition = this.trim(trimmedCondition, 1, 1);
            int get = Integer.parseInt(trimmedCondition);
            return src.get(src.size() - get);
        }
        String[] indexArr = trimmedCondition.split(",");
        if (indexArr.length == 1) {
            return src.get(Integer.parseInt(indexArr[0]));
        }
        for (String idx : indexArr) {
            result.add(src.get(Integer.parseInt(idx.trim())));
        }
        return result;
    }
}

