/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.spi.impl;

import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.spi.JsonProvider;
import com.jayway.jsonpath.spi.Mode;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonSmartProvider
extends JsonProvider {
    private Mode mode;
    private JSONParser parser;

    public JsonSmartProvider() {
        this(Mode.SLACK);
    }

    public JsonSmartProvider(Mode mode) {
        this.mode = mode;
        this.parser = new JSONParser(mode.intValue());
    }

    @Override
    public Map<String, Object> createMap() {
        return new JSONObject();
    }

    @Override
    public List<Object> createList() {
        return new JSONArray();
    }

    @Override
    public Object parse(String json) {
        try {
            return this.parser.parse(json);
        }
        catch (ParseException e) {
            throw new InvalidJsonException(e);
        }
    }

    @Override
    public String toJson(Object obj) {
        if (!(obj instanceof JSONAware)) {
            throw new InvalidJsonException();
        }
        JSONAware aware = (JSONAware)obj;
        return aware.toJSONString();
    }

    @Override
    public Mode getMode() {
        return this.mode;
    }
}

