/*
 * Decompiled with CFR 0.152.
 */
package com.jptangchina.jxcel;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.jptangchina.jxcel.annotation.JxcelCell;
import com.jptangchina.jxcel.annotation.JxcelSheet;
import com.jptangchina.jxcel.exception.JxcelGenerateException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JxcelGenrator {
    private static final Logger log = LoggerFactory.getLogger(JxcelGenrator.class);
    private Workbook workbook;

    public Workbook generateWorkbook(List<?> data) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(data), (Object)"Data must not be empty.");
        Class<?> type = data.get(0).getClass();
        Map<String, Field> headers = this.getSheetHeaderWithOrder(type);
        Preconditions.checkArgument((headers.size() > 0 ? 1 : 0) != 0, (Object)"No available field.");
        CellStyle headerStyle = this.createHeaderStyle(type, this.workbook);
        Sheet sheet = this.createSheet(type, this.workbook);
        AtomicInteger cellIndex = new AtomicInteger(0);
        AtomicInteger rowIndex = new AtomicInteger(1);
        this.createHeaderRow(sheet, headers, cellIndex, headerStyle);
        this.createDataRows(data, headers, cellIndex, rowIndex, sheet);
        this.resizeColumn(headers, sheet);
        return this.workbook;
    }

    public void generateFile(List<?> data, String outputPath) {
        try (FileOutputStream fos = new FileOutputStream(outputPath);
             Workbook workbook = this.generateWorkbook(data);){
            workbook.write((OutputStream)fos);
            fos.flush();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new JxcelGenerateException("File generate failed.");
        }
    }

    private Map<String, Field> getSheetHeaderWithOrder(Class<?> type) {
        LinkedHashMap<String, Field> result = new LinkedHashMap<String, Field>();
        List<Field> fields = Arrays.stream(type.getDeclaredFields()).filter(f -> f.isAnnotationPresent(JxcelCell.class)).sorted(Comparator.comparingInt(f -> f.getAnnotation(JxcelCell.class).order())).collect(Collectors.toList());
        fields.forEach(f -> result.put(f.getName(), (Field)f));
        return result;
    }

    private void setStringCellValue(Object obj, Cell cell, Field field) throws IllegalAccessException {
        JxcelCell jxcelCell = field.getAnnotation(JxcelCell.class);
        field.setAccessible(true);
        Object value = field.get(obj);
        if (field.getType() == Date.class) {
            DateTime time = new DateTime(value);
            if (!Strings.isNullOrEmpty((String)jxcelCell.format())) {
                value = time.toString(jxcelCell.format());
            }
        }
        if (jxcelCell.parse().length > 0) {
            if (Boolean.class.equals(field.getType()) || Boolean.TYPE.equals(field.getType())) {
                int index = Boolean.valueOf(value.toString()) != false ? 1 : 0;
                value = jxcelCell.parse()[index];
            } else {
                int index = (Integer)value;
                value = jxcelCell.parse()[index];
            }
        }
        value = value + jxcelCell.suffix();
        cell.setCellValue(value.toString());
    }

    private Sheet createSheet(Class<?> type, Workbook workbook) {
        JxcelSheet jxcelSheet = type.getAnnotation(JxcelSheet.class);
        Sheet sheet = null != jxcelSheet ? (Strings.isNullOrEmpty((String)jxcelSheet.value()) ? workbook.createSheet() : workbook.createSheet(jxcelSheet.value())) : workbook.createSheet();
        return sheet;
    }

    private CellStyle createHeaderStyle(Class<?> type, Workbook workbook) {
        JxcelSheet jxcelSheet = type.getAnnotation(JxcelSheet.class);
        CellStyle style = workbook.createCellStyle();
        if (null == jxcelSheet) {
            return style;
        }
        if (jxcelSheet.color() > -1) {
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            style.setFillForegroundColor(jxcelSheet.color());
        }
        return style;
    }

    private void createDataRows(List<?> data, Map<String, Field> headers, AtomicInteger cellIndex, AtomicInteger rowIndex, Sheet sheet) {
        data.forEach(d -> {
            Row row = sheet.createRow(rowIndex.getAndIncrement());
            headers.values().forEach(f -> {
                Cell cell = row.createCell(cellIndex.getAndIncrement(), CellType.STRING);
                try {
                    this.setStringCellValue(d, cell, (Field)f);
                }
                catch (IllegalAccessException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw new JxcelGenerateException("Can not get value.");
                }
            });
        });
    }

    private void createHeaderRow(Sheet sheet, Map<String, Field> headers, AtomicInteger cellIndex, CellStyle style) {
        Row head = sheet.createRow(0);
        headers.forEach((k, v) -> {
            Cell cell = head.createCell(cellIndex.getAndIncrement(), CellType.STRING);
            JxcelCell jxcelCell = v.getAnnotation(JxcelCell.class);
            String headName = Strings.isNullOrEmpty((String)jxcelCell.value()) ? v.getName() : jxcelCell.value();
            cell.setCellStyle(style);
            cell.setCellValue(headName);
        });
        cellIndex.set(0);
    }

    private void resizeColumn(Map<String, Field> headers, Sheet sheet) {
        int index = 0;
        for (Field field : headers.values()) {
            JxcelCell jxcelCell = field.getAnnotation(JxcelCell.class);
            if (jxcelCell.autoResize()) {
                sheet.autoSizeColumn(index, true);
            }
            ++index;
        }
    }

    public static JxcelGenrator xlsGenrator() {
        return new JxcelGenrator((Workbook)new HSSFWorkbook());
    }

    public static JxcelGenrator xlsxGenrator() {
        return new JxcelGenrator((Workbook)new XSSFWorkbook());
    }

    public JxcelGenrator(Workbook workbook) {
        this.workbook = workbook;
    }
}

