/*
 * Decompiled with CFR 0.152.
 */
package com.jptangchina.jxcel;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.jptangchina.jxcel.annotation.JxcelCell;
import com.jptangchina.jxcel.exception.JxcelParseException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JxcelParser {
    private static final Logger log = LoggerFactory.getLogger(JxcelParser.class);

    public <T> List<T> parseFromWorkbook(Class<T> type, Workbook workbook) {
        Preconditions.checkNotNull((Object)workbook, (Object)"Workbook can not be empty.");
        Sheet sheet = workbook.getSheetAt(0);
        Preconditions.checkNotNull((Object)sheet, (Object)"Sheet can not be empty.");
        Row headRow = sheet.getRow(0);
        ArrayList headers = new ArrayList();
        headRow.cellIterator().forEachRemaining(c -> headers.add(this.getCellValueAsString((Cell)c)));
        Map<String, Field> fields = Arrays.stream(type.getDeclaredFields()).filter(f -> f.isAnnotationPresent(JxcelCell.class)).collect(Collectors.toMap(f -> f.getAnnotation(JxcelCell.class).value(), f -> f));
        ArrayList<T> parsedData = new ArrayList<T>();
        for (int rowIndex = 1; rowIndex < sheet.getLastRowNum() + 1; ++rowIndex) {
            Row row = sheet.getRow(rowIndex);
            try {
                T data = type.newInstance();
                for (int colIndex = 0; colIndex < headers.size(); ++colIndex) {
                    String cellValue = this.getCellValueAsString(row.getCell(colIndex));
                    this.invokeDataSet(data, fields.get(headers.get(colIndex)), cellValue);
                }
                parsedData.add(data);
                continue;
            }
            catch (IllegalAccessException | InstantiationException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new JxcelParseException("Can not invoke set.");
            }
        }
        return parsedData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> List<T> parseFromFile(Class<T> type, File file) {
        try (Workbook workbook = WorkbookFactory.create((File)file);){
            List<T> list = this.parseFromWorkbook(type, workbook);
            return list;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new JxcelParseException("Can not create workbook from target file.");
        }
    }

    private void invokeDataSet(Object obj, Field field, String value) throws IllegalAccessException {
        field.setAccessible(true);
        field.set(obj, this.parseStringWithMatchedType(value, field));
    }

    private Object parseStringWithMatchedType(String value, Field field) {
        JxcelCell jxcelCell = field.getAnnotation(JxcelCell.class);
        Class<?> fieldType = field.getType();
        if (jxcelCell.parse().length > 0) {
            List<String> parseData = Arrays.asList(jxcelCell.parse());
            int index = parseData.indexOf(value);
            if (index < 0) {
                return this.parseStringToBasicDataType(value, fieldType);
            }
            return index;
        }
        if (Date.class.equals(fieldType)) {
            DateTime dateTime = DateTime.parse((String)value);
            return new Date(dateTime.getMillis());
        }
        return this.parseStringToBasicDataType(value, fieldType);
    }

    private Object parseStringToBasicDataType(String value, Class<?> fieldType) {
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        if (Byte.class.equals(fieldType) || Byte.TYPE.equals(fieldType)) {
            return Byte.valueOf(value);
        }
        if (Boolean.class.equals(fieldType) || Boolean.TYPE.equals(fieldType)) {
            return Boolean.valueOf(value) != false || "1".equals(value);
        }
        if (String.class.equals(fieldType)) {
            return value;
        }
        if (Short.class.equals(fieldType) || Short.TYPE.equals(fieldType)) {
            return Short.valueOf(value);
        }
        if (Integer.class.equals(fieldType) || Integer.TYPE.equals(fieldType)) {
            return Integer.valueOf(value);
        }
        if (Long.class.equals(fieldType) || Long.TYPE.equals(fieldType)) {
            return Long.valueOf(value);
        }
        if (Float.class.equals(fieldType) || Float.TYPE.equals(fieldType)) {
            return Float.valueOf(value);
        }
        if (Double.class.equals(fieldType) || Double.TYPE.equals(fieldType)) {
            return Double.valueOf(value);
        }
        throw new JxcelParseException("Illegal data type: " + fieldType);
    }

    private String getCellValueAsString(Cell cell) {
        if (null == cell) {
            return "";
        }
        switch (cell.getCellType()) {
            case NUMERIC: {
                DecimalFormat df = new DecimalFormat();
                return df.format(cell.getNumericCellValue());
            }
        }
        return cell.getStringCellValue();
    }

    public static JxcelParser parser() {
        return new JxcelParser();
    }
}

