/*
 * Decompiled with CFR 0.152.
 */
package com.junziqian.sdk.util.http;

import com.alibaba.fastjson.JSONObject;
import com.junziqian.sdk.bean.ResultInfo;
import com.junziqian.sdk.util.CommonUtil;
import com.junziqian.sdk.util.exception.ResultInfoException;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.charset.CodingErrorAction;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;

public class HttpClientUtils {
    private static volatile HttpClientUtils httpClientUtils;
    private static Object objTg;
    private static Integer DEFAULT_CONN_TIMEOUT;
    private static Integer DEFAULT_RETRY_TIMES;
    private CloseableHttpClient client;

    private SSLConnectionSocketFactory initSSLConnectionSocketFactory() throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException, KeyManagementException {
        SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return true;
            }
        }).build();
        NoopHostnameVerifier hostnameVerifier = NoopHostnameVerifier.INSTANCE;
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)hostnameVerifier);
        return sslsf;
    }

    public HttpClientUtils() throws Exception {
        this(null, null);
    }

    public HttpClientUtils(String proxyHost, Integer proxyPort) throws Exception {
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)this.initSSLConnectionSocketFactory()).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        connManager.setValidateAfterInactivity(1000);
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setMalformedInputAction(CodingErrorAction.IGNORE).setUnmappableInputAction(CodingErrorAction.IGNORE).setCharset(Consts.UTF_8).build();
        connManager.setDefaultConnectionConfig(connectionConfig);
        connManager.setMaxTotal(100);
        connManager.setDefaultMaxPerRoute(10);
        ArrayList<BasicHeader> defaultHeaders = new ArrayList<BasicHeader>();
        defaultHeaders.add(new BasicHeader("Accept", "text/html,application/xhtml+xml,application/xml,application/json;q=0.9,*/*;q=0.8"));
        defaultHeaders.add(new BasicHeader("Accept-Language", "zh-CN,zh;q=0.8,zh-TW;q=0.7,zh-HK;q=0.5,en-US;q=0.3,en;q=0.2"));
        defaultHeaders.add(new BasicHeader("Connection", "close"));
        defaultHeaders.add(new BasicHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:59.0) Gecko/20100101 Firefox/59.0"));
        HttpHost proxy = null;
        if (proxyHost != null && !"".equals(proxyHost) && proxyPort != null) {
            proxy = new HttpHost(proxyHost, proxyPort.intValue());
        }
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(DEFAULT_CONN_TIMEOUT.intValue()).setConnectTimeout(DEFAULT_CONN_TIMEOUT.intValue()).setProxy(proxy).setConnectionRequestTimeout(DEFAULT_CONN_TIMEOUT.intValue()).build();
        HttpRequestRetryHandler myRetryHandler = new HttpRequestRetryHandler(){

            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                boolean idempotent;
                if (executionCount >= DEFAULT_RETRY_TIMES) {
                    return false;
                }
                if (exception instanceof InterruptedIOException) {
                    return false;
                }
                if (exception instanceof UnknownHostException) {
                    return false;
                }
                if (exception instanceof ConnectException) {
                    return false;
                }
                if (exception instanceof SSLException) {
                    return false;
                }
                HttpRequest request = (HttpRequest)context.getAttribute("http.request");
                boolean bl = idempotent = !(request instanceof HttpEntityEnclosingRequest);
                return idempotent;
            }
        };
        this.client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).setDefaultHeaders(defaultHeaders).setDefaultRequestConfig(requestConfig).setRetryHandler(myRetryHandler).setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();
    }

    public static HttpClientUtils getInstance(String proxyHost, Integer proxyPort) {
        try {
            return new HttpClientUtils(proxyHost, proxyPort);
        }
        catch (Exception e) {
            throw new ResultInfoException(e.getMessage(), e);
        }
    }

    public static HttpClientUtils getInstance() {
        try {
            return new HttpClientUtils();
        }
        catch (Exception e) {
            throw new ResultInfoException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpClientUtils init() {
        Object object = objTg;
        synchronized (object) {
            if (httpClientUtils == null) {
                try {
                    httpClientUtils = new HttpClientUtils();
                }
                catch (Exception e) {
                    throw new ResultInfoException("ACCESS_SIGN_ERROR", "httpClient\u521d\u59cb\u5316\u51fa\u9519", e);
                }
            }
        }
        return httpClientUtils;
    }

    public static URI builderUrl(String url, Map<String, Object> params) {
        URIBuilder builder = null;
        try {
            builder = new URIBuilder(url);
            if (params != null && params.size() > 0) {
                for (String key : params.keySet()) {
                    Object obj = params.get(key);
                    if (obj == null) continue;
                    builder.setParameter(key, CommonUtil.parValNoErr(obj, String.class));
                }
            }
            return builder.build();
        }
        catch (URISyntaxException e) {
            throw new ResultInfoException("HTTP_URL_FORMART", "\u8f6c\u6362\u5730\u5740\u51fa\u9519:" + url, e);
        }
    }

    public static void fillHeader(HttpRequestBase request, Map<String, Object> heads) {
        if (heads != null && heads.size() > 0) {
            for (String key : heads.keySet()) {
                request.addHeader(key, heads.get(key) + "");
            }
        }
    }

    public String getGet(String uri, Map<String, Object> heads, Map<String, Object> params) {
        HttpGet request = new HttpGet(HttpClientUtils.builderUrl(uri, params));
        HttpClientUtils.fillHeader((HttpRequestBase)request, heads);
        CloseableHttpResponse response = null;
        try {
            response = this.client.execute((HttpUriRequest)request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            if (response.getStatusLine().getStatusCode() == 200) {
                String string = result;
                return string;
            }
            try {
                result = HttpClientUtils.trim(result, 200);
                ResultInfo<String> res = ResultInfo.fail(result, String.valueOf(response.getStatusLine().getStatusCode()));
                throw new ResultInfoException("HTTP_RESPONSE_ERROR", JSONObject.toJSONString(res));
            }
            catch (IOException e) {
                throw new ResultInfoException("EXCEPTION", "\u7f51\u7edc\u8bf7\u6c42\u5931\u8d25", e);
            }
        }
        finally {
            try {
                response.close();
            }
            catch (Exception e) {}
        }
    }

    public byte[] getGetByte(String uri, Map<String, Object> heads, Map<String, Object> params) {
        HttpGet request = new HttpGet(HttpClientUtils.builderUrl(uri, params));
        HttpClientUtils.fillHeader((HttpRequestBase)request, heads);
        CloseableHttpResponse response = null;
        try {
            response = this.client.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() == 200) {
                byte[] result;
                byte[] byArray = result = EntityUtils.toByteArray((HttpEntity)response.getEntity());
                return byArray;
            }
            try {
                ResultInfo<Object> res = ResultInfo.fail(null, null, String.valueOf(response.getStatusLine().getStatusCode()));
                throw new ResultInfoException("HTTP_RESPONSE_ERROR", JSONObject.toJSONString(res));
            }
            catch (IOException e) {
                throw new ResultInfoException("EXCEPTION", "\u7f51\u7edc\u8bf7\u6c42\u5931\u8d25", e);
            }
        }
        finally {
            try {
                response.close();
            }
            catch (Exception e) {}
        }
    }

    public CloseableHttpResponse getGetResponse(String uri, Map<String, Object> heads, Map<String, Object> params) throws IOException {
        HttpGet request = new HttpGet(HttpClientUtils.builderUrl(uri, params));
        HttpClientUtils.fillHeader((HttpRequestBase)request, heads);
        CloseableHttpResponse response = null;
        response = this.client.execute((HttpUriRequest)request);
        return response;
    }

    private void buildPostBody(HttpPost request, Map<String, Object> params, boolean ifMutipart) {
        if (ifMutipart) {
            MultipartEntityBuilder meBuiler = MultipartEntityBuilder.create();
            meBuiler.setMode(HttpMultipartMode.RFC6532);
            if (params != null && params.size() > 0) {
                for (String key : params.keySet()) {
                    Object obj = params.get(key);
                    if (obj == null) continue;
                    if (obj instanceof File) {
                        FileBody fb = new FileBody((File)obj);
                        meBuiler.addPart(key, (ContentBody)fb);
                        continue;
                    }
                    if (obj instanceof ByteArrayBody) {
                        meBuiler.addPart(key, (ContentBody)((ByteArrayBody)obj));
                        continue;
                    }
                    if (obj instanceof FileBody) {
                        meBuiler.addPart(key, (ContentBody)((FileBody)obj));
                        continue;
                    }
                    if (obj instanceof InputStreamBody) {
                        meBuiler.addPart(key, (ContentBody)((InputStreamBody)obj));
                        continue;
                    }
                    StringBody sb = new StringBody(CommonUtil.parValNoErrDef(obj, String.class, ""), ContentType.create((String)"text/plain", (String)"UTF-8"));
                    meBuiler.addPart(key, (ContentBody)sb);
                }
            }
            HttpEntity httpEntity = meBuiler.build();
            request.setEntity(httpEntity);
        } else {
            ArrayList<BasicNameValuePair> pList = new ArrayList<BasicNameValuePair>();
            if (params != null && params.size() > 0) {
                for (String key : params.keySet()) {
                    Object obj = params.get(key);
                    if (obj == null) continue;
                    pList.add(new BasicNameValuePair(key, obj + ""));
                }
            }
            try {
                request.setEntity((HttpEntity)new UrlEncodedFormEntity(pList, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new ResultInfoException("HTTP_REQ_ENCODE_ERROR", "\u8bf7\u6c42\u53c2\u6570\u683c\u5f0f\u5316\u51fa\u9519", e);
            }
        }
    }

    public String getPost(String uri, Map<String, Object> heads, Map<String, Object> params, boolean ifMutipart) {
        HttpPost request = new HttpPost(uri);
        HttpClientUtils.fillHeader((HttpRequestBase)request, heads);
        this.buildPostBody(request, params, ifMutipart);
        CloseableHttpResponse response = null;
        try {
            response = this.client.execute((HttpUriRequest)request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            if (response.getStatusLine().getStatusCode() == 200) {
                String string = result;
                return string;
            }
            try {
                result = HttpClientUtils.trim(result, 200);
                ResultInfo<String> res = ResultInfo.fail(result, null, String.valueOf(response.getStatusLine().getStatusCode()));
                throw new ResultInfoException("HTTP_RESPONSE_ERROR", JSONObject.toJSONString(res));
            }
            catch (IOException e) {
                throw new ResultInfoException("HTTP_IO_ERROR", "\u7f51\u7edc\u8bf7\u6c42\u5931\u8d25", e);
            }
        }
        finally {
            try {
                response.close();
            }
            catch (Exception e) {}
        }
    }

    public byte[] getPostByte(String uri, Map<String, Object> heads, Map<String, Object> params, boolean ifMutipart) {
        HttpPost request = new HttpPost(uri);
        HttpClientUtils.fillHeader((HttpRequestBase)request, heads);
        this.buildPostBody(request, params, ifMutipart);
        CloseableHttpResponse response = null;
        try {
            response = this.client.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() == 200) {
                byte[] result;
                byte[] byArray = result = EntityUtils.toByteArray((HttpEntity)response.getEntity());
                return byArray;
            }
            try {
                ResultInfo<Object> res = ResultInfo.fail(null, null, String.valueOf(response.getStatusLine().getStatusCode()));
                throw new ResultInfoException("HTTP_RESPONSE_ERROR", JSONObject.toJSONString(res));
            }
            catch (IOException e) {
                throw new ResultInfoException("HTTP_IO_ERROR", "\u7f51\u7edc\u8bf7\u6c42\u5931\u8d25", e);
            }
        }
        finally {
            try {
                response.close();
            }
            catch (Exception e) {}
        }
    }

    public CloseableHttpResponse getPostResponse(String uri, Map<String, Object> heads, Map<String, Object> params, boolean ifMutipart) {
        HttpPost request = new HttpPost(uri);
        HttpClientUtils.fillHeader((HttpRequestBase)request, heads);
        this.buildPostBody(request, params, ifMutipart);
        CloseableHttpResponse response = null;
        try {
            response = this.client.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() == 200) {
                CloseableHttpResponse closeableHttpResponse = response;
                return closeableHttpResponse;
            }
            try {
                String result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                result = HttpClientUtils.trim(result, 200);
                ResultInfo<String> res = ResultInfo.fail(result, null, String.valueOf(response.getStatusLine().getStatusCode()));
                throw new ResultInfoException("HTTP_RESPONSE_ERROR", JSONObject.toJSONString(res));
            }
            catch (IOException e) {
                throw new ResultInfoException("HTTP_IO_ERROR", "\u7f51\u7edc\u8bf7\u6c42\u5931\u8d25", e);
            }
        }
        finally {
            try {
                response.close();
            }
            catch (Exception e) {}
        }
    }

    private static String trim(String str, int maxLen) {
        if (str != null) {
            if (str.length() > 200) {
                str = str.substring(0, 200);
            }
            return str.trim();
        }
        return "";
    }

    static {
        objTg = new Object();
        DEFAULT_CONN_TIMEOUT = 20000;
        try {
            String envtimeOut = System.getProperty("jzq.http.timeout");
            if (envtimeOut != null) {
                try {
                    Integer timeout;
                    DEFAULT_CONN_TIMEOUT = timeout = Integer.valueOf(envtimeOut);
                    System.out.println("\u541b\u5b50\u7b7ehttp\u5de5\u5177\u8d85\u65f6\u65f6\u95f4 \u4f7f\u7528-Djzq.http.timeout\u914d\u7f6e\u65f6\u95f4" + DEFAULT_CONN_TIMEOUT + "ms");
                }
                catch (Exception exception) {}
            } else {
                System.out.println("\u541b\u5b50\u7b7ehttp\u5de5\u5177\u8d85\u65f6\u65f6\u95f4-Djzq.http.timeout\u672a\u914d\u7f6e\uff0c\u4f7f\u7528\u9ed8\u8ba4\u8d85\u65f6\u65f6\u95f4" + DEFAULT_CONN_TIMEOUT + "ms");
            }
            System.out.println("\u5f53\u524d\u541b\u5b50\u7b7ehttp\u5de5\u5177\u8d85\u65f6\u65f6\u95f4\uff0c" + DEFAULT_CONN_TIMEOUT + "ms");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DEFAULT_RETRY_TIMES = 3;
    }

    private static class SSLTrustAllManager
    implements X509TrustManager {
        private SSLTrustAllManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

