/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kong.unirest.Config;
import kong.unirest.HttpResponseSummary;
import kong.unirest.RawResponse;
import kong.unirest.ResponseSummary;

public abstract class RawResponseBase
implements RawResponse {
    private static final Pattern CHARSET_PATTERN = Pattern.compile("(?i)\\bcharset=\\s*\"?([^\\s;\"]*)");
    protected Config config;

    protected RawResponseBase(Config config) {
        this.config = config;
    }

    protected String getCharSet() {
        String contentType = this.getContentType();
        String responseCharset = this.getCharsetFromContentType(contentType);
        if (responseCharset != null && !responseCharset.trim().equals("")) {
            return responseCharset;
        }
        return this.config.getDefaultResponseEncoding();
    }

    private String getCharsetFromContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        Matcher m = CHARSET_PATTERN.matcher(contentType);
        if (m.find()) {
            return m.group(1).trim().toUpperCase();
        }
        return null;
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public HttpResponseSummary toSummary() {
        return new ResponseSummary(this);
    }
}

