/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.algorithm;

import com.mayabot.nlp.common.Pair;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;

public class TopMaxK<T> {
    private final Class<T> clazz;
    private int k = 10;
    private float[] heap;
    private T[] idIndex;
    int size = 0;

    public TopMaxK(int k, Class<T> clazz) {
        this.k = k;
        this.heap = new float[k];
        this.clazz = clazz;
        this.idIndex = (Object[])Array.newInstance(clazz, k);
    }

    public void push(T id, float score) {
        if (this.size < this.k) {
            this.heap[this.size] = score;
            this.idIndex[this.size] = id;
            ++this.size;
            if (this.size == this.k) {
                this.buildMinHeap();
            }
        } else if (score > this.heap[0]) {
            this.heap[0] = score;
            this.idIndex[0] = id;
            this.mintopify(0);
        }
    }

    public ArrayList<Pair<T, Float>> result() {
        int top = Math.min(this.k, this.size);
        ArrayList<Pair<T, Float>> list = new ArrayList<Pair<T, Float>>(top);
        for (int i = 0; i < top; ++i) {
            list.add(new Pair<T, Float>(this.idIndex[i], Float.valueOf(this.heap[i])));
        }
        Collections.sort(list, (a, b) -> -1 * Float.compare(((Float)a.second).floatValue(), ((Float)b.second).floatValue()));
        return list;
    }

    private void buildMinHeap() {
        for (int i = this.k / 2 - 1; i >= 0; --i) {
            this.mintopify(i);
        }
    }

    private void mintopify(int i) {
        int l = 2 * i + 1;
        int r = 2 * i + 2;
        int min = 0;
        min = l < this.k && this.heap[l] < this.heap[i] ? l : i;
        if (r < this.k && this.heap[r] < this.heap[min]) {
            min = r;
        }
        if (min == i || min >= this.k) {
            return;
        }
        this.swap(i, min);
        this.mintopify(min);
    }

    private void swap(int i, int j) {
        float tmp = this.heap[i];
        this.heap[i] = this.heap[j];
        this.heap[j] = tmp;
        T tmp2 = this.idIndex[i];
        this.idIndex[i] = this.idIndex[j];
        this.idIndex[j] = tmp2;
    }
}

