/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.collection.bintrie;

import com.mayabot.nlp.collection.bintrie.AbstractTrieNode;
import com.mayabot.nlp.collection.bintrie.BinTrieNode;
import java.util.ArrayList;
import java.util.List;

public class ArrayTrieNode<T>
extends AbstractTrieNode<T> {
    private ArrayTrieNode<T>[] children = null;

    ArrayTrieNode(char _char, byte status, T value) {
        super(_char);
        this.status = status;
        this.value = value;
    }

    @Override
    public List<AbstractTrieNode<T>> getChildren() {
        if (this.children == null) {
            return null;
        }
        ArrayList<AbstractTrieNode<T>> list = new ArrayList<AbstractTrieNode<T>>();
        for (ArrayTrieNode<T> e : this.children) {
            if (e == null) continue;
            list.add(e);
        }
        return list;
    }

    @Override
    public BinTrieNode<T> addChildNode(BinTrieNode<T> c) {
        int bs;
        AbstractTrieNode child = (AbstractTrieNode)c;
        if (this.children == null) {
            this.children = new ArrayTrieNode[0];
        }
        if ((bs = ArrayTrieNode.binarySearch(this.children, child._char)) >= 0) {
            ArrayTrieNode<T> branch = this.children[bs];
            switch (child.status) {
                case -1: {
                    branch.status = 1;
                    break;
                }
                case 1: {
                    if (branch.status != 3) break;
                    branch.status = (byte)2;
                    break;
                }
                case 3: {
                    if (branch.status != 3) {
                        branch.status = (byte)2;
                    }
                    branch.value = child.value;
                }
            }
            return branch;
        }
        ArrayTrieNode[] newBranches = new ArrayTrieNode[this.children.length + 1];
        int insert = -(bs + 1);
        System.arraycopy(this.children, 0, newBranches, 0, insert);
        System.arraycopy(this.children, insert, newBranches, insert + 1, this.children.length - insert);
        newBranches[insert] = (ArrayTrieNode)child;
        this.children = newBranches;
        return child;
    }

    @Override
    public ArrayTrieNode<T> findChild(char c) {
        if (this.children == null) {
            return null;
        }
        int i = ArrayTrieNode.binarySearch(this.children, c);
        if (i < 0) {
            return null;
        }
        return this.children[i];
    }

    @Override
    public boolean contains(char c) {
        if (this.children == null) {
            return false;
        }
        return ArrayTrieNode.binarySearch(this.children, c) > -1;
    }
}

