/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.collection.bintrie;

import com.mayabot.nlp.collection.bintrie.BinTrieNode;
import com.mayabot.nlp.collection.bintrie.BinTrieTree;
import com.mayabot.nlp.collection.bintrie.TrieTreeMatcher;
import java.util.List;

public class TrieTreeAllMatcher<T>
implements TrieTreeMatcher<T> {
    private static final String EMPTY_STRING = "";
    private final BinTrieTree<T> tree;
    private int offset;
    private int root;
    private int i;
    private boolean isBack;
    private BinTrieNode<T> branch;
    private String text;
    private String str;
    private int tempOffset;
    private T param;
    private final int len;

    TrieTreeAllMatcher(BinTrieTree<T> tree, String content) {
        this.i = this.root = 0;
        this.isBack = false;
        this.text = content;
        this.tree = tree;
        this.branch = tree;
        this.len = content.length();
    }

    @Override
    public String next() {
        String temp = this.allWordNext();
        while (EMPTY_STRING.equals(temp)) {
            temp = this.allWordNext();
        }
        return temp;
    }

    private String allWordNext() {
        if (!this.isBack || this.i == this.len - 1) {
            this.i = this.root - 1;
        }
        ++this.i;
        while (this.i < this.len) {
            this.branch = this.branch.findChild(this.text.charAt(this.i));
            if (this.branch == null) {
                ++this.root;
                this.branch = this.tree;
                this.i = this.root - 1;
                this.isBack = false;
            } else {
                switch (this.branch.getStatus()) {
                    case 2: {
                        this.isBack = true;
                        this.offset = this.tempOffset + this.root;
                        this.param = this.branch.getValue();
                        return this.text.substring(this.root, this.i + 1);
                    }
                    case 3: {
                        this.offset = this.tempOffset + this.root;
                        this.str = this.text.substring(this.root, this.i + 1);
                        this.param = this.branch.getValue();
                        this.branch = this.tree;
                        this.isBack = false;
                        ++this.root;
                        return this.str;
                    }
                }
            }
            ++this.i;
        }
        this.tempOffset += this.text.length();
        return null;
    }

    private boolean isE(char c) {
        return c == '.' || c >= 'a' && c <= 'z';
    }

    @Override
    public String getParam(int i) {
        if (this.param != null) {
            if (this.param instanceof String[]) {
                String[] _p = (String[])this.param;
                if (_p.length > i) {
                    return _p[i];
                }
            } else if (this.param instanceof List) {
                List list = (List)this.param;
                return (String)list.get(i);
            }
        }
        return null;
    }

    @Override
    public T getParams() {
        return this.param;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }
}

