/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import com.mayabot.nlp.common.QuickStringDoubleTable;
import java.util.ArrayList;

public class QuickStringIntTable {
    private int[] labelBase;
    private int labelSize;
    int[] data;

    public QuickStringIntTable(Table<String, String, Integer> table) {
        ArrayList labelList = Lists.newArrayList((Iterable)table.rowKeySet());
        this.labelBase = QuickStringDoubleTable.findABase(labelList);
        this.labelSize = this.labelBase.length;
        this.data = new int[this.labelSize * this.labelSize];
        for (String rowKey : table.rowKeySet()) {
            for (String colKey : table.columnKeySet()) {
                int rowid = this.labelBase[rowKey.hashCode() % this.labelSize];
                int colid = this.labelBase[colKey.hashCode() % this.labelSize];
                this.data[rowid * this.labelSize + colid] = (Integer)table.get((Object)rowKey, (Object)colKey);
            }
        }
    }

    public int get(String row, String col) {
        int rowid = this.labelBase[row.hashCode() % this.labelSize];
        int colid = this.labelBase[col.hashCode() % this.labelSize];
        if (rowid == -1 || colid == -1) {
            return Integer.MIN_VALUE;
        }
        return this.data[rowid * this.labelSize + colid];
    }
}

