/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.utils;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Resources;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class CharNormUtils {
    private static char[] table = new char[65535];

    public static char convert(char input) {
        char c = table[input];
        if (c != '\u0000') {
            return c;
        }
        return input;
    }

    public static void convert(char[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            char to = table[c];
            if (to == '\u0000') continue;
            chars[i] = to;
        }
    }

    public static String convert(String input) {
        char[] chars = input.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            char to = table[c];
            if (to == '\u0000') continue;
            chars[i] = to;
        }
        return new String(chars);
    }

    static {
        AccessController.doPrivileged(() -> {
            try {
                List lines = Resources.readLines((URL)Resources.getResource(CharNormUtils.class, (String)"char_norm"), (Charset)Charsets.UTF_8);
                HashSet left = Sets.newHashSet();
                ArrayList right = Lists.newArrayList();
                for (int i = 0; i < lines.size(); ++i) {
                    String line = (String)lines.get(i);
                    if (line.isEmpty() || !line.contains("=")) continue;
                    int x = line.indexOf("=");
                    if (x != 1 && line.length() != 3) {
                        System.err.println("Error " + line);
                        continue;
                    }
                    String first = line.substring(0, 1);
                    String second = line.substring(2, 3);
                    left.add(first);
                    right.add(second);
                    if (first.length() != 1 || second.length() != 1) continue;
                    CharNormUtils.table[first.charAt((int)0)] = second.charAt(0);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        });
    }
}

