/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.perceptron;

import com.mayabot.nlp.MynlpEnv;
import com.mayabot.nlp.Mynlps;
import com.mayabot.nlp.perceptron.FeatureSet;
import com.mayabot.nlp.perceptron.Perceptron;
import com.mayabot.nlp.perceptron.PerceptronFormat;
import com.mayabot.nlp.perceptron.PerceptronModel;
import com.mayabot.nlp.resources.NlpResource;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\bH\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u0016\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\b\u00a8\u0006\u0016"}, d2={"Lcom/mayabot/nlp/perceptron/PerceptronFormat;", "", "()V", "load", "Lcom/mayabot/nlp/perceptron/Perceptron;", "dir", "Ljava/io/File;", "parameterBin", "Ljava/io/InputStream;", "featureBin", "featureText", "loadFromClasspath", "prefix", "", "loader", "Ljava/lang/ClassLoader;", "loadFromNlpResource", "nlpEnv", "Lcom/mayabot/nlp/MynlpEnv;", "loadWithFeatureBin", "loadWithFeatureTxt", "featureTxt", "mynlp-perceptron"})
public final class PerceptronFormat {
    public static final PerceptronFormat INSTANCE;

    @NotNull
    public final Perceptron loadFromClasspath(@NotNull String prefix, @NotNull ClassLoader loader) {
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        Intrinsics.checkParameterIsNotNull((Object)loader, (String)"loader");
        InputStream parameter = loader.getResourceAsStream(prefix + "/parameter.bin");
        InputStream inputStream = loader.getResourceAsStream(prefix + "/feature.dat");
        if (inputStream == null) {
            inputStream = loader.getResourceAsStream(prefix + "/feature.txt");
        }
        InputStream feature = inputStream;
        boolean bl = parameter != null && feature != null;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        boolean isDat = loader.getResource(prefix + "/feature.dat") != null;
        return isDat ? this.loadWithFeatureBin(parameter, feature) : this.loadWithFeatureTxt(parameter, feature);
    }

    public static /* synthetic */ Perceptron loadFromClasspath$default(PerceptronFormat perceptronFormat, String string, ClassLoader classLoader, int n, Object object) {
        if ((n & 2) != 0) {
            Thread thread = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
            ClassLoader classLoader2 = thread.getContextClassLoader();
            Intrinsics.checkExpressionValueIsNotNull((Object)classLoader2, (String)"Thread.currentThread().contextClassLoader");
            classLoader = classLoader2;
        }
        return perceptronFormat.loadFromClasspath(string, classLoader);
    }

    @NotNull
    public final Perceptron loadFromNlpResource(@NotNull String prefix, @NotNull MynlpEnv nlpEnv) {
        Perceptron perceptron;
        boolean isDat;
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        Intrinsics.checkParameterIsNotNull((Object)nlpEnv, (String)"nlpEnv");
        NlpResource parameter = nlpEnv.loadResource(prefix + "/parameter.bin");
        NlpResource fd = nlpEnv.tryLoadResource(prefix + "/feature.dat");
        NlpResource nlpResource = fd;
        if (nlpResource == null) {
            nlpResource = nlpEnv.loadResource(prefix + "/feature.txt");
        }
        NlpResource feature = nlpResource;
        boolean bl = parameter != null && feature != null;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        boolean bl6 = isDat = fd != null;
        if (isDat) {
            InputStream inputStream = parameter.inputStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"parameter.inputStream()");
            InputStream inputStream2 = feature.inputStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream2, (String)"feature.inputStream()");
            perceptron = this.loadWithFeatureBin(inputStream, inputStream2);
        } else {
            InputStream inputStream = parameter.inputStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"parameter.inputStream()");
            InputStream inputStream3 = feature.inputStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream3, (String)"feature.inputStream()");
            perceptron = this.loadWithFeatureTxt(inputStream, inputStream3);
        }
        return perceptron;
    }

    public static /* synthetic */ Perceptron loadFromNlpResource$default(PerceptronFormat perceptronFormat, String string, MynlpEnv mynlpEnv, int n, Object object) {
        if ((n & 2) != 0) {
            MynlpEnv mynlpEnv2 = Mynlps.get().getEnv();
            Intrinsics.checkExpressionValueIsNotNull((Object)mynlpEnv2, (String)"Mynlps.get().env");
            mynlpEnv = mynlpEnv2;
        }
        return perceptronFormat.loadFromNlpResource(string, mynlpEnv);
    }

    @NotNull
    public final Perceptron loadWithFeatureBin(@NotNull InputStream parameterBin, @NotNull InputStream featureBin) {
        Intrinsics.checkParameterIsNotNull((Object)parameterBin, (String)"parameterBin");
        Intrinsics.checkParameterIsNotNull((Object)featureBin, (String)"featureBin");
        return this.load(parameterBin, featureBin, null);
    }

    @NotNull
    public final Perceptron loadWithFeatureTxt(@NotNull InputStream parameterBin, @NotNull InputStream featureTxt) {
        Intrinsics.checkParameterIsNotNull((Object)parameterBin, (String)"parameterBin");
        Intrinsics.checkParameterIsNotNull((Object)featureTxt, (String)"featureTxt");
        return this.load(parameterBin, null, featureTxt);
    }

    @NotNull
    public final Perceptron load(@NotNull File dir) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        Function1<String, File> $fun$loadIfExit$1 = new Function1<String, File>(dir){
            final /* synthetic */ File $dir;

            @Nullable
            public final File invoke(@NotNull String name) {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                File f = new File(this.$dir, name);
                return f.exists() ? f : null;
            }
            {
                this.$dir = file;
                super(1);
            }
        };
        load.2 $fun$load$2 = load.2.INSTANCE;
        return $fun$load$2.invoke(new File(dir, "parameter.bin"), $fun$loadIfExit$1.invoke("feature.dat"), $fun$loadIfExit$1.invoke("feature.txt"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Perceptron load(InputStream parameterBin, InputStream featureBin, InputStream featureText) {
        FeatureSet featureSet2;
        boolean bl = featureBin != null || featureText != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "featureBin\u4e0d\u53ef\u4ee5\u540c\u65f6\u4e3a\u7a7a";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        int labelCount = 0;
        float[] parameter = new float[]{};
        Closeable closeable = parameterBin;
        boolean bl5 = false;
        Throwable throwable = null;
        try {
            int n;
            InputStream x = (InputStream)closeable;
            boolean bl6 = false;
            DataInputStream input = new DataInputStream(x);
            labelCount = input.readInt();
            int pSize = input.readInt();
            parameter = new float[pSize];
            byte[] buffer = new byte[16384];
            ByteBuffer wrap = ByteBuffer.wrap(buffer);
            int point = 0;
            while ((n = input.read(buffer)) != -1) {
                if (n % 4 != 0) {
                    throw (Throwable)new RuntimeException("Error Size " + n);
                }
                wrap.flip();
                wrap.limit(n);
                int n2 = 0;
                int n3 = n / 4;
                while (n2 < n3) {
                    void i;
                    int n4 = point++;
                    ByteBuffer byteBuffer = wrap;
                    Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"wrap");
                    parameter[n4] = byteBuffer.getFloat();
                    ++i;
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        if (featureBin != null) {
            featureSet2 = featureText != null ? FeatureSet.Companion.read(featureBin, featureText) : FeatureSet.Companion.read(featureBin);
        } else if (featureText != null) {
            featureSet2 = FeatureSet.Companion.readFromTextButNotSave(featureText);
        } else {
            throw (Throwable)new RuntimeException("featureText featureBin \u4e0d\u53ef\u4ee5\u540c\u65f6\u4e3a\u7a7a");
        }
        FeatureSet fs = featureSet2;
        return new PerceptronModel(fs, labelCount, parameter);
    }

    private PerceptronFormat() {
    }

    static {
        PerceptronFormat perceptronFormat;
        INSTANCE = perceptronFormat = new PerceptronFormat();
    }

    public static final /* synthetic */ Perceptron access$load(PerceptronFormat $this, InputStream parameterBin, InputStream featureBin, InputStream featureText) {
        return $this.load(parameterBin, featureBin, featureText);
    }
}

