/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.SubResource;
import com.microsoft.azure.management.compute.DiskEncryptionSettings;
import com.microsoft.azure.management.compute.DiskVolumeEncryptionMonitor;
import com.microsoft.azure.management.compute.DiskVolumeType;
import com.microsoft.azure.management.compute.EncryptionStatus;
import com.microsoft.azure.management.compute.KeyVaultKeyReference;
import com.microsoft.azure.management.compute.KeyVaultSecretReference;
import com.microsoft.azure.management.compute.OperatingSystemTypes;
import com.microsoft.azure.management.compute.VirtualMachine;
import com.microsoft.azure.management.compute.VirtualMachineEncryptionConfiguration;
import com.microsoft.azure.management.compute.VirtualMachineExtension;
import com.microsoft.azure.management.compute.VirtualMachineExtensionInstanceView;
import com.microsoft.azure.management.compute.implementation.ComputeManager;
import com.microsoft.azure.management.compute.implementation.LinuxDiskVolumeEncryptionMonitorImpl;
import com.microsoft.azure.management.compute.implementation.WindowsVolumeEncryptionMonitorImpl;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.UUID;
import rx.Observable;
import rx.functions.Func0;
import rx.functions.Func1;

class VirtualMachineEncryptionHelper {
    private final String encryptionExtensionPublisher = "Microsoft.Azure.Security";
    private final OperatingSystemTypes osType;
    private final VirtualMachine virtualMachine;
    private static final String ERROR_ENCRYPTION_EXTENSION_NOT_FOUND = "Expected encryption extension not found in the VM";
    private static final String ERROR_NON_SUCCESS_PROVISIONING_STATE = "Extension needed for disk encryption was not provisioned correctly, found ProvisioningState as '%s'";
    private static final String ERROR_EXPECTED_KEY_VAULT_URL_NOT_FOUND = "Could not found URL pointing to the secret for disk encryption";
    private static final String ERROR_EXPECTED_ENCRYPTION_EXTENSION_STATUS_NOT_FOUND = "Encryption extension with successful status not found in the VM";
    private static final String ERROR_ENCRYPTION_EXTENSION_STATUS_IS_EMPTY = "Encryption extension status is empty";
    private static final String ERROR_ON_LINUX_DECRYPTING_NON_DATA_DISK_IS_NOT_SUPPORTED = "Only data disk is supported to disable encryption on Linux VM";
    private static final String ERROR_ON_LINUX_DATA_DISK_DECRYPT_NOT_ALLOWED_IF_OS_DISK_IS_ENCRYPTED = "On Linux VM disabling data disk encryption is allowed only if OS disk is not encrypted";

    VirtualMachineEncryptionHelper(VirtualMachine virtualMachine) {
        this.virtualMachine = virtualMachine;
        this.osType = this.virtualMachine.osType();
    }

    <T extends VirtualMachineEncryptionConfiguration<T>> Observable<DiskVolumeEncryptionMonitor> enableEncryptionAsync(VirtualMachineEncryptionConfiguration<T> encryptionSettings) {
        final EnableEncryptConfig<T> encryptConfig = new EnableEncryptConfig<T>(encryptionSettings);
        return this.updateEncryptionExtensionAsync(encryptConfig).switchIfEmpty(this.installEncryptionExtensionAsync(encryptConfig)).flatMap((Func1)new Func1<VirtualMachine, Observable<String>>(){

            public Observable<String> call(VirtualMachine virtualMachine) {
                return VirtualMachineEncryptionHelper.this.retrieveEncryptionExtensionStatusStringAsync(VirtualMachineEncryptionHelper.ERROR_EXPECTED_KEY_VAULT_URL_NOT_FOUND);
            }
        }).flatMap((Func1)new Func1<String, Observable<VirtualMachine>>(){

            public Observable<VirtualMachine> call(String keyVaultSecretUrl) {
                return VirtualMachineEncryptionHelper.this.updateVMStorageProfileAsync(encryptConfig, keyVaultSecretUrl);
            }
        }).flatMap((Func1)new Func1<VirtualMachine, Observable<DiskVolumeEncryptionMonitor>>(){

            public Observable<DiskVolumeEncryptionMonitor> call(VirtualMachine virtualMachine) {
                return VirtualMachineEncryptionHelper.this.getDiskVolumeEncryptDecryptStatusAsync(virtualMachine);
            }
        });
    }

    Observable<DiskVolumeEncryptionMonitor> disableEncryptionAsync(DiskVolumeType volumeType) {
        final DisableEncryptConfig encryptConfig = new DisableEncryptConfig(volumeType);
        return this.validateBeforeDecryptAsync(volumeType).flatMap((Func1)new Func1<Boolean, Observable<VirtualMachine>>(){

            public Observable<VirtualMachine> call(Boolean aBoolean) {
                return VirtualMachineEncryptionHelper.this.updateEncryptionExtensionAsync(encryptConfig);
            }
        }).switchIfEmpty(this.installEncryptionExtensionAsync(encryptConfig)).flatMap((Func1)new Func1<VirtualMachine, Observable<String>>(){

            public Observable<String> call(VirtualMachine virtualMachine) {
                return VirtualMachineEncryptionHelper.this.retrieveEncryptionExtensionStatusStringAsync(VirtualMachineEncryptionHelper.ERROR_ENCRYPTION_EXTENSION_STATUS_IS_EMPTY);
            }
        }).flatMap((Func1)new Func1<String, Observable<VirtualMachine>>(){

            public Observable<VirtualMachine> call(String status) {
                return VirtualMachineEncryptionHelper.this.updateVMStorageProfileAsync(encryptConfig);
            }
        }).flatMap((Func1)new Func1<VirtualMachine, Observable<DiskVolumeEncryptionMonitor>>(){

            public Observable<DiskVolumeEncryptionMonitor> call(VirtualMachine virtualMachine) {
                return VirtualMachineEncryptionHelper.this.getDiskVolumeEncryptDecryptStatusAsync(virtualMachine);
            }
        });
    }

    private String encryptionExtensionType() {
        if (this.osType == OperatingSystemTypes.LINUX) {
            return "AzureDiskEncryptionForLinux";
        }
        return "AzureDiskEncryption";
    }

    private String encryptionExtensionVersion() {
        if (this.osType == OperatingSystemTypes.LINUX) {
            return "0.1";
        }
        return "1.1";
    }

    private Observable<Boolean> validateBeforeDecryptAsync(DiskVolumeType volumeType) {
        if (this.osType == OperatingSystemTypes.LINUX) {
            if (volumeType != DiskVolumeType.DATA) {
                return this.toErrorObservable(ERROR_ON_LINUX_DECRYPTING_NON_DATA_DISK_IS_NOT_SUPPORTED);
            }
            return this.getDiskVolumeEncryptDecryptStatusAsync(this.virtualMachine).flatMap((Func1)new Func1<DiskVolumeEncryptionMonitor, Observable<Boolean>>(){

                public Observable<Boolean> call(DiskVolumeEncryptionMonitor status) {
                    if (status.osDiskStatus().equals((Object)EncryptionStatus.ENCRYPTED)) {
                        return VirtualMachineEncryptionHelper.this.toErrorObservable(VirtualMachineEncryptionHelper.ERROR_ON_LINUX_DATA_DISK_DECRYPT_NOT_ALLOWED_IF_OS_DISK_IS_ENCRYPTED);
                    }
                    return Observable.just((Object)true);
                }
            });
        }
        return Observable.just((Object)true);
    }

    private Observable<VirtualMachineExtension> getEncryptionExtensionInstalledInVMAsync() {
        return this.virtualMachine.listExtensionsAsync().firstOrDefault(null, (Func1)new Func1<VirtualMachineExtension, Boolean>(){

            public Boolean call(VirtualMachineExtension extension) {
                return extension.publisherName().equalsIgnoreCase("Microsoft.Azure.Security") && extension.typeName().equalsIgnoreCase(VirtualMachineEncryptionHelper.this.encryptionExtensionType());
            }
        }).flatMap((Func1)new Func1<VirtualMachineExtension, Observable<VirtualMachineExtension>>(){

            public Observable<VirtualMachineExtension> call(VirtualMachineExtension extension) {
                if (extension == null) {
                    return Observable.empty();
                }
                return Observable.just((Object)extension);
            }
        });
    }

    private Observable<VirtualMachine> updateEncryptionExtensionAsync(final EnableDisableEncryptConfig encryptConfig) {
        return this.getEncryptionExtensionInstalledInVMAsync().flatMap((Func1)new Func1<VirtualMachineExtension, Observable<VirtualMachine>>(){

            public Observable<VirtualMachine> call(VirtualMachineExtension encryptionExtension) {
                HashMap<String, Object> publicSettings = encryptConfig.extensionPublicSettings();
                return ((VirtualMachine.Update)((VirtualMachine.Update)VirtualMachineEncryptionHelper.this.virtualMachine.update()).updateExtension(encryptionExtension.name()).withPublicSettings(publicSettings).withProtectedSettings(encryptConfig.extensionProtectedSettings()).parent()).applyAsync();
            }
        });
    }

    private Observable<VirtualMachine> installEncryptionExtensionAsync(final EnableDisableEncryptConfig encryptConfig) {
        return Observable.defer((Func0)new Func0<Observable<VirtualMachine>>(){

            public Observable<VirtualMachine> call() {
                String extensionName = VirtualMachineEncryptionHelper.this.encryptionExtensionType();
                return ((VirtualMachine.Update)((VirtualMachine.Update)VirtualMachineEncryptionHelper.this.virtualMachine.update()).defineNewExtension(extensionName).withPublisher("Microsoft.Azure.Security").withType(VirtualMachineEncryptionHelper.this.encryptionExtensionType()).withVersion(VirtualMachineEncryptionHelper.this.encryptionExtensionVersion()).withPublicSettings(encryptConfig.extensionPublicSettings()).withProtectedSettings(encryptConfig.extensionProtectedSettings()).withMinorVersionAutoUpgrade().attach()).applyAsync();
            }
        });
    }

    private Observable<String> retrieveEncryptionExtensionStatusStringAsync(final String statusEmptyErrorMessage) {
        final VirtualMachineEncryptionHelper self = this;
        return this.getEncryptionExtensionInstalledInVMAsync().switchIfEmpty(self.toErrorObservable(ERROR_ENCRYPTION_EXTENSION_NOT_FOUND)).flatMap((Func1)new Func1<VirtualMachineExtension, Observable<VirtualMachineExtensionInstanceView>>(){

            public Observable<VirtualMachineExtensionInstanceView> call(VirtualMachineExtension extension) {
                if (!extension.provisioningState().equalsIgnoreCase("Succeeded")) {
                    return self.toErrorObservable(String.format(VirtualMachineEncryptionHelper.ERROR_NON_SUCCESS_PROVISIONING_STATE, extension.provisioningState()));
                }
                return extension.getInstanceViewAsync();
            }
        }).flatMap((Func1)new Func1<VirtualMachineExtensionInstanceView, Observable<String>>(){

            public Observable<String> call(VirtualMachineExtensionInstanceView instanceView) {
                if (instanceView == null || instanceView.statuses() == null || instanceView.statuses().size() == 0) {
                    return self.toErrorObservable(VirtualMachineEncryptionHelper.ERROR_EXPECTED_ENCRYPTION_EXTENSION_STATUS_NOT_FOUND);
                }
                String extensionStatus = instanceView.statuses().get(0).message();
                if (extensionStatus == null) {
                    return self.toErrorObservable(statusEmptyErrorMessage);
                }
                return Observable.just((Object)extensionStatus);
            }
        });
    }

    private Observable<VirtualMachine> updateVMStorageProfileAsync(EnableDisableEncryptConfig encryptConfig, String encryptionSecretKeyVaultUrl) {
        DiskEncryptionSettings diskEncryptionSettings = encryptConfig.storageProfileEncryptionSettings();
        diskEncryptionSettings.diskEncryptionKey().withSecretUrl(encryptionSecretKeyVaultUrl);
        return ((VirtualMachine.Update)this.virtualMachine.update()).withOSDiskEncryptionSettings(diskEncryptionSettings).applyAsync();
    }

    private Observable<VirtualMachine> updateVMStorageProfileAsync(EnableDisableEncryptConfig encryptConfig) {
        DiskEncryptionSettings diskEncryptionSettings = encryptConfig.storageProfileEncryptionSettings();
        return ((VirtualMachine.Update)this.virtualMachine.update()).withOSDiskEncryptionSettings(diskEncryptionSettings).applyAsync();
    }

    private Observable<DiskVolumeEncryptionMonitor> getDiskVolumeEncryptDecryptStatusAsync(VirtualMachine virtualMachine) {
        if (this.osType == OperatingSystemTypes.LINUX) {
            return new LinuxDiskVolumeEncryptionMonitorImpl(virtualMachine.id(), (ComputeManager)((Object)virtualMachine.manager())).refreshAsync();
        }
        return new WindowsVolumeEncryptionMonitorImpl(virtualMachine.id(), (ComputeManager)((Object)virtualMachine.manager())).refreshAsync();
    }

    private <ResultT> Observable<ResultT> toErrorObservable(String message) {
        return Observable.error((Throwable)new Exception(message));
    }

    private class DisableEncryptConfig
    extends EnableDisableEncryptConfig {
        private final DiskVolumeType volumeType;

        DisableEncryptConfig(DiskVolumeType volumeType) {
            this.volumeType = volumeType;
        }

        @Override
        public DiskEncryptionSettings storageProfileEncryptionSettings() {
            DiskEncryptionSettings diskEncryptionSettings = new DiskEncryptionSettings();
            diskEncryptionSettings.withEnabled(false);
            return diskEncryptionSettings;
        }

        @Override
        public HashMap<String, Object> extensionPublicSettings() {
            LinkedHashMap<String, Object> publicSettings = new LinkedHashMap<String, Object>();
            publicSettings.put("EncryptionOperation", "DisableEncryption");
            publicSettings.put("SequenceVersion", UUID.randomUUID());
            publicSettings.put("VolumeType", (Object)this.volumeType);
            return publicSettings;
        }

        @Override
        public HashMap<String, Object> extensionProtectedSettings() {
            return new LinkedHashMap<String, Object>();
        }
    }

    private class EnableEncryptConfig<T extends VirtualMachineEncryptionConfiguration<T>>
    extends EnableDisableEncryptConfig {
        private final VirtualMachineEncryptionConfiguration<T> settings;

        EnableEncryptConfig(VirtualMachineEncryptionConfiguration<T> settings) {
            this.settings = settings;
        }

        @Override
        public DiskEncryptionSettings storageProfileEncryptionSettings() {
            KeyVaultKeyReference keyEncryptionKey = null;
            if (this.settings.keyEncryptionKeyURL() != null) {
                keyEncryptionKey = new KeyVaultKeyReference();
                keyEncryptionKey.withKeyUrl(this.settings.keyEncryptionKeyURL());
                if (this.settings.keyEncryptionKeyVaultId() != null) {
                    keyEncryptionKey.withSourceVault(new SubResource().withId(this.settings.keyEncryptionKeyVaultId()));
                }
            }
            DiskEncryptionSettings diskEncryptionSettings = new DiskEncryptionSettings();
            diskEncryptionSettings.withEnabled(true).withKeyEncryptionKey(keyEncryptionKey).withDiskEncryptionKey(new KeyVaultSecretReference()).diskEncryptionKey().withSourceVault(new SubResource().withId(this.settings.keyVaultId()));
            return diskEncryptionSettings;
        }

        @Override
        public HashMap<String, Object> extensionPublicSettings() {
            LinkedHashMap<String, Object> publicSettings = new LinkedHashMap<String, Object>();
            publicSettings.put("EncryptionOperation", "EnableEncryption");
            publicSettings.put("AADClientID", this.settings.aadClientId());
            publicSettings.put("KeyEncryptionAlgorithm", this.settings.volumeEncryptionKeyEncryptAlgorithm());
            publicSettings.put("KeyVaultURL", this.settings.keyVaultUrl());
            publicSettings.put("VolumeType", this.settings.volumeType().toString());
            publicSettings.put("SequenceVersion", UUID.randomUUID());
            if (this.settings.keyEncryptionKeyURL() != null) {
                publicSettings.put("KeyEncryptionKeyURL", this.settings.keyEncryptionKeyURL());
            }
            return publicSettings;
        }

        @Override
        public HashMap<String, Object> extensionProtectedSettings() {
            LinkedHashMap<String, Object> protectedSettings = new LinkedHashMap<String, Object>();
            protectedSettings.put("AADClientSecret", this.settings.aadSecret());
            if (this.settings.osType() == OperatingSystemTypes.LINUX && this.settings.linuxPassPhrase() != null) {
                protectedSettings.put("Passphrase", this.settings.linuxPassPhrase());
            }
            return protectedSettings;
        }
    }

    private abstract class EnableDisableEncryptConfig {
        private EnableDisableEncryptConfig() {
        }

        public abstract DiskEncryptionSettings storageProfileEncryptionSettings();

        public abstract HashMap<String, Object> extensionPublicSettings();

        public abstract HashMap<String, Object> extensionProtectedSettings();
    }
}

