/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.storage.implementation;

import com.microsoft.azure.management.storage.Encryption;
import com.microsoft.azure.management.storage.EncryptionService;
import com.microsoft.azure.management.storage.EncryptionServices;
import com.microsoft.azure.management.storage.KeySource;
import com.microsoft.azure.management.storage.KeyVaultProperties;
import com.microsoft.azure.management.storage.StorageAccountEncryptionKeySource;
import com.microsoft.azure.management.storage.StorageAccountEncryptionStatus;
import com.microsoft.azure.management.storage.StorageService;
import com.microsoft.azure.management.storage.implementation.BlobServiceEncryptionStatusImpl;
import com.microsoft.azure.management.storage.implementation.FileServiceEncryptionStatusImpl;
import com.microsoft.azure.management.storage.implementation.QueueServiceEncryptionStatusImpl;
import com.microsoft.azure.management.storage.implementation.StorageAccountCreateParametersInner;
import com.microsoft.azure.management.storage.implementation.StorageAccountInner;
import com.microsoft.azure.management.storage.implementation.StorageAccountUpdateParametersInner;
import com.microsoft.azure.management.storage.implementation.TableServiceEncryptionStatusImpl;
import java.util.HashMap;
import java.util.Map;

final class StorageEncryptionHelper {
    private final boolean isInCreateMode;
    private final StorageAccountInner inner;
    private final StorageAccountCreateParametersInner createParameters;
    private final StorageAccountUpdateParametersInner updateParameters;

    StorageEncryptionHelper(StorageAccountCreateParametersInner createParameters) {
        this.isInCreateMode = true;
        this.createParameters = createParameters;
        this.updateParameters = null;
        this.inner = null;
    }

    StorageEncryptionHelper(StorageAccountUpdateParametersInner updateParameters, StorageAccountInner inner) {
        this.isInCreateMode = false;
        this.createParameters = null;
        this.updateParameters = updateParameters;
        this.inner = inner;
    }

    static StorageAccountEncryptionKeySource encryptionKeySource(StorageAccountInner inner) {
        if (inner.encryption() == null || inner.encryption().keySource() == null) {
            return null;
        }
        return StorageAccountEncryptionKeySource.fromString(inner.encryption().keySource().toString());
    }

    static Map<StorageService, StorageAccountEncryptionStatus> encryptionStatuses(StorageAccountInner inner) {
        HashMap<StorageService, StorageAccountEncryptionStatus> statuses = new HashMap<StorageService, StorageAccountEncryptionStatus>();
        EncryptionServices services = null;
        if (inner.encryption() != null) {
            services = inner.encryption().services();
        }
        statuses.put(StorageService.BLOB, new BlobServiceEncryptionStatusImpl(services));
        statuses.put(StorageService.FILE, new FileServiceEncryptionStatusImpl(services));
        statuses.put(StorageService.TABLE, new TableServiceEncryptionStatusImpl(services));
        statuses.put(StorageService.QUEUE, new QueueServiceEncryptionStatusImpl(services));
        return statuses;
    }

    StorageEncryptionHelper withBlobEncryption() {
        Encryption encryption = this.getEncryptionConfig(true);
        if (encryption.services() == null) {
            encryption.withServices(new EncryptionServices());
        }
        if (encryption.services().blob() == null) {
            encryption.services().withBlob(new EncryptionService());
        }
        encryption.services().blob().withEnabled(true);
        if (encryption.keySource() == null) {
            encryption.withKeySource(KeySource.MICROSOFT_STORAGE);
        }
        return this;
    }

    StorageEncryptionHelper withFileEncryption() {
        Encryption encryption = this.getEncryptionConfig(true);
        if (encryption.services() == null) {
            encryption.withServices(new EncryptionServices());
        }
        if (encryption.services().file() == null) {
            encryption.services().withFile(new EncryptionService());
        }
        encryption.services().file().withEnabled(true);
        if (encryption.keySource() == null) {
            encryption.withKeySource(KeySource.MICROSOFT_STORAGE);
        }
        return this;
    }

    StorageEncryptionHelper withEncryptionKeyFromKeyVault(String keyVaultUri, String keyName, String keyVersion) {
        Encryption encryption = this.getEncryptionConfig(true);
        encryption.withKeySource(KeySource.MICROSOFT_KEYVAULT);
        encryption.withKeyVaultProperties(new KeyVaultProperties().withKeyVaultUri(keyVaultUri).withKeyName(keyName).withKeyVersion(keyVersion));
        return this;
    }

    StorageEncryptionHelper withoutBlobEncryption() {
        Encryption encryption = this.getEncryptionConfig(true);
        if (encryption.services() == null) {
            encryption.withServices(new EncryptionServices());
        }
        if (encryption.services().blob() == null) {
            encryption.services().withBlob(new EncryptionService());
        }
        encryption.services().blob().withEnabled(false);
        if (encryption.keySource() == null) {
            encryption.withKeySource(KeySource.MICROSOFT_STORAGE);
        }
        return this;
    }

    StorageEncryptionHelper withoutFileEncryption() {
        Encryption encryption = this.getEncryptionConfig(true);
        if (encryption.services() == null) {
            encryption.withServices(new EncryptionServices());
        }
        if (encryption.services().file() == null) {
            encryption.services().withFile(new EncryptionService());
        }
        encryption.services().file().withEnabled(false);
        if (encryption.keySource() == null) {
            encryption.withKeySource(KeySource.MICROSOFT_STORAGE);
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Encryption getEncryptionConfig(boolean createIfNotExists) {
        if (this.isInCreateMode) {
            if (this.createParameters.encryption() != null) return this.createParameters.encryption();
            if (!createIfNotExists) return null;
            this.createParameters.withEncryption(new Encryption());
            return this.createParameters.encryption();
        }
        if (this.updateParameters.encryption() != null) return this.updateParameters.encryption();
        if (this.inner.encryption() == null) {
            if (!createIfNotExists) return null;
            this.updateParameters.withEncryption(new Encryption());
            return this.updateParameters.encryption();
        } else {
            Encryption clonedEncryption = new Encryption();
            clonedEncryption.withKeySource(this.inner.encryption().keySource());
            if (this.inner.encryption().keyVaultProperties() != null) {
                clonedEncryption.withKeyVaultProperties(new KeyVaultProperties());
                clonedEncryption.keyVaultProperties().withKeyName(this.inner.encryption().keyVaultProperties().keyName()).withKeyVaultUri(this.inner.encryption().keyVaultProperties().keyVaultUri()).withKeyVersion(this.inner.encryption().keyVaultProperties().keyVersion());
            }
            if (this.inner.encryption().services() != null) {
                clonedEncryption.withServices(new EncryptionServices());
                if (this.inner.encryption().services().blob() != null) {
                    clonedEncryption.services().withBlob(new EncryptionService());
                    clonedEncryption.services().blob().withEnabled(this.inner.encryption().services().blob().enabled());
                }
                if (this.inner.encryption().services().file() != null) {
                    clonedEncryption.services().withFile(new EncryptionService());
                    clonedEncryption.services().file().withEnabled(this.inner.encryption().services().file().enabled());
                }
            }
            this.updateParameters.withEncryption(clonedEncryption);
        }
        return this.updateParameters.encryption();
    }
}

