/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.HttpEvent;
import com.microsoft.aad.msal4j.HttpRequest;
import com.microsoft.aad.msal4j.HttpUtils;
import com.microsoft.aad.msal4j.IHttpClient;
import com.microsoft.aad.msal4j.IHttpResponse;
import com.microsoft.aad.msal4j.LogHelper;
import com.microsoft.aad.msal4j.MsalClientException;
import com.microsoft.aad.msal4j.RequestContext;
import com.microsoft.aad.msal4j.ServiceBundle;
import com.microsoft.aad.msal4j.StringHelper;
import com.microsoft.aad.msal4j.TelemetryHelper;
import com.microsoft.aad.msal4j.XmsClientTelemetryInfo;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpHelper {
    private static final Logger log = LoggerFactory.getLogger(HttpHelper.class);

    HttpHelper() {
    }

    static IHttpResponse executeHttpRequest(HttpRequest httpRequest, RequestContext requestContext, ServiceBundle serviceBundle) {
        IHttpResponse httpResponse;
        HttpEvent httpEvent = new HttpEvent();
        try (TelemetryHelper telemetryHelper = serviceBundle.getTelemetryManager().createTelemetryHelper(requestContext.telemetryRequestId(), requestContext.clientId(), httpEvent, false);){
            HttpHelper.addRequestInfoToTelemetry(httpRequest, httpEvent);
            try {
                IHttpClient httpClient = serviceBundle.getHttpClient();
                httpResponse = httpClient.send(httpRequest);
            }
            catch (Exception e) {
                httpEvent.setOauthErrorCode("unknown");
                throw new MsalClientException(e);
            }
            HttpHelper.addResponseInfoToTelemetry(httpResponse, httpEvent);
            if (httpResponse.headers() != null) {
                HttpHelper.verifyReturnedCorrelationId(httpRequest, httpResponse);
            }
        }
        return httpResponse;
    }

    private static void addRequestInfoToTelemetry(HttpRequest httpRequest, HttpEvent httpEvent) {
        try {
            httpEvent.setHttpPath(httpRequest.url().toURI());
            httpEvent.setHttpMethod(httpRequest.httpMethod().toString());
            if (!StringHelper.isBlank(httpRequest.url().getQuery())) {
                httpEvent.setQueryParameters(httpRequest.url().getQuery());
            }
        }
        catch (Exception ex) {
            String correlationId = httpRequest.headerValue("client-request-id");
            log.warn(LogHelper.createMessage("Setting URL telemetry fields failed: " + LogHelper.getPiiScrubbedDetails(ex), correlationId != null ? correlationId : ""));
        }
    }

    private static void addResponseInfoToTelemetry(IHttpResponse httpResponse, HttpEvent httpEvent) {
        XmsClientTelemetryInfo xmsClientTelemetryInfo;
        String xMsClientTelemetry;
        String xMsRequestId;
        httpEvent.setHttpResponseStatus(httpResponse.statusCode());
        Map<String, List<String>> headers = httpResponse.headers();
        String userAgent = HttpUtils.headerValue(headers, "User-Agent");
        if (!StringHelper.isBlank(userAgent)) {
            httpEvent.setUserAgent(userAgent);
        }
        if (!StringHelper.isBlank(xMsRequestId = HttpUtils.headerValue(headers, "x-ms-request-id"))) {
            httpEvent.setRequestIdHeader(xMsRequestId);
        }
        if ((xMsClientTelemetry = HttpUtils.headerValue(headers, "x-ms-clitelem")) != null && (xmsClientTelemetryInfo = XmsClientTelemetryInfo.parseXmsTelemetryInfo(xMsClientTelemetry)) != null) {
            httpEvent.setXmsClientTelemetryInfo(xmsClientTelemetryInfo);
        }
    }

    private static void verifyReturnedCorrelationId(HttpRequest httpRequest, IHttpResponse httpResponse) {
        String sentCorrelationId = httpRequest.headerValue("client-request-id");
        String returnedCorrelationId = HttpUtils.headerValue(httpResponse.headers(), "client-request-id");
        if (StringHelper.isBlank(returnedCorrelationId) || !returnedCorrelationId.equals(sentCorrelationId)) {
            String msg = LogHelper.createMessage(String.format("Sent (%s) Correlation Id is not same as received (%s).", sentCorrelationId, returnedCorrelationId), sentCorrelationId);
            log.info(msg);
        }
    }
}

