/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.AbstractMsalAuthorizationGrant;
import com.microsoft.aad.msal4j.StringHelper;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class OAuthAuthorizationGrant
extends AbstractMsalAuthorizationGrant {
    private AuthorizationGrant grant;
    private final Map<String, List<String>> params = new LinkedHashMap<String, List<String>>();

    private OAuthAuthorizationGrant() {
        this.params.put("scope", Collections.singletonList("openid profile offline_access"));
    }

    OAuthAuthorizationGrant(AuthorizationGrant grant, Set<String> scopesSet) {
        this(grant, scopesSet != null ? String.join((CharSequence)" ", scopesSet) : null);
    }

    OAuthAuthorizationGrant(AuthorizationGrant grant, String scopes) {
        this();
        this.grant = grant;
        if (!StringHelper.isBlank(scopes)) {
            this.scopes = scopes;
            this.params.put("scope", Collections.singletonList(String.join((CharSequence)" ", (Iterable<? extends CharSequence>)this.params.get("scope")) + " " + scopes));
        }
    }

    OAuthAuthorizationGrant(AuthorizationGrant grant, Map<String, List<String>> params) {
        this();
        this.grant = grant;
        if (params != null) {
            this.params.putAll(params);
        }
    }

    @Override
    public Map<String, List<String>> toParameters() {
        LinkedHashMap<String, List<String>> outParams = new LinkedHashMap<String, List<String>>();
        outParams.putAll(this.params);
        outParams.put("client_info", Collections.singletonList("1"));
        outParams.putAll(this.grant.toParameters());
        return Collections.unmodifiableMap(outParams);
    }

    AuthorizationGrant getAuthorizationGrant() {
        return this.grant;
    }

    Map<String, List<String>> getCustomParameters() {
        return this.params;
    }
}

