/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.maven.plugin.license.document;

import com.mycila.maven.plugin.license.document.Document;
import com.mycila.maven.plugin.license.header.HeaderDefinition;
import java.io.File;
import java.util.Map;

public final class DocumentFactory {
    private final Map<String, String> mapping;
    private final Map<String, HeaderDefinition> definitions;
    private final File basedir;
    private final String encoding;
    private final String[] keywords;

    public DocumentFactory(File basedir, Map<String, String> mapping, Map<String, HeaderDefinition> definitions, String encoding, String[] keywords) {
        this.mapping = mapping;
        this.definitions = definitions;
        this.basedir = basedir;
        this.encoding = encoding;
        this.keywords = (String[])keywords.clone();
    }

    public Document createDocuments(String file) {
        return this.getWrapper(file, this.encoding);
    }

    private Document getWrapper(String file, String encoding) {
        String headerType = this.mapping.get("");
        for (Map.Entry<String, String> entry : this.mapping.entrySet()) {
            if (!file.toLowerCase().endsWith("." + entry.getKey().toLowerCase())) continue;
            headerType = entry.getValue().toLowerCase();
            break;
        }
        return new Document(new File(this.basedir, file), this.definitions.get(headerType), encoding, this.keywords);
    }
}

