/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.core.digest;

import com.mzlion.core.binary.Hex;
import com.mzlion.core.exceptions.FatalDigestException;
import com.mzlion.core.lang.Assert;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DigestUtils {
    public static final String ALGORITHM_MD5 = "MD5";
    public static final String ALGORITHM_SHA_1 = "SHA-1";
    public static final String ALGORITHM_SHA_256 = "SHA-256";
    public static final String ALGORITHM_SHA_384 = "SHA-384";
    public static final String ALGORITHM_SHA_512 = "SHA-512";

    private static MessageDigest getMessageDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new FatalDigestException(e);
        }
    }

    static MessageDigest getMd5Digest() {
        return DigestUtils.getMessageDigest(ALGORITHM_MD5);
    }

    private static MessageDigest getSha1Digest() {
        return DigestUtils.getMessageDigest(ALGORITHM_SHA_1);
    }

    private static MessageDigest getSha256Digest() {
        return DigestUtils.getMessageDigest(ALGORITHM_SHA_256);
    }

    private static MessageDigest getSha384Digest() {
        return DigestUtils.getMessageDigest(ALGORITHM_SHA_384);
    }

    private static MessageDigest getSha512Digest() {
        return DigestUtils.getMessageDigest(ALGORITHM_SHA_512);
    }

    public static byte[] sha1(byte[] data) {
        Assert.notEmpty(data, "The data is null or empty.");
        return DigestUtils.getSha1Digest().digest(data);
    }

    public static byte[] sha1(InputStream data) {
        Assert.notNull(data, "The inputStream data is null.");
        try {
            return DigestUtils.digest(DigestUtils.getSha1Digest(), data);
        }
        catch (IOException e) {
            throw new FatalDigestException(e);
        }
    }

    public static String sha1Hex(String data) {
        return DigestUtils.sha1Hex(data, StandardCharsets.UTF_8);
    }

    public static String sha1Hex(String data, Charset encoding) {
        Assert.hasLength(data, "The data is null or empty.");
        Assert.notNull(encoding, "The encoding is null.");
        return DigestUtils.sha1Hex(data.getBytes(encoding));
    }

    public static String sha1Hex(byte[] data) {
        return Hex.encode2String(DigestUtils.sha1(data));
    }

    public static String sha1Hex(InputStream data) {
        return Hex.encode2String(DigestUtils.sha1(data));
    }

    public static byte[] sha256(String data) {
        Assert.hasLength(data, "The data is null or empty.");
        return DigestUtils.sha256(data.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] sha256(byte[] data) {
        Assert.notEmpty(data, "The data is null or empty.");
        return DigestUtils.getSha256Digest().digest(data);
    }

    public static byte[] sha256(InputStream data) {
        Assert.notNull(data, "The inputStream data is null.");
        try {
            return DigestUtils.digest(DigestUtils.getSha256Digest(), data);
        }
        catch (IOException e) {
            throw new FatalDigestException(e);
        }
    }

    public static String sha256Hex(String data) {
        return Hex.encode2String(DigestUtils.sha256(data));
    }

    public static String sha256Hex(String data, Charset encoding) {
        Assert.hasLength(data, "The data is null or empty.");
        Assert.notNull(encoding, "Encoding is null.");
        return DigestUtils.sha256Hex(data.getBytes(encoding));
    }

    public static String sha256Hex(byte[] data) {
        return Hex.encode2String(DigestUtils.sha256(data));
    }

    public static String sha256Hex(InputStream data) {
        return Hex.encode2String(DigestUtils.sha256(data));
    }

    public static byte[] sha384(String data) {
        return DigestUtils.sha384(data, StandardCharsets.UTF_8);
    }

    public static byte[] sha384(String data, Charset encoding) {
        Assert.notNull(encoding, "Encoding is null.");
        Assert.hasLength(data, "The data is null or empty.");
        return DigestUtils.sha384(data.getBytes(encoding));
    }

    public static byte[] sha384(byte[] data) {
        Assert.notEmpty(data, "The data is null or empty.");
        return DigestUtils.getSha384Digest().digest(data);
    }

    public static byte[] sha384(InputStream data) {
        Assert.notNull(data, "The inputStream data is null.");
        try {
            return DigestUtils.digest(DigestUtils.getSha384Digest(), data);
        }
        catch (IOException e) {
            throw new FatalDigestException(e);
        }
    }

    public static String sha384Hex(String data) {
        return Hex.encode2String(DigestUtils.sha384(data));
    }

    public static String sha384Hex(String data, Charset encoding) {
        return Hex.encode2String(DigestUtils.sha384(data, encoding));
    }

    public static String sha384Hex(byte[] data) {
        return Hex.encode2String(DigestUtils.sha384(data));
    }

    public static String sha384Hex(InputStream data) {
        return Hex.encode2String(DigestUtils.sha384(data));
    }

    public static byte[] sha512(String data) {
        return DigestUtils.sha512(data, StandardCharsets.UTF_8);
    }

    public static byte[] sha512(String data, Charset encoding) {
        Assert.notNull(encoding, "Encoding is null.");
        Assert.hasLength(data, "The data is null or empty.");
        return DigestUtils.sha512(data.getBytes(encoding));
    }

    public static byte[] sha512(byte[] data) {
        Assert.notEmpty(data, "The data is null or empty.");
        return DigestUtils.getSha512Digest().digest(data);
    }

    public static byte[] sha512(InputStream data) {
        Assert.notNull(data, "The inputStream data is null.");
        try {
            return DigestUtils.digest(DigestUtils.getSha512Digest(), data);
        }
        catch (IOException e) {
            throw new FatalDigestException(e);
        }
    }

    public static String sha512Hex(String data) {
        return Hex.encode2String(DigestUtils.sha512(data));
    }

    public static String sha512Hex(String data, Charset encoding) {
        return Hex.encode2String(DigestUtils.sha512(data, encoding));
    }

    public static String sha512Hex(byte[] data) {
        return Hex.encode2String(DigestUtils.sha512(data));
    }

    public static String sha512Hex(InputStream data) {
        return Hex.encode2String(DigestUtils.sha512(data));
    }

    static byte[] digest(MessageDigest digest, InputStream data) throws IOException {
        int read;
        byte[] buffer = new byte[1024];
        while ((read = data.read(buffer, 0, 1024)) != -1) {
            digest.update(buffer, 0, read);
        }
        return digest.digest();
    }
}

