/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.core.http;

import com.mzlion.core.lang.StringUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class ContentType {
    public static final ContentType ALL = ContentType.create("*/*", (Charset)null);
    public static final ContentType TEXT_XML = ContentType.create("text/xml", StandardCharsets.UTF_8);
    public static final ContentType TEXT_PLAIN = ContentType.create("text/plain", StandardCharsets.UTF_8);
    public static final ContentType TEXT_HTML = ContentType.create("text/html", StandardCharsets.UTF_8);
    public static final ContentType MULTIPART_FORM_DATA = ContentType.create("multipart/form-data", StandardCharsets.UTF_8);
    public static final ContentType APPLICATION_XML = ContentType.create("application/xml", StandardCharsets.UTF_8);
    public static final ContentType APPLICATION_OCTET_STREAM = ContentType.create("application/octet-stream", (Charset)null);
    public static final ContentType APPLICATION_FORM_URLENCODED = ContentType.create("application/x-www-form-urlencoded", StandardCharsets.UTF_8);
    public static final ContentType APPLICATION_JSON = ContentType.create("application/json", StandardCharsets.UTF_8);
    public static final ContentType IMAGE_PNG = ContentType.create("image/png", (Charset)null);
    public static final ContentType IMAGE_JPEG = ContentType.create("image/jpeg", (Charset)null);
    public static final ContentType IMAGE_JPG = ContentType.create("image/jpeg", (Charset)null);
    public static final ContentType IMAGE_GIF = ContentType.create("image/gif", (Charset)null);
    public static final ContentType IMAGE_BMP = ContentType.create("image/bmp", (Charset)null);
    public static final ContentType APPLICATION_ZIP = ContentType.create("application/zip", (Charset)null);
    public static final ContentType APPLICATION_GZ = ContentType.create("application/x-gzip", (Charset)null);
    public static final ContentType APPLICATION_PDF = ContentType.create("application/pdf", (Charset)null);
    public static final ContentType APPLICATION_DOC = ContentType.create("application/msword", (Charset)null);
    public static final ContentType APPLICATION_XLS = ContentType.create("application/vnd.ms-excel", (Charset)null);
    public static final ContentType APPLICATION_PPT = ContentType.create("application/vnd.ms-powerpoint", (Charset)null);
    public static final ContentType DEFAULT_TEXT = TEXT_PLAIN;
    public static final ContentType DEFAULT_BINARY = APPLICATION_OCTET_STREAM;
    private static final Map<String, String> supportFileExts;
    private String mimeType;
    private Charset charset;

    ContentType(String mimeType, Charset charset) {
        this.mimeType = mimeType;
        this.charset = charset;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public static ContentType create(String mimeType, Charset charset) {
        if (StringUtils.isEmpty(mimeType)) {
            throw new IllegalArgumentException("MIME type must not be null.");
        }
        String type = mimeType.toLowerCase(Locale.CHINESE);
        return new ContentType(type, charset);
    }

    public static ContentType create(String mimeType, String charset) {
        return ContentType.create(mimeType, StringUtils.isEmpty(charset) ? null : Charset.forName(charset));
    }

    public static ContentType create(String mimeType) {
        return ContentType.create(mimeType, (Charset)null);
    }

    public static ContentType parseByFileExt(String fileExt) {
        String mimeType = supportFileExts.get(fileExt);
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        return ContentType.create(mimeType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.mimeType);
        if (this.charset != null) {
            sb.append("; charset=").append(this.charset.name());
        }
        return sb.toString();
    }

    static {
        HashMap<String, String> _supportFileExts = new HashMap<String, String>();
        _supportFileExts.put("xml", "application/xml");
        _supportFileExts.put("json", "application/json");
        _supportFileExts.put("doc", "application/msword");
        _supportFileExts.put("docx", "application/msword");
        _supportFileExts.put("xls", "application/vnd.ms-excel");
        _supportFileExts.put("xlsx", "application/vnd.ms-excel");
        _supportFileExts.put("ppt", "application/vnd.ms-powerpoint");
        _supportFileExts.put("pptx", "application/vnd.ms-powerpoint");
        _supportFileExts.put("pdf", "application/pdf");
        _supportFileExts.put("zip", "application/zip");
        _supportFileExts.put("gzip", "application/x-gzip");
        _supportFileExts.put("gzip", "application/x-gzip");
        _supportFileExts.put("png", "image/png");
        _supportFileExts.put("jpeg", "image/jpeg");
        _supportFileExts.put("jpg", "image/jpeg");
        _supportFileExts.put("gif", "image/gif");
        _supportFileExts.put("html", "text/html");
        _supportFileExts.put("txt", "text/plain");
        supportFileExts = _supportFileExts;
    }
}

