/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.core.http;

import com.mzlion.core.http.ContentType;
import com.mzlion.core.io.FileUtils;
import com.mzlion.core.io.FilenameUtils;
import com.mzlion.core.io.IOUtils;
import com.mzlion.core.lang.Assert;
import com.mzlion.core.lang.StringUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseDownloadUtils {
    private static Logger logger = LoggerFactory.getLogger(ResponseDownloadUtils.class);
    private static final String BROWSER_IE = "MSIE";
    private static final String BROWSER_EDGE = "Edge";
    private static final String BROWSER_CHROME = "Chrome";
    private static final String BROWSER_SAFARI = "Safari";
    private static final String BROWSER_FIREFOX = "Firefox";

    public static void downloadInline(HttpServletRequest request, HttpServletResponse response, File downloadFile) {
        ResponseDownloadUtils.downloadInline(request, response, downloadFile, false);
    }

    public static void downloadInline(HttpServletRequest request, HttpServletResponse response, File downloadFile, boolean isDeleted) {
        ResponseDownloadUtils.downloadInline(request, response, downloadFile.getName(), downloadFile, isDeleted);
    }

    public static void downloadInline(HttpServletRequest request, HttpServletResponse response, String displayFilename, File downloadFile, boolean isDeleted) {
        ResponseDownloadUtils.doDownload(request, response, displayFilename, downloadFile, isDeleted, true);
    }

    public static void download(File downloadFile, HttpServletRequest request, HttpServletResponse response) {
        ResponseDownloadUtils.download(downloadFile, false, request, response);
    }

    public static void download(File downloadFile, boolean isDeleted, HttpServletRequest request, HttpServletResponse response) {
        Assert.notNull(downloadFile, "Download file must not be null.");
        ResponseDownloadUtils.download(downloadFile.getName(), downloadFile, isDeleted, request, response);
    }

    public static void download(String displayName, File downloadFile, boolean isDeleted, HttpServletRequest request, HttpServletResponse response) {
        Assert.notNull(downloadFile, "Download file must not be null.");
        try (FileInputStream in = new FileInputStream(downloadFile);){
            ResponseDownloadUtils.download(displayName, in, downloadFile.length(), request, response);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (isDeleted) {
            FileUtils.delete(downloadFile);
        }
    }

    public static void download(String displayName, InputStream in, HttpServletRequest request, HttpServletResponse response) {
        ResponseDownloadUtils.download(displayName, in, -1L, request, response);
    }

    public static void download(String displayName, InputStream in, long contentLength, HttpServletRequest request, HttpServletResponse response) {
        Assert.notNull(request, "Request must not be null.");
        Assert.notNull(response, "Response must not be null.");
        Assert.hasLength(displayName, "DisplayName must not be null or empty.");
        Assert.notNull(in, "InputStream must not be null.");
        String fileExt = FilenameUtils.getFileExt(displayName);
        response.setContentType(ContentType.create(fileExt).toString());
        if (contentLength != -1L) {
            response.setHeader("content-length", String.valueOf(contentLength));
        }
        response.setHeader("Content-disposition", "attachment; filename=" + ResponseDownloadUtils.getDownloadFilename(request, displayName));
        try (ServletOutputStream out = response.getOutputStream();){
            if (IOUtils.copy(in, (OutputStream)out) == -1) {
                throw new IOException("Copy input stream to output stream failed.");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void doDownload(HttpServletRequest request, HttpServletResponse response, String filename, File downloadFile, boolean isDeleted, boolean tryDisplay) {
        Assert.notNull(request, "Request must not be null.");
        Assert.notNull(response, "Response must not be null.");
        Assert.hasLength(filename, "Filename must not be null or empty.");
        Assert.notNull(downloadFile, "Download file must not be null.");
        if (!downloadFile.exists()) {
            throw new IllegalArgumentException("File can not be found.");
        }
        if (downloadFile.isDirectory()) {
            throw new IllegalArgumentException("File exists but is a directory.");
        }
        if (!downloadFile.canRead()) {
            throw new IllegalArgumentException("File exists but cannot read.");
        }
        ResponseDownloadUtils.setContentType(response, downloadFile);
        response.setHeader("Content-Length", String.valueOf(downloadFile.length()));
        ServletOutputStream out = null;
        try {
            if (tryDisplay) {
                response.setHeader("Content-disposition", "inline; filename=" + ResponseDownloadUtils.getDownloadFilename(request, filename));
            } else {
                response.setHeader("Content-disposition", "attachment; filename=" + ResponseDownloadUtils.getDownloadFilename(request, filename));
            }
            out = response.getOutputStream();
            FileUtils.copyFile(downloadFile, (OutputStream)out);
            if (isDeleted) {
                logger.debug(" ===> File [{}] will be deleted.", (Object)downloadFile);
                FileUtils.delete(downloadFile);
            }
        }
        catch (IOException e) {
            try {
                logger.error(" ===> Download error->", (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)out);
    }

    public static String getDownloadFilename(HttpServletRequest request, String downloadFilename) {
        String browser = ResponseDownloadUtils.getBrowser(request);
        if (BROWSER_IE.equals(browser) || BROWSER_EDGE.equals(browser)) {
            String filename = ResponseDownloadUtils.toUtf8String(downloadFilename);
            if (filename.length() > 150) {
                filename = new String(filename.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1);
            }
            return filename;
        }
        if (BROWSER_SAFARI.equals(browser)) {
            return new String(downloadFilename.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1);
        }
        return new String(downloadFilename.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1);
    }

    public static String getAcceptLanguage() {
        Locale locale = Locale.getDefault();
        String language = locale.getLanguage();
        String country = locale.getCountry();
        StringBuilder acceptLanguageBuilder = new StringBuilder(language);
        if (!StringUtils.isEmpty(country)) {
            acceptLanguageBuilder.append('-').append(country).append(',').append(language).append(";q=0.8");
        }
        logger.debug(" ===> Append Http header accept-language->{}", (Object)acceptLanguageBuilder.toString());
        return acceptLanguageBuilder.toString();
    }

    private static void setContentType(HttpServletResponse response, File downloadFile) {
        String extension = FilenameUtils.getFileExt(downloadFile);
        if (StringUtils.isEmpty(extension)) {
            response.setContentType(ContentType.DEFAULT_BINARY.toString());
            return;
        }
        switch (extension = extension.toLowerCase()) {
            case "png": {
                response.setContentType(ContentType.IMAGE_PNG.toString());
                break;
            }
            case "jpg": {
                response.setContentType(ContentType.IMAGE_JPG.toString());
                break;
            }
            case "jpeg": {
                response.setContentType(ContentType.IMAGE_JPEG.toString());
                break;
            }
            case "gif": {
                response.setContentType(ContentType.IMAGE_GIF.toString());
                break;
            }
            case "bmp": {
                response.setContentType(ContentType.IMAGE_BMP.toString());
                break;
            }
            case "txt": 
            case "ini": {
                response.setContentType(ContentType.DEFAULT_TEXT.toString());
                break;
            }
            case "xls": 
            case "xlsx": {
                response.setContentType(ContentType.APPLICATION_XLS.toString());
                break;
            }
            case "doc": 
            case "docx": {
                response.setContentType(ContentType.APPLICATION_DOC.toString());
                break;
            }
            case "ppt": 
            case "pptx": {
                response.setContentType(ContentType.APPLICATION_PPT.toString());
                break;
            }
            case "zip": {
                response.setContentType(ContentType.APPLICATION_ZIP.toString());
                break;
            }
            case "gz": {
                response.setContentType(ContentType.APPLICATION_GZ.toString());
                break;
            }
            case "pdf": {
                response.setContentType(ContentType.APPLICATION_PDF.toString());
                break;
            }
            default: {
                response.setContentType(ContentType.DEFAULT_BINARY.toString());
            }
        }
    }

    private static String toUtf8String(String str) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            byte[] b;
            char c = str.charAt(i);
            if (c <= '\u00ff') {
                sb.append(c);
                continue;
            }
            try {
                b = Character.toString(c).getBytes("utf-8");
            }
            catch (Exception ex) {
                logger.error("\u5c06\u6587\u4ef6\u540d\u4e2d\u7684\u6c49\u5b57\u8f6c\u4e3aUTF8\u7f16\u7801\u7684\u4e32\u65f6\u9519\u8bef\uff0c\u8f93\u5165\u7684\u5b57\u7b26\u4e32\u4e3a\uff1a" + str);
                b = new byte[]{};
            }
            for (int n : b) {
                int k = n;
                if (k < 0) {
                    k += 256;
                }
                sb.append("%").append(Integer.toHexString(k).toUpperCase());
            }
        }
        return sb.toString();
    }

    private static String getBrowser(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        logger.debug(" ===> User-Agent={}", (Object)userAgent);
        if (StringUtils.isEmpty(userAgent)) {
            logger.warn(" ===> User-Agent cannot find.");
            return BROWSER_CHROME;
        }
        Pattern pattern = Pattern.compile("MISE", 2);
        if (pattern.matcher(userAgent).find()) {
            return BROWSER_IE;
        }
        pattern = Pattern.compile("Trident", 2);
        if (pattern.matcher(userAgent).find()) {
            return BROWSER_IE;
        }
        pattern = Pattern.compile(BROWSER_EDGE, 2);
        if (pattern.matcher(userAgent).find()) {
            return BROWSER_EDGE;
        }
        pattern = Pattern.compile(BROWSER_CHROME, 2);
        if (pattern.matcher(userAgent).find()) {
            return BROWSER_CHROME;
        }
        pattern = Pattern.compile(BROWSER_SAFARI, 2);
        if (pattern.matcher(userAgent).find()) {
            return BROWSER_SAFARI;
        }
        pattern = Pattern.compile(BROWSER_FIREFOX, 2);
        if (pattern.matcher(userAgent).find()) {
            return BROWSER_FIREFOX;
        }
        logger.warn(" ===> Browser type is unknown.");
        return BROWSER_CHROME;
    }
}

