/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.core.lang;

import com.mzlion.core.lang.CollectionUtils;
import com.mzlion.core.lang.StringUtils;
import java.util.Collection;
import java.util.Map;

public class Assert {
    private Assert() {
        throw new UnsupportedOperationException();
    }

    public static void isTrue(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notNull(Object data, String message) {
        if (data == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void hasLength(String text, String message) {
        if (StringUtils.isEmpty(text)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(Collection<?> collection, String message) {
        if (CollectionUtils.isEmpty(collection)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(Map<?, ?> map, String message) {
        if (CollectionUtils.isEmpty(map)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static <T> void notEmpty(T[] array, String message) {
        if (null == array || array.length == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(char[] array, String message) {
        if (null == array || array.length == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(boolean[] array, String message) {
        if (null == array || array.length == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(byte[] array, String message) {
        if (null == array || array.length == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(short[] array, String message) {
        if (null == array || array.length == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(int[] array, String message) {
        if (null == array || array.length == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(long[] array, String message) {
        if (null == array || array.length == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(float[] array, String message) {
        if (null == array || array.length == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(double[] array, String message) {
        if (null == array || array.length == 0) {
            throw new IllegalArgumentException(message);
        }
    }
}

