/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.core.lang;

import com.mzlion.core.lang.StringUtils;
import java.math.BigDecimal;
import java.util.regex.Pattern;

public class NumberUtils {
    private NumberUtils() {
        throw new UnsupportedOperationException();
    }

    public static String avoidScientificNotation(double val) {
        return NumberUtils.avoidScientificNotation(String.valueOf(val));
    }

    public static String avoidScientificNotation(String val) {
        return StringUtils.isEmpty(val) ? "" : (val.matches("^\\d(.\\d+)?[eE](\\d+)$") ? new BigDecimal(val).toPlainString() : val);
    }

    public static boolean isDigital(String str) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(String str) {
        if (StringUtils.hasText(str)) {
            String regex = "^[-+]?(\\d+)?(\\.\\d+)?$";
            Pattern pattern = Pattern.compile(regex);
            return pattern.matcher(str).find();
        }
        return false;
    }

    public static long yuan2Fen(long yuan) {
        return yuan * 100L;
    }

    public static long yuan2Fen(double yuan) {
        return NumberUtils.yuan2Fen(Double.toString(yuan));
    }

    public static long yuan2Fen(String yuan) {
        return NumberUtils.yuan2Fen(yuan, true);
    }

    public static long yuan2Fen(double yuan, boolean round) {
        return NumberUtils.yuan2Fen(Double.toString(yuan), round);
    }

    public static long yuan2Fen(String yuan, boolean round) {
        BigDecimal multiplier = new BigDecimal(String.valueOf(yuan));
        BigDecimal multiplicand = new BigDecimal(100);
        multiplier = round ? multiplier.setScale(2, 4) : multiplier.setScale(2, 1);
        BigDecimal result = multiplier.multiply(multiplicand);
        return result.longValue();
    }

    public static String yuan2FenString(String yuan) {
        return String.valueOf(NumberUtils.yuan2Fen(yuan, true));
    }

    public static double fen2Yuan(long fen) {
        return NumberUtils.fen2Yuan(Long.toString(fen));
    }

    public static double fen2Yuan(String fen) {
        BigDecimal dividend = new BigDecimal(fen);
        BigDecimal divisor = new BigDecimal(100);
        BigDecimal result = dividend.divide(divisor, 2, 4);
        return result.doubleValue();
    }
}

