/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.agentdir;

import java.util.Objects;
import java.util.regex.Pattern;

public class JarDescription {
    static final String VERSION_PATTERN = "(-[0-9]+\\.[0-9]+\\.[0-9]+((\\-SNAPSHOT)|(-RC[0-9]+))?)?";
    static final String SIMPLE_PATTERN = "-x.x.x(-SNAPSHOT)(-RCx)";
    private final String prefix;
    private final boolean required;

    public JarDescription(String prefix, boolean required) {
        this.prefix = Objects.requireNonNull(prefix, "prefix");
        this.required = required;
    }

    public String getJarName() {
        return this.prefix.concat(".jar");
    }

    public String getJarName(String version) {
        return String.format("%s-%s.jar", this.prefix, version);
    }

    public Pattern getVersionPattern() {
        return Pattern.compile(this.prefix + VERSION_PATTERN + "\\.jar");
    }

    public String getSimplePattern() {
        return this.prefix + SIMPLE_PATTERN + ".jar";
    }

    public boolean isRequired() {
        return this.required;
    }
}

