/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap;

import com.navercorp.pinpoint.bootstrap.BootLogLevel;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Formatter;
import java.util.Objects;

public final class BootLogger {
    private static final String FORMAT = "%tm-%<td %<tT.%<tL %-5s %-35.35s : %s";
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final BootLogLevel LOG_LEVEL = BootLogger.getLogLevel();
    private final String loggerName;
    private final PrintStream out;
    private final PrintStream err;

    private static BootLogLevel getLogLevel() {
        String logLevel = System.getProperty("pinpoint.agent.bootlogger.loglevel", BootLogLevel.INFO.name());
        BootLogLevel level = BootLogLevel.of(logLevel = logLevel.toUpperCase());
        return level != null ? level : BootLogLevel.INFO;
    }

    public BootLogger(String loggerName) {
        this(loggerName, System.out, System.err);
    }

    BootLogger(String loggerName, PrintStream out, PrintStream err) {
        this.loggerName = Objects.requireNonNull(loggerName, "loggerName");
        this.out = out;
        this.err = err;
    }

    public static BootLogger getLogger(Class clazz) {
        return new BootLogger(clazz.getSimpleName());
    }

    public static BootLogger getLogger(String loggerName) {
        return new BootLogger(loggerName);
    }

    private String format(String logLevel, String msg, Throwable throwable) {
        long now = System.currentTimeMillis();
        StringBuilder buffer = new StringBuilder(64);
        Formatter formatter = new Formatter(buffer);
        formatter.format(FORMAT, now, logLevel, this.loggerName, msg);
        if (throwable != null) {
            StringBuffer exceptionMessage = this.getStackTrace(throwable);
            buffer.append(exceptionMessage);
        } else {
            buffer.append(LINE_SEPARATOR);
        }
        return formatter.toString();
    }

    public boolean isDebugEnabled() {
        return LOG_LEVEL.logDebug();
    }

    public void debug(String msg) {
        if (this.isDebugEnabled()) {
            String formatMessage = this.format("DEBUG", msg, null);
            this.out.print(formatMessage);
        }
    }

    public boolean isInfoEnabled() {
        return LOG_LEVEL.logInfo();
    }

    public void info(String msg) {
        if (this.isInfoEnabled()) {
            String formatMessage = this.format("INFO", msg, null);
            this.out.print(formatMessage);
        }
    }

    public boolean isWarnEnabled() {
        return LOG_LEVEL.logWarn();
    }

    public void warn(String msg) {
        this.warn(msg, null);
    }

    public void warn(String msg, Throwable throwable) {
        if (this.isWarnEnabled()) {
            String formatMessage = this.format("WARN", msg, throwable);
            this.err.print(formatMessage);
        }
    }

    public void error(String msg) {
        if (LOG_LEVEL.logError()) {
            String formatMessage = this.format("ERROR", msg, null);
            this.err.print(formatMessage);
        }
    }

    private StringBuffer getStackTrace(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StringWriter sw = new StringWriter(512);
        PrintWriter pw = new PrintWriter(sw);
        pw.println();
        throwable.printStackTrace(pw);
        pw.close();
        return sw.getBuffer();
    }
}

