/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.agentdir;

import com.navercorp.pinpoint.bootstrap.BootLogger;
import com.navercorp.pinpoint.bootstrap.agentdir.AgentDirectory;
import com.navercorp.pinpoint.bootstrap.agentdir.BootDir;
import com.navercorp.pinpoint.bootstrap.agentdir.ClassPathResolver;
import com.navercorp.pinpoint.bootstrap.agentdir.FileUtils;
import com.navercorp.pinpoint.bootstrap.agentdir.JarDescription;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;

public class AgentDirBaseClassPathResolver
implements ClassPathResolver {
    private final BootLogger logger = BootLogger.getLogger(this.getClass());
    static final String VERSION_PATTERN = "(-[0-9]+\\.[0-9]+\\.[0-9]+((\\-SNAPSHOT)|(-RC[0-9]+))?)?";
    static final JarDescription bootstrap = new JarDescription("pinpoint-bootstrap", true);
    private static final String EXTENSIONS = "*.{jar,xml,properties}";
    private final JarDescription commons = new JarDescription("pinpoint-commons", true);
    private final JarDescription commonsConfig = new JarDescription("pinpoint-commons-config", true);
    private final JarDescription bootstrapCore = new JarDescription("pinpoint-bootstrap-core", true);
    private final JarDescription annotations = new JarDescription("pinpoint-annotations", false);
    private final JarDescription bootstrapJava8 = new JarDescription("pinpoint-bootstrap-java8", false);
    private final JarDescription bootstrapJava9 = new JarDescription("pinpoint-bootstrap-java9", false);
    private final JarDescription bootstrapJava9internal = new JarDescription("pinpoint-bootstrap-java9-internal", false);
    private final JarDescription bootstrapJava15 = new JarDescription("pinpoint-bootstrap-java15", false);
    private final JarDescription bootstrapJava16 = new JarDescription("pinpoint-bootstrap-java16", false);
    private final List<JarDescription> bootJarDescriptions = Arrays.asList(this.commons, this.commonsConfig, this.bootstrapCore, this.annotations, this.bootstrapJava8, this.bootstrapJava9, this.bootstrapJava9internal, this.bootstrapJava15, this.bootstrapJava16);
    private final Path bootstrapJarPath;

    public AgentDirBaseClassPathResolver(Path bootstrapJarPath) {
        this.bootstrapJarPath = Objects.requireNonNull(bootstrapJarPath, "classPath");
    }

    @Override
    public AgentDirectory resolve() {
        if (!this.bootstrapJarPath.toFile().isFile()) {
            throw new IllegalStateException(this.bootstrapJarPath + " not found");
        }
        Path bootstrapJarName = this.findBootstrapJar(this.bootstrapJarPath);
        if (bootstrapJarName == null) {
            throw new IllegalStateException(bootstrap.getSimplePattern() + " not found.");
        }
        Path agentDirPath = this.getAgentDirPath(this.bootstrapJarPath);
        BootDir bootDir = this.resolveBootDir(agentDirPath);
        Path agentLibPath = this.getAgentLibPath(agentDirPath);
        List<Path> libs = this.resolveLib(agentLibPath);
        Path agentPluginPath = this.getAgentPluginPath(agentDirPath);
        List<Path> plugins = this.resolvePlugins(agentPluginPath);
        AgentDirectory agentDirectory = new AgentDirectory(bootstrapJarName, this.bootstrapJarPath, agentDirPath, bootDir, libs, plugins);
        return agentDirectory;
    }

    private Path getAgentDirPath(Path agentJarFullPath) {
        Path agentDirPathStr = agentJarFullPath.getParent();
        if (agentDirPathStr == null) {
            throw new IllegalStateException("agentDirPath is null " + agentJarFullPath);
        }
        this.logger.info("Agent original-path:" + agentDirPathStr);
        Path agentDirPath = FileUtils.toRealPath(agentDirPathStr);
        this.logger.info("Agent real-path:" + agentDirPath);
        return agentDirPath;
    }

    private BootDir resolveBootDir(Path agentDirPath) {
        Path bootDirPath = agentDirPath.resolve("boot");
        return new BootDir(bootDirPath, this.bootJarDescriptions);
    }

    public List<JarDescription> getBootJarDescriptions() {
        return Collections.unmodifiableList(this.bootJarDescriptions);
    }

    Path findBootstrapJar(Path bootstrapJarPath) {
        Path fileName = bootstrapJarPath.getFileName();
        if (fileName == null) {
            return null;
        }
        Matcher matcher = bootstrap.getVersionPattern().matcher(fileName.toString());
        if (!matcher.find()) {
            return null;
        }
        return fileName;
    }

    private Path getAgentLibPath(Path agentDirPath) {
        return agentDirPath.resolve("lib");
    }

    private Path getAgentPluginPath(Path agentDirPath) {
        return agentDirPath.resolve("plugin");
    }

    private List<Path> resolveLib(Path agentLibPath) {
        if (this.checkDirectory(agentLibPath.toFile())) {
            return Collections.emptyList();
        }
        List<Path> libFileList = FileUtils.listFiles(agentLibPath, EXTENSIONS);
        if (libFileList.isEmpty()) {
            throw new RuntimeException(agentLibPath + " lib dir is empty");
        }
        libFileList.add(agentLibPath);
        return libFileList;
    }

    private List<Path> resolvePlugins(Path agentPluginPath) {
        if (this.checkDirectory(agentPluginPath.toFile())) {
            this.logger.warn(agentPluginPath + " is not a directory");
            return Collections.emptyList();
        }
        List<Path> jars = FileUtils.listFiles(agentPluginPath, "*.jar");
        if (jars.isEmpty()) {
            return Collections.emptyList();
        }
        List<Path> pluginFileList = this.filterReadPermission(jars);
        for (Path pluginJar : pluginFileList) {
            this.logger.info("Found plugins:" + pluginJar);
        }
        return pluginFileList;
    }

    private boolean checkDirectory(File file) {
        if (!file.exists()) {
            this.logger.warn(file + " not found");
            return true;
        }
        if (!file.isDirectory()) {
            this.logger.warn(file + " is not a directory");
            return true;
        }
        return false;
    }

    private List<Path> filterReadPermission(List<Path> jars) {
        ArrayList<Path> result = new ArrayList<Path>();
        for (Path pluginJar : jars) {
            if (!pluginJar.toFile().canRead()) {
                this.logger.info("File '" + pluginJar + "' cannot be read");
                continue;
            }
            result.add(pluginJar);
        }
        return result;
    }
}

