/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.configcenter.adapter;

import com.nepxion.discovery.common.entity.RuleEntity;
import com.nepxion.discovery.common.entity.SubscriptionType;
import com.nepxion.discovery.plugin.configcenter.loader.RemoteConfigLoader;
import com.nepxion.discovery.plugin.configcenter.logger.ConfigLogger;
import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.framework.event.PluginEventWapper;
import com.nepxion.discovery.plugin.framework.event.RuleClearedEvent;
import com.nepxion.discovery.plugin.framework.event.RuleUpdatedEvent;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class ConfigAdapter
extends RemoteConfigLoader {
    @Autowired
    private PluginAdapter pluginAdapter;
    @Autowired
    private PluginEventWapper pluginEventWapper;
    @Autowired
    private ConfigLogger configLogger;

    @Override
    public String[] getConfigList() throws Exception {
        String[] configList = new String[]{this.getConfig(false), this.getConfig(true)};
        return configList;
    }

    public String getConfig(boolean globalConfig) throws Exception {
        String dataId;
        String group = this.getGroup();
        String config = this.getConfig(group, dataId = this.getDataId(globalConfig));
        if (StringUtils.isNotEmpty((CharSequence)config)) {
            this.configLogger.logFound(globalConfig);
        } else {
            this.configLogger.logNotFound(globalConfig);
        }
        return config;
    }

    public void callbackConfig(String config, boolean globalConfig) {
        SubscriptionType subscriptionType = this.getSubscriptionType(globalConfig);
        if (StringUtils.isNotEmpty((CharSequence)config)) {
            this.configLogger.logUpdatedEvent(globalConfig);
            RuleEntity ruleEntity = null;
            ruleEntity = globalConfig ? this.pluginAdapter.getDynamicGlobalRule() : this.pluginAdapter.getDynamicPartialRule();
            String rule = null;
            if (ruleEntity != null) {
                rule = ruleEntity.getContent();
            }
            if (!StringUtils.equals((CharSequence)rule, (CharSequence)config)) {
                this.fireRuleUpdated(new RuleUpdatedEvent(subscriptionType, config), true);
            } else {
                this.configLogger.logUpdatedSame(globalConfig);
            }
        } else {
            this.configLogger.logClearedEvent(globalConfig);
            this.fireRuleCleared(new RuleClearedEvent(subscriptionType), true);
        }
    }

    public String getGroup() {
        return this.pluginAdapter.getGroup();
    }

    public String getServiceId() {
        return this.pluginAdapter.getServiceId();
    }

    public String getDataId(boolean globalConfig) {
        String group = this.getGroup();
        String serviceId = this.getServiceId();
        return globalConfig ? group : serviceId;
    }

    public void fireRuleUpdated(RuleUpdatedEvent ruleUpdatedEvent, boolean async) {
        this.pluginEventWapper.fireRuleUpdated(ruleUpdatedEvent, async);
    }

    public void fireRuleCleared(RuleClearedEvent ruleClearedEvent, boolean async) {
        this.pluginEventWapper.fireRuleCleared(ruleClearedEvent, async);
    }

    public SubscriptionType getSubscriptionType(boolean globalConfig) {
        return globalConfig ? SubscriptionType.GLOBAL : SubscriptionType.PARTIAL;
    }

    public abstract String getConfig(String var1, String var2) throws Exception;

    public abstract String getConfigType();

    public abstract boolean isConfigSingleKey();
}

