/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.listener.discovery;

import com.nepxion.discovery.common.entity.DiscoveryEntity;
import com.nepxion.discovery.common.entity.RegionEntity;
import com.nepxion.discovery.common.entity.RegionFilterEntity;
import com.nepxion.discovery.common.entity.RuleEntity;
import com.nepxion.discovery.plugin.framework.listener.discovery.AbstractDiscoveryListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cloud.client.ServiceInstance;

public class RegionFilterDiscoveryListener
extends AbstractDiscoveryListener {
    @Override
    public void onGetInstances(String serviceId, List<ServiceInstance> instances) {
        String consumerServiceId = this.pluginAdapter.getServiceId();
        String consumerServiceRegion = this.pluginAdapter.getRegion();
        this.applyRegionFilter(consumerServiceId, consumerServiceRegion, serviceId, instances);
    }

    private void applyRegionFilter(String consumerServiceId, String consumerServiceRegion, String providerServiceId, List<ServiceInstance> instances) {
        if (StringUtils.isEmpty((CharSequence)consumerServiceRegion)) {
            return;
        }
        RuleEntity ruleEntity = this.pluginAdapter.getRule();
        if (ruleEntity == null) {
            return;
        }
        DiscoveryEntity discoveryEntity = ruleEntity.getDiscoveryEntity();
        if (discoveryEntity == null) {
            return;
        }
        RegionFilterEntity regionFilterEntity = discoveryEntity.getRegionFilterEntity();
        if (regionFilterEntity == null) {
            return;
        }
        Map regionEntityMap = regionFilterEntity.getRegionEntityMap();
        if (MapUtils.isEmpty((Map)regionEntityMap)) {
            return;
        }
        List regionEntityList = (List)regionEntityMap.get(consumerServiceId);
        if (CollectionUtils.isEmpty((Collection)regionEntityList)) {
            return;
        }
        ArrayList allNoFilterValueList = null;
        boolean providerConditionDefined = false;
        for (RegionEntity regionEntity : regionEntityList) {
            String providerServiceName = regionEntity.getProviderServiceName();
            if (!StringUtils.equalsIgnoreCase((CharSequence)providerServiceName, (CharSequence)providerServiceId)) continue;
            providerConditionDefined = true;
            List consumerRegionValueList = regionEntity.getConsumerRegionValueList();
            List providerRegionValueList = regionEntity.getProviderRegionValueList();
            if (CollectionUtils.isNotEmpty((Collection)consumerRegionValueList)) {
                if (!consumerRegionValueList.contains(consumerServiceRegion)) continue;
                if (allNoFilterValueList == null) {
                    allNoFilterValueList = new ArrayList();
                }
                if (!CollectionUtils.isNotEmpty((Collection)providerRegionValueList)) continue;
                allNoFilterValueList.addAll(providerRegionValueList);
                continue;
            }
            if (allNoFilterValueList == null) {
                allNoFilterValueList = new ArrayList();
            }
            if (!CollectionUtils.isNotEmpty((Collection)providerRegionValueList)) continue;
            allNoFilterValueList.addAll(providerRegionValueList);
        }
        if (allNoFilterValueList != null) {
            if (allNoFilterValueList.isEmpty()) {
                return;
            }
            Iterator<ServiceInstance> iterator = instances.iterator();
            while (iterator.hasNext()) {
                ServiceInstance serviceInstance = iterator.next();
                String instanceRegion = this.pluginAdapter.getInstanceRegion(serviceInstance);
                if (allNoFilterValueList.contains(instanceRegion)) continue;
                iterator.remove();
            }
        } else if (providerConditionDefined) {
            instances.clear();
        }
    }

    @Override
    public void onGetServices(List<String> services) {
    }

    @Override
    public int getOrder() {
        return -2147483646;
    }
}

