/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.hystrix.configuration;

import com.nepxion.banner.Description;
import com.nepxion.banner.LogoBanner;
import com.nepxion.banner.NepxionBanner;
import com.nepxion.discovery.plugin.strategy.hystrix.context.HystrixContextConcurrencyStrategy;
import com.netflix.hystrix.Hystrix;
import com.taobao.text.Color;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={Hystrix.class})
@ConditionalOnProperty(value={"spring.application.strategy.hystrix.threadlocal.supported"}, matchIfMissing=false)
public class HystrixStrategyAutoConfiguration {
    @Bean
    public HystrixContextConcurrencyStrategy hystrixContextConcurrencyStrategy() {
        return new HystrixContextConcurrencyStrategy();
    }

    static {
        LogoBanner logoBanner = new LogoBanner(HystrixStrategyAutoConfiguration.class, "/com/nepxion/hystrix/resource/logo.txt", "Welcome to Nepxion", 7, 5, new Color[]{Color.red, Color.green, Color.cyan, Color.blue, Color.yellow, Color.magenta, Color.red}, true);
        NepxionBanner.show((LogoBanner)logoBanner, (Description[])new Description[]{new Description("Protect:", "Hystrix", 0, 1), new Description("Github:", "https://github.com/Nepxion/Discovery", 0, 1)});
    }
}

