/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud;

import com.netease.cloud.RequestClientOptions;
import com.netease.cloud.auth.Credentials;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;

public abstract class WebServiceRequest {
    private final RequestClientOptions requestClientOptions = new RequestClientOptions();
    private Credentials credentials;
    private String token;
    private Map<String, String> specialHeaders = null;
    protected String logID;
    protected String logSeq;
    private AtomicLong seqID = new AtomicLong(1L);

    public void setRequestCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public Credentials getRequestCredentials() {
        return this.credentials;
    }

    public Map<String, String> copyPrivateRequestParameters() {
        return this.specialHeaders;
    }

    public void addSpecialHeader(String key, String value) {
        if (this.specialHeaders == null) {
            this.specialHeaders = new HashMap<String, String>();
        }
        this.specialHeaders.put(key, value);
    }

    public RequestClientOptions getRequestClientOptions() {
        return this.requestClientOptions;
    }

    public String getLogID() {
        return this.logID;
    }

    public void setLogID(String logID) {
        this.logID = logID;
    }

    public String getLogSeq() {
        return this.logSeq;
    }

    public String getAndIncrementLogSeq() {
        if (this.logSeq == null || this.logSeq.length() == 0) {
            return Long.toString(this.seqID.getAndIncrement());
        }
        return this.logSeq + "." + this.seqID.getAndIncrement();
    }

    public void setLogSeq(String logSeq) {
        this.logSeq = logSeq;
    }

    public boolean needSetLogInfo() {
        return this.logID != null || this.logSeq != null;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setSSEAlgorithm(String algorithm) {
        this.addSpecialHeader("x-nos-server-side-encryption", algorithm);
    }

    public <T> T withSSEAlgorithm(String algorithm) {
        this.setSSEAlgorithm(algorithm);
        WebServiceRequest t = this;
        return (T)t;
    }

    public String setSSECRandomKey(String algorithm) throws NoSuchAlgorithmException {
        KeyGenerator keyGenerator = null;
        if (!"AES256".equals(algorithm)) {
            return "";
        }
        keyGenerator = KeyGenerator.getInstance("AES");
        keyGenerator.init(256, new SecureRandom());
        SecretKey secretKey = keyGenerator.generateKey();
        String key = Base64.encodeBase64String((byte[])secretKey.getEncoded());
        this.setSSECKey(algorithm, key);
        return key;
    }

    public void setSSECKey(String algorithm, String key) {
        this.addSpecialHeader("x-nos-server-side-encryption-customer-algorithm", algorithm);
        String keyMd5 = Base64.encodeBase64String((byte[])DigestUtils.md5((byte[])Base64.decodeBase64((String)key)));
        this.addSpecialHeader("x-nos-server-side-encryption-customer-key", key);
        this.addSpecialHeader("x-nos-server-side-encryption-customer-key-MD5", keyMd5);
    }

    public <T> T withSSECKey(String algorithm, String key) {
        this.setSSECKey(algorithm, key);
        WebServiceRequest t = this;
        return (T)t;
    }
}

