/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.http;

import com.netease.cloud.ClientConfiguration;
import com.netease.cloud.http.IdleConnectionReaper;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

class ConnectionManagerFactory {
    private static final String HTTP = "http";
    private static final String HTTPS = "https";

    ConnectionManagerFactory() {
    }

    private static Registry<ConnectionSocketFactory> getSsFactory() {
        return RegistryBuilder.create().register(HTTP, (Object)PlainConnectionSocketFactory.getSocketFactory()).register(HTTPS, (Object)SSLConnectionSocketFactory.getSocketFactory()).build();
    }

    public static PoolingHttpClientConnectionManager createPoolingClientConnManager(ClientConfiguration configuration) {
        PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = new PoolingHttpClientConnectionManager(ConnectionManagerFactory.getSsFactory());
        poolingHttpClientConnectionManager.setMaxTotal(configuration.getMaxConnections());
        poolingHttpClientConnectionManager.setDefaultMaxPerRoute(configuration.getMaxConnections());
        poolingHttpClientConnectionManager.setValidateAfterInactivity(1000);
        IdleConnectionReaper.registerConnectionManager((HttpClientConnectionManager)poolingHttpClientConnectionManager);
        return poolingHttpClientConnectionManager;
    }
}

