/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.internal.crypto;

import com.netease.cloud.ClientException;
import com.netease.cloud.auth.CredentialsProvider;
import com.netease.cloud.internal.NOSDirect;
import com.netease.cloud.internal.crypto.AdjustedRangeInputStream;
import com.netease.cloud.internal.crypto.CipherLite;
import com.netease.cloud.internal.crypto.CipherLiteInputStream;
import com.netease.cloud.internal.crypto.ContentCryptoMaterial;
import com.netease.cloud.internal.crypto.ContentCryptoScheme;
import com.netease.cloud.internal.crypto.CryptoConfiguration;
import com.netease.cloud.internal.crypto.CryptoRuntime;
import com.netease.cloud.internal.crypto.EncryptionMaterialsProvider;
import com.netease.cloud.internal.crypto.MultipartUploadCryptoContext;
import com.netease.cloud.internal.crypto.NOSCryptoModuleBase;
import com.netease.cloud.internal.crypto.NOSObjectWrapper;
import com.netease.cloud.services.nos.model.EncryptedGetObjectRequest;
import com.netease.cloud.services.nos.model.GetObjectRequest;
import com.netease.cloud.services.nos.model.InitiateMultipartUploadRequest;
import com.netease.cloud.services.nos.model.NOSObject;
import com.netease.cloud.services.nos.model.NOSObjectInputStream;
import com.netease.cloud.services.nos.model.ObjectMetadata;
import com.netease.cloud.services.nos.model.UploadPartRequest;
import com.netease.cloud.util.IOUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

public class NOSCryptoModuleAE
extends NOSCryptoModuleBase {
    public NOSCryptoModuleAE(NOSDirect NOS, CredentialsProvider credentialsProvider, EncryptionMaterialsProvider kekMaterialsProvider, CryptoConfiguration cryptoConfig) {
        super(NOS, credentialsProvider, kekMaterialsProvider, cryptoConfig);
    }

    protected boolean isStrict() {
        return false;
    }

    @Override
    public NOSObject getObjectSecurely(GetObjectRequest req) {
        NOSObject retrieved;
        long[] desiredRange = req.getRange();
        if (this.isStrict() && desiredRange != null) {
            throw new SecurityException("Range get and getting a part are not allowed in strict crypto mode");
        }
        long[] adjustedCryptoRange = NOSCryptoModuleAE.getAdjustedCryptoRange(desiredRange);
        if (adjustedCryptoRange != null) {
            req.setRange(adjustedCryptoRange[0], adjustedCryptoRange[1]);
        }
        if ((retrieved = this.NOS.getObject(req)) == null) {
            return null;
        }
        String suffix = null;
        if (req instanceof EncryptedGetObjectRequest) {
            EncryptedGetObjectRequest ereq = (EncryptedGetObjectRequest)req;
            suffix = ereq.getInstructionFileSuffix();
        }
        try {
            return this.decipher(req, desiredRange, adjustedCryptoRange, retrieved);
        }
        catch (RuntimeException ex) {
            IOUtils.closeQuietly(retrieved, this.log);
            throw ex;
        }
        catch (Error error) {
            IOUtils.closeQuietly(retrieved, this.log);
            throw error;
        }
    }

    private NOSObject decipher(GetObjectRequest req, long[] desiredRange, long[] cryptoRange, NOSObject retrieved) {
        NOSObjectWrapper wrapped = new NOSObjectWrapper(retrieved);
        if (wrapped.hasEncryptionInfo()) {
            return this.decipherWithMetadata(req, desiredRange, cryptoRange, wrapped);
        }
        this.log.warn(String.format("Unable to detect encryption information for object '%s' in bucket '%s'. Returning object without decryption.", retrieved.getKey(), retrieved.getBucketName()));
        NOSObjectWrapper adjusted = this.adjustToDesiredRange(wrapped, desiredRange, null);
        return adjusted.getNOSObject();
    }

    private NOSObject decipherWithMetadata(GetObjectRequest req, long[] desiredRange, long[] cryptoRange, NOSObjectWrapper retrieved) {
        boolean keyWrapExpected = this.isStrict();
        if (req instanceof EncryptedGetObjectRequest) {
            EncryptedGetObjectRequest ereq = (EncryptedGetObjectRequest)req;
            if (!keyWrapExpected) {
                keyWrapExpected = ereq.isKeyWrapExpected();
            }
        }
        ContentCryptoMaterial cekMaterial = ContentCryptoMaterial.fromObjectMetadata(retrieved.getObjectMetadata(), this.kekMaterialsProvider, this.cryptoConfig.getCryptoProvider(), cryptoRange, keyWrapExpected);
        this.securityCheck(cekMaterial, retrieved);
        NOSObjectWrapper decrypted = this.decrypt(retrieved, cekMaterial, cryptoRange);
        NOSObjectWrapper adjusted = this.adjustToDesiredRange(decrypted, desiredRange, null);
        return adjusted.getNOSObject();
    }

    protected final NOSObjectWrapper adjustToDesiredRange(NOSObjectWrapper NOSObject2, long[] range, Map<String, String> instruction) {
        if (range == null) {
            return NOSObject2;
        }
        ContentCryptoScheme encryptionScheme = NOSObject2.encryptionSchemeOf(instruction);
        long instanceLen = NOSObject2.getObjectMetadata().getContentLength();
        long maxOffset = instanceLen - (long)(encryptionScheme.getTagLengthInBits() / 8) - 1L;
        if (range[1] > maxOffset) {
            range[1] = maxOffset;
            if (range[0] > range[1]) {
                IOUtils.closeQuietly(NOSObject2.getObjectContent(), this.log);
                NOSObject2.setObjectContent(new ByteArrayInputStream(new byte[0]));
                return NOSObject2;
            }
        }
        if (range[0] > range[1]) {
            return NOSObject2;
        }
        try {
            NOSObjectInputStream objectContent = NOSObject2.getObjectContent();
            AdjustedRangeInputStream adjustedRangeContents = new AdjustedRangeInputStream(objectContent, range[0], range[1]);
            NOSObject2.setObjectContent(new NOSObjectInputStream(adjustedRangeContents, objectContent.getHttpRequest()));
            return NOSObject2;
        }
        catch (IOException e) {
            throw new ClientException("Error adjusting output to desired byte range: " + e.getMessage());
        }
    }

    @Override
    public ObjectMetadata getObjectSecurely(GetObjectRequest getObjectRequest, File destinationFile) {
        this.assertParameterNotNull(destinationFile, "The destination file parameter must be specified when downloading an object directly to a file");
        NOSObject NOSObject2 = this.getObjectSecurely(getObjectRequest);
        if (NOSObject2 == null) {
            return null;
        }
        BufferedOutputStream outputStream = null;
        try {
            int bytesRead;
            outputStream = new BufferedOutputStream(new FileOutputStream(destinationFile));
            byte[] buffer = new byte[10240];
            while ((bytesRead = NOSObject2.getObjectContent().read(buffer)) > -1) {
                ((OutputStream)outputStream).write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            try {
                throw new ClientException("Unable to store object contents to disk: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream, this.log);
                IOUtils.closeQuietly(NOSObject2.getObjectContent(), this.log);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(outputStream, this.log);
        IOUtils.closeQuietly(NOSObject2.getObjectContent(), this.log);
        return NOSObject2.getObjectMetadata();
    }

    @Override
    final MultipartUploadCryptoContext newUploadContext(InitiateMultipartUploadRequest req, ContentCryptoMaterial cekMaterial) {
        return new MultipartUploadCryptoContext(req.getBucketName(), req.getKey(), cekMaterial);
    }

    @Override
    final CipherLite cipherLiteForNextPart(MultipartUploadCryptoContext uploadContext) {
        return uploadContext.getCipherLite();
    }

    @Override
    final long computeLastPartSize(UploadPartRequest req) {
        return req.getPartSize() + (long)(this.contentCryptoScheme.getTagLengthInBits() / 8);
    }

    private NOSObjectWrapper decrypt(NOSObjectWrapper wrapper, ContentCryptoMaterial cekMaterial, long[] range) {
        NOSObjectInputStream objectContent = wrapper.getObjectContent();
        wrapper.setObjectContent(new NOSObjectInputStream(new CipherLiteInputStream(objectContent, cekMaterial.getCipherLite(), 2048), objectContent.getHttpRequest()));
        return wrapper;
    }

    private void assertParameterNotNull(Object parameterValue, String errorMessage) {
        if (parameterValue == null) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    @Override
    protected final long ciphertextLength(long originalContentLength) {
        return originalContentLength + (long)(this.contentCryptoScheme.getTagLengthInBits() / 8);
    }

    static {
        CryptoRuntime.enableBouncyCastle();
    }
}

