/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.services.nos.internal;

import com.netease.cloud.ServiceException;
import com.netease.cloud.http.HttpResponse;
import com.netease.cloud.http.HttpResponseHandler;
import com.netease.cloud.services.nos.model.NOSException;
import com.netease.cloud.util.XpathUtils;
import org.w3c.dom.Document;

public class NosErrorResponseHandler
implements HttpResponseHandler<ServiceException> {
    @Override
    public ServiceException handle(HttpResponse errorResponse) throws Exception {
        if (errorResponse.getContent() == null) {
            String requestId = errorResponse.getHeaders().get("x-nos-request-id");
            NOSException ase = new NOSException(errorResponse.getStatusText());
            ase.setStatusCode(errorResponse.getStatusCode());
            ase.setRequestId(requestId);
            this.fillInErrorType(ase, errorResponse);
            return ase;
        }
        Document document = XpathUtils.documentFrom(errorResponse.getContent());
        String message = XpathUtils.asString("Error/Message", document);
        String errorCode = XpathUtils.asString("Error/Code", document);
        String requestId = XpathUtils.asString("Error/RequestId", document);
        String resource = XpathUtils.asString("Error/Resource", document);
        NOSException ase = new NOSException(message);
        ase.setStatusCode(errorResponse.getStatusCode());
        ase.setErrorCode(errorCode);
        ase.setRequestId(requestId);
        ase.setResource(resource);
        this.fillInErrorType(ase, errorResponse);
        return ase;
    }

    private void fillInErrorType(ServiceException ase, HttpResponse errorResponse) {
        if (errorResponse.getStatusCode() >= 500) {
            ase.setErrorType(ServiceException.ErrorType.Service);
        } else {
            ase.setErrorType(ServiceException.ErrorType.Client);
        }
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }
}

