/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.services.nos.internal;

import com.netease.cloud.WebServiceResponse;
import com.netease.cloud.http.HttpResponse;
import com.netease.cloud.services.nos.internal.AbstractNosResponseHandler;
import com.netease.cloud.transform.Unmarshaller;
import java.io.InputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NosXmlResponseHandler<T>
extends AbstractNosResponseHandler<T> {
    private Unmarshaller<T, InputStream> responseUnmarshaller;
    private static final Logger log = LoggerFactory.getLogger((String)"com.netease.cloud.request");
    private Map<String, String> responseHeaders;

    public NosXmlResponseHandler(Unmarshaller<T, InputStream> responseUnmarshaller) {
        this.responseUnmarshaller = responseUnmarshaller;
    }

    @Override
    public WebServiceResponse<T> handle(HttpResponse response) throws Exception {
        WebServiceResponse<T> Response = this.parseResponseMetadata(response);
        this.responseHeaders = response.getHeaders();
        if (this.responseUnmarshaller != null) {
            log.trace("Beginning to parse service response XML");
            T result = this.responseUnmarshaller.unmarshall(response.getContent());
            log.trace("Done parsing service response XML");
            Response.setResult(result);
        }
        return Response;
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }
}

