/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.services.nos.internal;

import com.netease.cloud.http.HttpResponse;
import com.netease.cloud.services.nos.internal.HeaderHandler;
import com.netease.cloud.services.nos.internal.ObjectExpirationResult;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ObjectExpirationHeaderHandler<T extends ObjectExpirationResult>
implements HeaderHandler<T> {
    private static final Pattern datePattern = Pattern.compile("expiry-date=\"(.*?)\"");
    private static final Pattern rulePattern = Pattern.compile("rule-id=\"(.*)\"");

    @Override
    public void handle(T result, HttpResponse response) {
        String expirationHeader = response.getHeaders().get("x-nos-expiration");
        if (expirationHeader != null) {
            result.setExpirationTime(this.parseDate(expirationHeader));
            result.setExpirationTimeRuleId(this.parseRuleId(expirationHeader));
        }
    }

    private String parseRuleId(String expirationHeader) {
        Matcher matcher = rulePattern.matcher(expirationHeader);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private Date parseDate(String expirationHeader) {
        Matcher matcher = datePattern.matcher(expirationHeader);
        if (matcher.find()) {
            String date = matcher.group(1);
            SimpleDateFormat fmt = new SimpleDateFormat("EEE, dd MMM yyyy HH:MM:SS z");
            try {
                return fmt.parse(date);
            }
            catch (ParseException e) {
                return null;
            }
        }
        return null;
    }
}

