/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.services.nos.model;

import com.netease.cloud.WebServiceRequest;
import com.netease.cloud.services.nos.model.CannedAccessControlList;
import com.netease.cloud.services.nos.model.Region;

public class CreateBucketRequest
extends WebServiceRequest {
    private String bucketName;
    private String region;
    private boolean deduplicate;
    private CannedAccessControlList cannedAcl;

    public CreateBucketRequest(String bucketName) {
        this(bucketName, Region.CN_Hnagzhou, false);
    }

    public CreateBucketRequest(String bucketName, Region region, boolean objectDeduplicate) {
        this(bucketName, region.toString(), objectDeduplicate);
    }

    public CreateBucketRequest(String bucketName, String region, boolean deduplicate) {
        this.setBucketName(bucketName);
        this.setRegion(region);
        this.setDeduplicate(deduplicate);
    }

    public boolean isDeduplicate() {
        return this.deduplicate;
    }

    public void setDeduplicate(boolean deduplicate) {
        this.deduplicate = deduplicate;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getRegion() {
        return this.region;
    }

    public CannedAccessControlList getCannedAcl() {
        return this.cannedAcl;
    }

    public void setCannedAcl(CannedAccessControlList cannedAcl) {
        this.cannedAcl = cannedAcl;
    }

    public void setCannedAcl(String cannedAcl) {
        if (cannedAcl != null) {
            boolean isRightAcl = false;
            for (CannedAccessControlList acl : CannedAccessControlList.values()) {
                if (!acl.toString().equals(cannedAcl)) continue;
                this.cannedAcl = acl;
                isRightAcl = true;
                break;
            }
            if (!isRightAcl) {
                throw new IllegalArgumentException("ACL is out of bond.");
            }
        }
    }

    public CreateBucketRequest withCannedAcl(CannedAccessControlList cannedAcl) {
        this.setCannedAcl(cannedAcl);
        return this;
    }
}

