/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.services.nos.model.transform;

import com.netease.cloud.ClientException;
import com.netease.cloud.services.nos.internal.Constants;
import com.netease.cloud.services.nos.internal.DeleteObjectsResponse;
import com.netease.cloud.services.nos.internal.ObjectExpirationResult;
import com.netease.cloud.services.nos.internal.ServiceUtils;
import com.netease.cloud.services.nos.model.Bucket;
import com.netease.cloud.services.nos.model.BucketLifecycleConfiguration;
import com.netease.cloud.services.nos.model.BucketVersioningConfiguration;
import com.netease.cloud.services.nos.model.CompleteMultipartUploadResult;
import com.netease.cloud.services.nos.model.DeduplicateResult;
import com.netease.cloud.services.nos.model.DeleteObjectsResult;
import com.netease.cloud.services.nos.model.GetBucketDedupResult;
import com.netease.cloud.services.nos.model.GetBucketDefault404Result;
import com.netease.cloud.services.nos.model.GetBucketStatsResult;
import com.netease.cloud.services.nos.model.GetObjectVersionsResult;
import com.netease.cloud.services.nos.model.ImageMetadata;
import com.netease.cloud.services.nos.model.InitiateMultipartUploadResult;
import com.netease.cloud.services.nos.model.MultiObjectDeleteException;
import com.netease.cloud.services.nos.model.MultipartUpload;
import com.netease.cloud.services.nos.model.MultipartUploadListing;
import com.netease.cloud.services.nos.model.NOSException;
import com.netease.cloud.services.nos.model.NOSObjectSummary;
import com.netease.cloud.services.nos.model.NOSVersionSummary;
import com.netease.cloud.services.nos.model.ObjectListing;
import com.netease.cloud.services.nos.model.Owner;
import com.netease.cloud.services.nos.model.PartListing;
import com.netease.cloud.services.nos.model.PartSummary;
import com.netease.cloud.services.nos.model.VersionListing;
import com.netease.cloud.services.nos.model.VideoMetadata;
import com.netease.cloud.util.DateUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlResponsesSaxParser {
    private static final Logger log = LoggerFactory.getLogger(XmlResponsesSaxParser.class);
    private XMLReader xr = null;
    private boolean sanitizeXmlDocument = true;

    public XmlResponsesSaxParser() throws ClientException {
        try {
            this.xr = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            System.setProperty("org.xml.sax.driver", "org.apache.crimson.parser.XMLReaderImpl");
            try {
                this.xr = XMLReaderFactory.createXMLReader();
            }
            catch (SAXException e2) {
                throw new ClientException("Couldn't initialize a sax driver for the XMLReader");
            }
        }
    }

    protected void parseXmlInputStream(DefaultHandler handler, InputStream inputStream) throws ClientException {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Parsing XML response document with handler: " + handler.getClass());
            }
            BufferedReader breader = new BufferedReader(new InputStreamReader(inputStream, Constants.DEFAULT_ENCODING));
            this.xr.setContentHandler(handler);
            this.xr.setErrorHandler(handler);
            this.xr.parse(new InputSource(breader));
        }
        catch (Throwable t) {
            block5: {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block5;
                    log.error("Unable to close response InputStream up after XML parse failure", (Throwable)e);
                }
            }
            throw new ClientException("Failed to parse XML document with handler " + handler.getClass(), t);
        }
    }

    protected InputStream sanitizeXmlDocument(DefaultHandler handler, InputStream inputStream) throws ClientException {
        if (!this.sanitizeXmlDocument) {
            return inputStream;
        }
        if (log.isDebugEnabled()) {
            log.debug("Sanitizing XML document destined for handler " + handler.getClass());
        }
        ByteArrayInputStream sanitizedInputStream = null;
        try {
            StringBuilder listingDocBuffer = new StringBuilder();
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, Constants.DEFAULT_ENCODING));
            char[] buf = new char[8192];
            int read = -1;
            while ((read = br.read(buf)) != -1) {
                listingDocBuffer.append(buf, 0, read);
            }
            br.close();
            sanitizedInputStream = new ByteArrayInputStream(listingDocBuffer.toString().getBytes(Constants.DEFAULT_ENCODING));
        }
        catch (Throwable t) {
            block7: {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block7;
                    log.error("Unable to close response InputStream after failure sanitizing XML document", (Throwable)e);
                }
            }
            throw new ClientException("Failed to sanitize XML document destined for handler " + handler.getClass(), t);
        }
        return sanitizedInputStream;
    }

    private String checkForEmptyString(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return null;
        }
        return s;
    }

    private int parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            log.error("Unable to parse integer value '" + s + "'", (Throwable)nfe);
            return -1;
        }
    }

    private long parseLong(String s) {
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException nfe) {
            log.error("Unable to parse long value '" + s + "'", (Throwable)nfe);
            return -1L;
        }
    }

    public ListBucketHandler parseListBucketObjectsResponse(InputStream inputStream) throws ClientException {
        ListBucketHandler handler = new ListBucketHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public ListAllMyBucketsHandler parseListMyBucketsResponse(InputStream inputStream) throws ClientException {
        ListAllMyBucketsHandler handler = new ListAllMyBucketsHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public String parseBucketLocationResponse(InputStream inputStream) throws ClientException {
        BucketLocationHandler handler = new BucketLocationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler.getLocation();
    }

    public BucketVersioningConfigurationHandler parseVersioningConfigurationResponse(InputStream inputStream) throws ClientException {
        BucketVersioningConfigurationHandler handler = new BucketVersioningConfigurationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public DeleteObjectsHandler parseDeletedObjectsResult(InputStream inputStream) {
        DeleteObjectsHandler handler = new DeleteObjectsHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public CopyObjectResultHandler parseCopyObjectResponse(InputStream inputStream) throws ClientException {
        CopyObjectResultHandler handler = new CopyObjectResultHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public CompleteMultipartUploadHandler parseCompleteMultipartUploadResponse(InputStream inputStream) throws ClientException {
        CompleteMultipartUploadHandler handler = new CompleteMultipartUploadHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public InitiateMultipartUploadHandler parseInitiateMultipartUploadResponse(InputStream inputStream) throws ClientException {
        InitiateMultipartUploadHandler handler = new InitiateMultipartUploadHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public ListMultipartUploadsHandler parseListMultipartUploadsResponse(InputStream inputStream) throws ClientException {
        ListMultipartUploadsHandler handler = new ListMultipartUploadsHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public ListPartsHandler parseListPartsResponse(InputStream inputStream) throws ClientException {
        ListPartsHandler handler = new ListPartsHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public GetBucketDedupHandler parseGetBucketDedupResponse(InputStream inputStream) throws ClientException {
        GetBucketDedupHandler handler = new GetBucketDedupHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public GetBucketStatsHandler parseGetBucketStats(InputStream inputStream) throws ClientException {
        GetBucketStatsHandler handler = new GetBucketStatsHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public GetBucketDefault404Handler parseGetBucketDefault404Response(InputStream inputStream) throws ClientException {
        GetBucketDefault404Handler handler = new GetBucketDefault404Handler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public DeduplicateHandler parseDeduplicateResponse(InputStream inputStream) throws ClientException {
        DeduplicateHandler handler = new DeduplicateHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public GetObejctVersionsHandler parseGetObjectVersionsResponse(InputStream inputStream) throws ClientException {
        GetObejctVersionsHandler handler = new GetObejctVersionsHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public boolean parseRequestPaymentConfigurationResponse(InputStream inputStream) throws ClientException {
        RequestPaymentConfigurationHandler handler = new RequestPaymentConfigurationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler.isRequesterPays();
    }

    public GetImageMetaInfoHandler parseGetImageMetaInfoResponse(InputStream inputStream) throws ClientException {
        GetImageMetaInfoHandler handler = new GetImageMetaInfoHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public BucketLifecycleConfigurationHandler parseBucketLifecycleConfigurationResponse(InputStream inputStream) throws IOException {
        BucketLifecycleConfigurationHandler handler = new BucketLifecycleConfigurationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public GetVideoMetaInfoHandler parseGetVideoMetaInfoResponse(InputStream inputStream) throws ClientException {
        GetVideoMetaInfoHandler handler = new GetVideoMetaInfoHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public ListVersionsHandler parseListVersionsResponse(InputStream inputStream) throws ClientException {
        ListVersionsHandler handler = new ListVersionsHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public class BucketLifecycleConfigurationHandler
    extends DefaultHandler {
        private BucketLifecycleConfiguration configuration;
        private BucketLifecycleConfiguration.Rule currentRule;
        private StringBuilder text;

        public BucketLifecycleConfiguration getConfiguration() {
            return this.configuration;
        }

        @Override
        public void startDocument() {
            this.text = new StringBuilder();
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("LifecycleConfiguration")) {
                this.configuration = new BucketLifecycleConfiguration(new ArrayList<BucketLifecycleConfiguration.Rule>());
            } else if (name.equals("Rule")) {
                this.currentRule = new BucketLifecycleConfiguration.Rule();
            }
            this.text.setLength(0);
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            if (!name.equals("LifecycleConfiguration")) {
                if (name.equals("Rule")) {
                    this.configuration.getRules().add(this.currentRule);
                } else if (name.equals("ID")) {
                    this.currentRule.setId(this.text.toString());
                } else if (name.equals("Prefix")) {
                    this.currentRule.setPrefix(this.text.toString());
                } else if (name.equals("Status")) {
                    this.currentRule.setStatus(this.text.toString());
                } else if (!name.equals("Expiration")) {
                    if (name.equals("Date")) {
                        try {
                            this.currentRule.setExpirationDate(new DateUtils().parseIso8601Date(this.text.toString()));
                        }
                        catch (ParseException e) {
                            throw new RuntimeException(e);
                        }
                    } else if (name.equals("Days")) {
                        this.currentRule.setExpirationInDays(Integer.parseInt(this.text.toString()));
                    } else {
                        log.warn("Ignoring unexpected tag <" + name + ">");
                    }
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.text.append(ch, start, length);
        }
    }

    public class GetVideoMetaInfoHandler
    extends DefaultHandler {
        private StringBuilder currText = null;
        private VideoMetadata videoMetadata = null;

        public VideoMetadata getVideoMetadata() {
            return this.videoMetadata;
        }

        @Override
        public void startDocument() {
            this.currText = new StringBuilder();
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes attrs) {
            this.currText.setLength(0);
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            this.currText.setLength(0);
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.currText.append(ch, start, length);
        }
    }

    public class GetImageMetaInfoHandler
    extends DefaultHandler {
        private StringBuilder currText = null;
        private ImageMetadata imageMetadata = null;

        public ImageMetadata getImageMetadata() {
            return this.imageMetadata;
        }

        @Override
        public void startDocument() {
            this.currText = new StringBuilder();
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("ImageInfoResult")) {
                this.imageMetadata = new ImageMetadata();
            }
            this.currText.setLength(0);
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            String elementText = this.currText.toString().trim();
            if (name.equals("Type")) {
                this.imageMetadata.setImageType(elementText);
            } else if (name.equals("Orientation")) {
                this.imageMetadata.setImageOrientation(elementText);
            } else if (name.equals("Width")) {
                this.imageMetadata.setImageWidth(Integer.parseInt(elementText));
            } else if (name.equals("Height")) {
                this.imageMetadata.setImageHeight(Integer.parseInt(elementText));
            }
            this.currText.setLength(0);
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.currText.append(ch, start, length);
        }
    }

    public class ListVersionsHandler
    extends DefaultHandler {
        private VersionListing versionListing;
        private List<NOSVersionSummary> versionSummaries;
        private NOSVersionSummary currentVersionSummary;
        private StringBuilder text;

        public VersionListing getListing() {
            return this.versionListing;
        }

        @Override
        public void startDocument() {
            this.versionListing = new VersionListing();
            this.versionSummaries = new ArrayList<NOSVersionSummary>();
            this.text = new StringBuilder();
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (!(name.equals("ListVersionsResult") || name.equals("Name") || name.equals("KeyMarker") || name.equals("VersionIdMarker") || name.equals("MaxKeys") || name.equals("IsTruncated"))) {
                if (name.equals("Version")) {
                    this.currentVersionSummary = new NOSVersionSummary();
                    this.currentVersionSummary.setBucketName(this.versionListing.getBucketName());
                } else if (!(name.equals("Key") || name.equals("VersionId") || name.equals("LastModified") || name.equals("ETag") || name.equals("Size") || name.equals("StorageClass"))) {
                    log.warn("Ignoring unexpected tag <" + name + ">");
                }
            }
            this.text.setLength(0);
        }

        @Override
        public void endElement(String uri, String name, String qName) throws SAXException {
            if (name.equals("ListVersionsResult")) {
                this.versionListing.setVersionSummaries(this.versionSummaries);
            } else if (name.equals("Name")) {
                this.versionListing.setBucketName(this.text.toString());
            } else if (name.equals("KeyMarker")) {
                this.versionListing.setKeyMarker(XmlResponsesSaxParser.this.checkForEmptyString(this.text.toString()));
            } else if (name.equals("VersionMarker")) {
                this.versionListing.setVersionIdMarker(XmlResponsesSaxParser.this.checkForEmptyString(this.text.toString()));
            } else if (name.equals("MaxKeys")) {
                this.versionListing.setMaxKeys(Integer.parseInt(this.text.toString()));
            } else if (name.equals("IsTruncated")) {
                this.versionListing.setTruncated("true".equals(this.text.toString()));
            } else if (name.equals("Version")) {
                assert (this.currentVersionSummary != null);
                this.versionSummaries.add(this.currentVersionSummary);
                this.currentVersionSummary = null;
            } else if (name.equals("DeleteMarker")) {
                assert (this.currentVersionSummary != null);
                this.versionSummaries.add(this.currentVersionSummary);
                this.currentVersionSummary = null;
            } else if (name.equals("Key")) {
                assert (this.currentVersionSummary != null);
                this.currentVersionSummary.setKey(this.text.toString());
            } else if (name.equals("VersionId")) {
                assert (this.currentVersionSummary != null);
                this.currentVersionSummary.setVersionId(this.text.toString());
            } else if (name.equals("LastModified")) {
                assert (this.currentVersionSummary != null);
                try {
                    this.currentVersionSummary.setLastModified(ServiceUtils.parseIso8601Date(this.text.toString()));
                }
                catch (ParseException e) {
                    throw new SAXException("Non-ISO8601 date for LastModified in copy object output: " + this.text.toString(), e);
                }
            } else if (name.equals("ETag")) {
                assert (this.currentVersionSummary != null);
                assert (!this.currentVersionSummary.isDeleteMarker());
                this.currentVersionSummary.setETag(ServiceUtils.removeQuotes(this.text.toString()));
            } else if (name.equals("Size")) {
                assert (this.currentVersionSummary != null);
                assert (!this.currentVersionSummary.isDeleteMarker());
                this.currentVersionSummary.setSize(Long.parseLong(this.text.toString()));
            } else if (name.equals("StorageClass")) {
                assert (this.currentVersionSummary != null);
                assert (!this.currentVersionSummary.isDeleteMarker());
                this.currentVersionSummary.setStorageClass(this.text.toString());
            } else {
                log.warn("Ignoring unexpected tag <" + name + ">");
            }
            this.text.setLength(0);
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.text.append(ch, start, length);
        }
    }

    public class GetBucketDefault404Handler
    extends DefaultHandler {
        private GetBucketDefault404Result result = null;
        private StringBuilder text;

        public GetBucketDefault404Result getResult() {
            return this.result;
        }

        @Override
        public void startDocument() {
            this.text = new StringBuilder();
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("Default404Configuration")) {
                this.result = new GetBucketDefault404Result();
            } else if (!name.equals("Key")) {
                log.warn("Ignoring unexpected tag <" + name + ">");
            }
            this.text.setLength(0);
        }

        @Override
        public void endElement(String uri, String name, String qName) throws SAXException {
            if (!name.equals("Default404Configuration")) {
                if (name.equals("Key")) {
                    this.result.setKey(this.text.toString());
                } else {
                    log.warn("Ignoring unexpected tag <" + name + ">");
                }
            }
            this.text.setLength(0);
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.text.append(ch, start, length);
        }
    }

    public class GetBucketStatsHandler
    extends DefaultHandler {
        private GetBucketStatsResult result = null;
        private StringBuilder text;

        public GetBucketStatsResult getResult() {
            return this.result;
        }

        @Override
        public void startDocument() {
            this.text = new StringBuilder();
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("BucketStats")) {
                this.result = new GetBucketStatsResult();
            }
            this.text.setLength(0);
        }

        @Override
        public void endElement(String uri, String name, String qName) throws SAXException {
            if (!name.equals("BucketStats")) {
                if (name.equals("BucketName")) {
                    this.result.setBucketName(this.text.toString());
                } else if (name.equals("ObjectCount")) {
                    this.result.setObjectCount(Long.parseLong(this.text.toString()));
                } else if (name.equals("StorageCapacity")) {
                    this.result.setStorageCapacity(Long.parseLong(this.text.toString()));
                } else if (name.equals("DeduplicationRate")) {
                    this.result.setDeduplicationRate(Double.parseDouble(this.text.toString()));
                } else {
                    log.warn("Ignoring unexpected tag <" + name + ">");
                }
            }
            this.text.setLength(0);
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.text.append(ch, start, length);
        }
    }

    public class GetBucketDedupHandler
    extends DefaultHandler {
        private GetBucketDedupResult result = null;
        private StringBuilder text;

        public GetBucketDedupResult getResult() {
            return this.result;
        }

        @Override
        public void startDocument() {
            this.text = new StringBuilder();
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("DeduplicationConfiguration")) {
                this.result = new GetBucketDedupResult();
            } else if (!name.equals("Status")) {
                log.warn("Ignoring unexpected tag <" + name + ">");
            }
            this.text.setLength(0);
        }

        @Override
        public void endElement(String uri, String name, String qName) throws SAXException {
            if (!name.equals("DeduplicationConfiguration")) {
                if (name.equals("Status")) {
                    this.result.setStatus(this.text.toString());
                } else {
                    log.warn("Ignoring unexpected tag <" + name + ">");
                }
            }
            this.text.setLength(0);
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.text.append(ch, start, length);
        }
    }

    public class GetObejctVersionsHandler
    extends DefaultHandler {
        private GetObjectVersionsResult getObjectVersionsResult;
        private List<NOSVersionSummary> versionSummaries;
        private NOSVersionSummary currentVersionSummary;
        private Owner owner;
        private StringBuilder text;

        public GetObjectVersionsResult getObjectVersionsResult() {
            return this.getObjectVersionsResult;
        }

        @Override
        public void startDocument() {
            this.text = new StringBuilder();
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("ListVersionsResult")) {
                this.getObjectVersionsResult = new GetObjectVersionsResult();
            } else if (!name.equals("Bucket") && !name.equals("Key")) {
                if (name.equals("Versions")) {
                    this.versionSummaries = new ArrayList<NOSVersionSummary>();
                } else if (name.equals("Version")) {
                    this.currentVersionSummary = new NOSVersionSummary();
                } else if (!(name.equals("VersionId") || name.equals("LastModified") || name.equals("ETag") || name.equals("Size"))) {
                    if (name.equals("Owner")) {
                        this.owner = new Owner();
                    } else if (!(name.equals("StorageClass") || name.equals("ID") || name.equals("DisplayName"))) {
                        log.warn("Ignoring unexpected tag <" + name + ">");
                    }
                }
            }
            this.text.setLength(0);
        }

        @Override
        public void endElement(String uri, String name, String qName) throws SAXException {
            if (!name.equals("ListVersionsResult")) {
                if (name.equals("Bucket")) {
                    this.getObjectVersionsResult.setBucketName(this.text.toString());
                } else if (name.equals("Key")) {
                    this.getObjectVersionsResult.setKey(this.text.toString());
                } else if (name.equals("Versions")) {
                    this.getObjectVersionsResult.setVersionSummary(this.versionSummaries);
                } else if (name.equals("Version")) {
                    assert (this.currentVersionSummary != null);
                    this.currentVersionSummary.setBucketName(this.getObjectVersionsResult.getBucketName());
                    this.currentVersionSummary.setKey(this.getObjectVersionsResult.getKey());
                    this.versionSummaries.add(this.currentVersionSummary);
                    this.currentVersionSummary = null;
                } else if (name.equals("VersionId")) {
                    assert (this.currentVersionSummary != null);
                    this.currentVersionSummary.setVersionId(this.text.toString());
                } else if (name.equals("LastModified")) {
                    assert (this.currentVersionSummary != null);
                    try {
                        this.currentVersionSummary.setLastModified(ServiceUtils.parseIso8601Date(this.text.toString()));
                    }
                    catch (ParseException e) {
                        throw new SAXException("Non-ISO8601 date for LastModified in copy object output: " + this.text.toString(), e);
                    }
                } else if (name.equals("ETag")) {
                    assert (this.currentVersionSummary != null);
                    assert (!this.currentVersionSummary.isDeleteMarker());
                    this.currentVersionSummary.setETag(ServiceUtils.removeQuotes(this.text.toString()));
                } else if (name.equals("Size")) {
                    assert (this.currentVersionSummary != null);
                    assert (!this.currentVersionSummary.isDeleteMarker());
                    this.currentVersionSummary.setSize(Long.parseLong(this.text.toString()));
                } else if (name.equals("Owner")) {
                    this.currentVersionSummary.setOwner(this.owner);
                    this.owner = null;
                } else if (name.equals("StorageClass")) {
                    assert (this.currentVersionSummary != null);
                    assert (!this.currentVersionSummary.isDeleteMarker());
                    this.currentVersionSummary.setStorageClass(this.text.toString());
                } else if (name.equals("ID")) {
                    assert (this.owner != null);
                    this.owner.setId(this.text.toString());
                } else if (name.equals("DisplayName")) {
                    assert (this.owner != null);
                    this.owner.setDisplayName(this.text.toString());
                } else {
                    log.warn("Ignoring unexpected tag <" + name + ">");
                }
            }
            this.text.setLength(0);
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.text.append(ch, start, length);
        }
    }

    public class DeduplicateHandler
    extends DefaultHandler {
        private DeduplicateResult result = null;
        private StringBuilder text;

        public DeduplicateResult getResult() {
            return this.result;
        }

        @Override
        public void startDocument() {
            this.text = new StringBuilder();
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("DeduplicateResult")) {
                this.result = new DeduplicateResult();
            } else if (!(name.equals("Bucket") || name.equals("Key") || name.equals("ObjectContentAlreadyExist"))) {
                log.warn("Unexpected tag: " + name);
            }
            this.text.setLength(0);
        }

        @Override
        public void endElement(String uri, String name, String qName) throws SAXException {
            if (!name.equals("DeduplicateResult")) {
                if (name.equals("Bucket")) {
                    this.result.setBucketName(this.text.toString());
                } else if (name.equals("Key")) {
                    this.result.setKey(this.text.toString());
                } else if (name.equals("ObjectContentAlreadyExist")) {
                    if ("true".equals(this.text.toString())) {
                        this.result.setObjectExist(true);
                    } else {
                        this.result.setObjectExist(false);
                    }
                } else {
                    log.warn("Unexpected tag: " + name);
                }
            }
            this.text.setLength(0);
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.text.append(ch, start, length);
        }
    }

    public class DeleteObjectsHandler
    extends DefaultHandler {
        private StringBuilder text;
        private DeleteObjectsResult.DeletedObject deletedObject = null;
        private MultiObjectDeleteException.DeleteError error = null;
        private List<DeleteObjectsResult.DeletedObject> deletedObjects = new LinkedList<DeleteObjectsResult.DeletedObject>();
        private List<MultiObjectDeleteException.DeleteError> deleteErrors = new LinkedList<MultiObjectDeleteException.DeleteError>();

        public DeleteObjectsResponse getDeleteObjectResult() {
            return new DeleteObjectsResponse(this.deletedObjects, this.deleteErrors);
        }

        @Override
        public void startDocument() {
            this.text = new StringBuilder();
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("Deleted")) {
                this.deletedObject = new DeleteObjectsResult.DeletedObject();
            } else if (name.equals("Error")) {
                this.error = new MultiObjectDeleteException.DeleteError();
            } else if (!(name.equals("Key") || name.equals("VersionId") || name.equals("Code") || name.equals("Message") || name.equals("DeleteMarker") || name.equals("DeleteMarkerVersionId") || name.equals("DeleteResult"))) {
                log.warn("Unexpected tag: " + name);
            }
            this.text.setLength(0);
        }

        @Override
        public void endElement(String uri, String name, String qName) throws SAXException {
            if (name.equals("Deleted")) {
                this.deletedObjects.add(this.deletedObject);
                this.deletedObject = null;
            } else if (name.equals("Error")) {
                this.deleteErrors.add(this.error);
                this.error = null;
            } else if (name.equals("Key")) {
                if (this.deletedObject != null) {
                    this.deletedObject.setKey(this.text.toString());
                } else if (this.error != null) {
                    this.error.setKey(this.text.toString());
                }
            } else if (name.equals("VersionId")) {
                if (this.deletedObject != null) {
                    this.deletedObject.setVersionId(this.text.toString());
                } else if (this.error != null) {
                    this.error.setVersionId(this.text.toString());
                }
            } else if (name.equals("Code")) {
                if (this.error != null) {
                    this.error.setCode(this.text.toString());
                }
            } else if (name.equals("Message")) {
                if (this.error != null) {
                    this.error.setMessage(this.text.toString());
                }
            } else if (name.equals("DeleteMarker")) {
                if (this.deletedObject != null) {
                    this.deletedObject.setDeleteMarker(this.text.toString().equals("true"));
                }
            } else if (name.equals("DeleteMarkerVersionId") && this.deletedObject != null) {
                this.deletedObject.setDeleteMarkerVersionId(this.text.toString());
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.text.append(ch, start, length);
        }
    }

    public class ListPartsHandler
    extends DefaultHandler {
        private StringBuilder text;
        private PartListing result;
        private Owner currentOwner;
        private Owner currentInitiator;
        private PartSummary currentPart;

        public PartListing getListPartsResult() {
            return this.result;
        }

        @Override
        public void startDocument() {
            this.text = new StringBuilder();
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("ListPartsResult")) {
                this.result = new PartListing();
            } else if (!(name.equals("Bucket") || name.equals("Key") || name.equals("UploadId"))) {
                if (name.equals("Owner")) {
                    this.currentOwner = new Owner();
                } else if (name.equals("Initiator")) {
                    this.currentInitiator = new Owner();
                } else if (!(name.equals("ID") || name.equals("DisplayName") || name.equals("StorageClass") || name.equals("PartNumberMarker") || name.equals("NextPartNumberMarker") || name.equals("MaxParts") || name.equals("IsTruncated"))) {
                    if (name.equals("Part")) {
                        this.currentPart = new PartSummary();
                    } else if (name.equals("PartNumber") || name.equals("LastModified") || name.equals("ETag") || name.equals("Size")) {
                        // empty if block
                    }
                }
            }
            this.text.setLength(0);
        }

        private Integer parseInteger(String text) {
            if ((text = XmlResponsesSaxParser.this.checkForEmptyString(text.toString())) == null) {
                return null;
            }
            return Integer.parseInt(text);
        }

        @Override
        public void endElement(String uri, String name, String qName) throws SAXException {
            if (!name.equals("ListPartsResult")) {
                if (name.equals("Bucket")) {
                    this.result.setBucketName(this.text.toString());
                } else if (name.equals("Key")) {
                    this.result.setKey(this.text.toString());
                } else if (name.equals("UploadId")) {
                    this.result.setUploadId(this.text.toString());
                } else if (name.equals("Owner")) {
                    this.result.setOwner(this.currentOwner);
                    this.currentOwner = null;
                } else if (name.equals("Initiator")) {
                    this.result.setInitiator(this.currentInitiator);
                    this.currentInitiator = null;
                } else if (name.equals("ID") && this.currentOwner != null) {
                    this.currentOwner.setId(XmlResponsesSaxParser.this.checkForEmptyString(this.text.toString()));
                } else if (name.equals("DisplayName") && this.currentOwner != null) {
                    this.currentOwner.setDisplayName(XmlResponsesSaxParser.this.checkForEmptyString(this.text.toString()));
                } else if (name.equals("ID") && this.currentInitiator != null) {
                    this.currentInitiator.setId(XmlResponsesSaxParser.this.checkForEmptyString(this.text.toString()));
                } else if (name.equals("DisplayName") && this.currentInitiator != null) {
                    this.currentInitiator.setDisplayName(XmlResponsesSaxParser.this.checkForEmptyString(this.text.toString()));
                } else if (name.equals("StorageClass")) {
                    this.result.setStorageClass(this.text.toString());
                } else if (name.equals("PartNumberMarker")) {
                    this.result.setPartNumberMarker(this.parseInteger(this.text.toString()));
                } else if (name.equals("NextPartNumberMarker")) {
                    this.result.setNextPartNumberMarker(this.parseInteger(this.text.toString()));
                } else if (name.equals("MaxParts")) {
                    this.result.setMaxParts(this.parseInteger(this.text.toString()));
                } else if (name.equals("IsTruncated")) {
                    this.result.setTruncated(Boolean.parseBoolean(this.text.toString()));
                } else if (name.equals("Part")) {
                    this.result.getParts().add(this.currentPart);
                } else if (name.equals("PartNumber")) {
                    this.currentPart.setPartNumber(Integer.parseInt(this.text.toString()));
                } else if (name.equals("LastModified")) {
                    try {
                        this.currentPart.setLastModified(ServiceUtils.parseIso8601Date(this.text.toString()));
                    }
                    catch (ParseException e) {
                        throw new SAXException("Non-ISO8601 date for LastModified in list parts result: " + this.text.toString(), e);
                    }
                } else if (name.equals("ETag")) {
                    this.currentPart.setETag(ServiceUtils.removeQuotes(this.text.toString()));
                } else if (name.equals("Size")) {
                    this.currentPart.setSize(Long.parseLong(this.text.toString()));
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.text.append(ch, start, length);
        }
    }

    public class ListMultipartUploadsHandler
    extends DefaultHandler {
        private StringBuilder text;
        private MultipartUploadListing result;
        private MultipartUpload currentMultipartUpload;
        private Owner currentOwner;
        private Owner currentInitiator;
        boolean inCommonPrefixes = false;

        public MultipartUploadListing getListMultipartUploadsResult() {
            return this.result;
        }

        @Override
        public void startDocument() {
            this.text = new StringBuilder();
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("ListMultipartUploadsResult")) {
                this.result = new MultipartUploadListing();
            } else if (!(name.equals("Bucket") || name.equals("KeyMarker") || name.equals("Delimiter") || name.equals("UploadIdMarker") || name.equals("NextKeyMarker") || name.equals("NextUploadIdMarker") || name.equals("MaxUploads") || name.equals("IsTruncated"))) {
                if (name.equals("Upload")) {
                    this.currentMultipartUpload = new MultipartUpload();
                } else if (!name.equals("Key") && !name.equals("UploadId")) {
                    if (name.equals("Owner")) {
                        this.currentOwner = new Owner();
                    } else if (name.equals("Initiator")) {
                        this.currentInitiator = new Owner();
                    } else if (!(name.equals("ID") || name.equals("DisplayName") || name.equals("StorageClass") || name.equals("Initiated") || !name.equals("CommonPrefixes"))) {
                        this.inCommonPrefixes = true;
                    }
                }
            }
            this.text.setLength(0);
        }

        @Override
        public void endElement(String uri, String name, String qName) throws SAXException {
            if (!name.equals("ListMultipartUploadsResult")) {
                if (name.equals("Bucket")) {
                    this.result.setBucketName(this.text.toString());
                } else if (name.equals("KeyMarker")) {
                    this.result.setKeyMarker(XmlResponsesSaxParser.this.checkForEmptyString(this.text.toString()));
                } else if (name.equals("Delimiter")) {
                    this.result.setDelimiter(XmlResponsesSaxParser.this.checkForEmptyString(this.text.toString()));
                } else if (name.equals("Prefix") && !this.inCommonPrefixes) {
                    this.result.setPrefix(XmlResponsesSaxParser.this.checkForEmptyString(this.text.toString()));
                } else if (name.equals("Prefix") && this.inCommonPrefixes) {
                    this.result.getCommonPrefixes().add(this.text.toString());
                } else if (name.equals("UploadIdMarker")) {
                    this.result.setUploadIdMarker(XmlResponsesSaxParser.this.checkForEmptyString(this.text.toString()));
                } else if (name.equals("NextKeyMarker")) {
                    this.result.setNextKeyMarker(XmlResponsesSaxParser.this.checkForEmptyString(this.text.toString()));
                } else if (name.equals("NextUploadIdMarker")) {
                    this.result.setNextUploadIdMarker(XmlResponsesSaxParser.this.checkForEmptyString(this.text.toString()));
                } else if (name.equals("MaxUploads")) {
                    this.result.setMaxUploads(Integer.parseInt(this.text.toString()));
                } else if (name.equals("IsTruncated")) {
                    this.result.setTruncated(Boolean.parseBoolean(this.text.toString()));
                } else if (name.equals("Upload")) {
                    this.result.getMultipartUploads().add(this.currentMultipartUpload);
                } else if (name.equals("Key")) {
                    this.currentMultipartUpload.setKey(this.text.toString());
                } else if (name.equals("UploadId")) {
                    this.currentMultipartUpload.setUploadId(this.text.toString());
                } else if (name.equals("Owner")) {
                    this.currentMultipartUpload.setOwner(this.currentOwner);
                    this.currentOwner = null;
                } else if (name.equals("Initiator")) {
                    this.currentMultipartUpload.setInitiator(this.currentInitiator);
                    this.currentInitiator = null;
                } else if (name.equals("ID") && this.currentOwner != null) {
                    this.currentOwner.setId(XmlResponsesSaxParser.this.checkForEmptyString(this.text.toString()));
                } else if (name.equals("DisplayName") && this.currentOwner != null) {
                    this.currentOwner.setDisplayName(XmlResponsesSaxParser.this.checkForEmptyString(this.text.toString()));
                } else if (name.equals("ID") && this.currentInitiator != null) {
                    this.currentInitiator.setId(XmlResponsesSaxParser.this.checkForEmptyString(this.text.toString()));
                } else if (name.equals("DisplayName") && this.currentInitiator != null) {
                    this.currentInitiator.setDisplayName(XmlResponsesSaxParser.this.checkForEmptyString(this.text.toString()));
                } else if (name.equals("StorageClass")) {
                    this.currentMultipartUpload.setStorageClass(this.text.toString());
                } else if (name.equals("Initiated")) {
                    try {
                        this.currentMultipartUpload.setInitiated(ServiceUtils.parseIso8601Date(this.text.toString()));
                    }
                    catch (ParseException e) {
                        throw new SAXException("Non-ISO8601 date for Initiated in initiate multipart upload result: " + this.text.toString(), e);
                    }
                } else if (name.equals("CommonPrefixes")) {
                    this.inCommonPrefixes = false;
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.text.append(ch, start, length);
        }
    }

    public class InitiateMultipartUploadHandler
    extends DefaultHandler {
        private StringBuilder text;
        private InitiateMultipartUploadResult result;

        public InitiateMultipartUploadResult getInitiateMultipartUploadResult() {
            return this.result;
        }

        @Override
        public void startDocument() {
            this.text = new StringBuilder();
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("InitiateMultipartUploadResult")) {
                this.result = new InitiateMultipartUploadResult();
            } else if (name.equals("Bucket") || name.equals("Key") || name.equals("UploadId")) {
                // empty if block
            }
            this.text.setLength(0);
        }

        @Override
        public void endElement(String uri, String name, String qName) throws SAXException {
            if (!name.equals("InitiateMultipartUploadResult")) {
                if (name.equals("Bucket")) {
                    this.result.setBucketName(this.text.toString());
                } else if (name.equals("Key")) {
                    this.result.setKey(this.text.toString());
                } else if (name.equals("UploadId")) {
                    this.result.setUploadId(this.text.toString());
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.text.append(ch, start, length);
        }
    }

    public class CompleteMultipartUploadHandler
    extends DefaultHandler
    implements ObjectExpirationResult {
        private StringBuilder text;
        private CompleteMultipartUploadResult result;
        private NOSException ase;
        private String requestId;
        private String errorCode;

        @Override
        public Date getExpirationTime() {
            if (this.result != null) {
                return this.result.getExpirationTime();
            }
            return null;
        }

        @Override
        public void setExpirationTime(Date expirationTime) {
            if (this.result != null) {
                this.result.setExpirationTime(expirationTime);
            }
        }

        @Override
        public String getExpirationTimeRuleId() {
            if (this.result != null) {
                return this.result.getExpirationTimeRuleId();
            }
            return null;
        }

        @Override
        public void setExpirationTimeRuleId(String expirationTimeRuleId) {
            if (this.result != null) {
                this.result.setExpirationTimeRuleId(expirationTimeRuleId);
            }
        }

        public CompleteMultipartUploadResult getCompleteMultipartUploadResult() {
            return this.result;
        }

        public NOSException getNOSException() {
            return this.ase;
        }

        @Override
        public void startDocument() {
            this.text = new StringBuilder();
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("CompleteMultipartUploadResult")) {
                this.result = new CompleteMultipartUploadResult();
            } else if (name.equals("Location") || name.equals("Bucket") || name.equals("Key") || name.equals("ETag")) {
                // empty if block
            }
            if (name.equals("Error") || name.equals("Code") || name.equals("Message") || name.equals("RequestId")) {
                // empty if block
            }
            this.text.setLength(0);
        }

        @Override
        public void endElement(String uri, String name, String qName) throws SAXException {
            if (this.result != null) {
                if (!name.equals("CompleteMultipartUploadResult")) {
                    if (name.equals("Location")) {
                        this.result.setLocation(this.text.toString());
                    } else if (name.equals("Bucket")) {
                        this.result.setBucketName(this.text.toString());
                    } else if (name.equals("Key")) {
                        this.result.setKey(this.text.toString());
                    } else if (name.equals("ETag")) {
                        this.result.setETag(ServiceUtils.removeQuotes(this.text.toString()));
                    }
                }
            } else if (name.equals("Error")) {
                this.ase.setErrorCode(this.errorCode);
                this.ase.setRequestId(this.requestId);
            } else if (name.equals("Code")) {
                this.errorCode = this.text.toString();
            } else if (name.equals("Message")) {
                this.ase = new NOSException(this.text.toString());
            } else if (name.equals("RequestId")) {
                this.requestId = this.text.toString();
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.text.append(ch, start, length);
        }
    }

    public class BucketVersioningConfigurationHandler
    extends DefaultHandler {
        private BucketVersioningConfiguration configuration = new BucketVersioningConfiguration();
        private StringBuilder text;

        public BucketVersioningConfiguration getConfiguration() {
            return this.configuration;
        }

        @Override
        public void startDocument() {
            this.text = new StringBuilder();
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (!name.equals("VersioningConfiguration")) {
                if (name.equals("Status")) {
                    this.text.setLength(0);
                } else {
                    log.warn("Ignoring unexpected tag <" + name + ">");
                }
            }
        }

        @Override
        public void endElement(String uri, String name, String qName) throws SAXException {
            if (name.equals("Status")) {
                this.configuration.setStatus(this.text.toString());
            }
            this.text.setLength(0);
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.text.append(ch, start, length);
        }
    }

    public class RequestPaymentConfigurationHandler
    extends DefaultHandler {
        private String payer = null;
        private StringBuilder currText = new StringBuilder();

        public boolean isRequesterPays() {
            return "Requester".equals(this.payer);
        }

        @Override
        public void startDocument() {
        }

        @Override
        public void endDocument() {
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("RequestPaymentConfiguration")) {
                // empty if block
            }
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            String elementText = this.currText.toString().trim();
            if (name.equals("Payer")) {
                this.payer = elementText;
            }
            this.currText = new StringBuilder();
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.currText.append(ch, start, length);
        }
    }

    public class CopyObjectResultHandler
    extends DefaultHandler
    implements ObjectExpirationResult {
        private String etag = null;
        private Date lastModified = null;
        private String versionId = null;
        private String serverSideEncryption;
        private Date expirationTime;
        private String expirationTimeRuleId;
        private String errorCode = null;
        private String errorMessage = null;
        private String errorRequestId = null;
        private String errorHostId = null;
        private boolean receivedErrorResponse = false;
        private StringBuilder currText = new StringBuilder();

        public Date getLastModified() {
            return this.lastModified;
        }

        public String getVersionId() {
            return this.versionId;
        }

        public void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public String getServerSideEncryption() {
            return this.serverSideEncryption;
        }

        public void setServerSideEncryption(String serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
        }

        @Override
        public Date getExpirationTime() {
            return this.expirationTime;
        }

        @Override
        public void setExpirationTime(Date expirationTime) {
            this.expirationTime = expirationTime;
        }

        @Override
        public String getExpirationTimeRuleId() {
            return this.expirationTimeRuleId;
        }

        @Override
        public void setExpirationTimeRuleId(String expirationTimeRuleId) {
            this.expirationTimeRuleId = expirationTimeRuleId;
        }

        public String getETag() {
            return this.etag;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public String getErrorHostId() {
            return this.errorHostId;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getErrorRequestId() {
            return this.errorRequestId;
        }

        public boolean isErrorResponse() {
            return this.receivedErrorResponse;
        }

        @Override
        public void startDocument() {
        }

        @Override
        public void endDocument() {
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("CopyObjectResult")) {
                this.receivedErrorResponse = false;
            } else if (name.equals("Error")) {
                this.receivedErrorResponse = true;
            }
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            String elementText = this.currText.toString().trim();
            if (name.equals("LastModified")) {
                try {
                    this.lastModified = ServiceUtils.parseIso8601Date(elementText);
                }
                catch (ParseException e) {
                    throw new RuntimeException("Non-ISO8601 date for LastModified in copy object output: " + elementText, e);
                }
            } else if (name.equals("ETag")) {
                this.etag = ServiceUtils.removeQuotes(elementText);
            } else if (name.equals("Code")) {
                this.errorCode = elementText;
            } else if (name.equals("Message")) {
                this.errorMessage = elementText;
            } else if (name.equals("RequestId")) {
                this.errorRequestId = elementText;
            } else if (name.equals("HostId")) {
                this.errorHostId = elementText;
            }
            this.currText = new StringBuilder();
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.currText.append(ch, start, length);
        }
    }

    public class BucketLocationHandler
    extends DefaultHandler {
        private String location = null;
        private StringBuilder currText = new StringBuilder();

        public String getLocation() {
            return this.location;
        }

        @Override
        public void startDocument() {
        }

        @Override
        public void endDocument() {
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("LocationConstraint")) {
                // empty if block
            }
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            String elementText = this.currText.toString().trim();
            if (name.equals("LocationConstraint")) {
                this.location = elementText.length() == 0 ? null : elementText;
            }
            this.currText = new StringBuilder();
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.currText.append(ch, start, length);
        }
    }

    public class ListAllMyBucketsHandler
    extends DefaultHandler {
        private Owner bucketsOwner = null;
        private Bucket currentBucket = null;
        private StringBuilder currText = null;
        private List<Bucket> buckets = new ArrayList<Bucket>();

        public ListAllMyBucketsHandler() {
            this.currText = new StringBuilder();
        }

        public List<Bucket> getBuckets() {
            return this.buckets;
        }

        public Owner getOwner() {
            return this.bucketsOwner;
        }

        @Override
        public void startDocument() {
        }

        @Override
        public void endDocument() {
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("Bucket")) {
                this.currentBucket = new Bucket();
            } else if (name.equals("Owner")) {
                this.bucketsOwner = new Owner();
            }
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            String elementText = this.currText.toString().trim();
            if (name.equals("ID")) {
                this.bucketsOwner.setId(elementText);
            } else if (name.equals("DisplayName")) {
                this.bucketsOwner.setDisplayName(elementText);
            } else if (name.equals("Bucket")) {
                this.currentBucket.setOwner(this.bucketsOwner);
                this.buckets.add(this.currentBucket);
            } else if (name.equals("Name")) {
                this.currentBucket.setName(elementText);
            } else if (name.equals("CreationDate")) {
                try {
                    this.currentBucket.setCreationDate(ServiceUtils.parseIso8601Date(elementText));
                }
                catch (ParseException e) {
                    throw new RuntimeException("Non-ISO8601 date for CreationDate in list buckets output: " + elementText, e);
                }
            }
            this.currText = new StringBuilder();
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.currText.append(ch, start, length);
        }
    }

    public class ListBucketHandler
    extends DefaultHandler {
        private NOSObjectSummary currentObject = null;
        private Owner currentOwner = null;
        private StringBuilder currText = null;
        private ObjectListing objectListing = null;
        private List<String> commonPrefixes = null;
        private boolean insideCommonPrefixes = false;
        private boolean initCommonPrefixes = false;

        public ObjectListing getObjectListing() {
            return this.objectListing;
        }

        @Override
        public void startDocument() {
            this.currText = new StringBuilder();
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("ListBucketResult")) {
                this.objectListing = new ObjectListing();
            } else if (name.equals("Contents")) {
                this.currentObject = new NOSObjectSummary();
            } else if (name.equals("Owner")) {
                this.currentOwner = new Owner();
            } else if (name.equals("CommonPrefixes")) {
                if (!this.initCommonPrefixes) {
                    this.commonPrefixes = new ArrayList<String>();
                    this.initCommonPrefixes = true;
                }
                this.insideCommonPrefixes = true;
            }
            this.currText.setLength(0);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void endElement(String uri, String name, String qName) {
            String elementText = this.currText.toString().trim();
            if (name.equals("Name")) {
                this.objectListing.setBucketName(elementText);
            } else if (name.equals("Prefix") && !this.insideCommonPrefixes) {
                this.objectListing.setPrefix(elementText);
            } else if (name.equals("Marker")) {
                this.objectListing.setMarker(elementText);
            } else if (name.equals("NextMarker")) {
                this.objectListing.setNextMarker(elementText);
            } else if (name.equals("MaxKeys")) {
                this.objectListing.setMaxKeys(XmlResponsesSaxParser.this.parseInt(elementText));
            } else if (name.equals("Delimiter")) {
                this.objectListing.setDelimiter(elementText);
            } else if (name.equals("IsTruncated")) {
                String isTruncatedStr = elementText.toLowerCase(Locale.getDefault());
                if (isTruncatedStr.startsWith("false")) {
                    this.objectListing.setTruncated(false);
                } else {
                    if (!isTruncatedStr.startsWith("true")) throw new RuntimeException("Invalid value for IsTruncated field: " + isTruncatedStr);
                    this.objectListing.setTruncated(true);
                }
            } else if (name.equals("Contents")) {
                if (this.currentObject.getKey() != null && !this.currentObject.getKey().equals("")) {
                    this.currentObject.setBucketName(this.objectListing.getBucketName());
                    this.objectListing.getObjectSummaries().add(this.currentObject);
                }
            } else if (name.equals("Key")) {
                this.currentObject.setKey(elementText);
            } else if (name.equals("LastModified")) {
                try {
                    this.currentObject.setLastModified(ServiceUtils.parseIso8601Date(elementText));
                }
                catch (ParseException e) {
                    throw new RuntimeException("Non-ISO8601 date for LastModified in bucket's object listing output: " + elementText, e);
                }
            } else if (name.equals("ETag")) {
                this.currentObject.setETag(ServiceUtils.removeQuotes(elementText));
            } else if (name.equals("Size")) {
                this.currentObject.setSize(XmlResponsesSaxParser.this.parseLong(elementText));
            } else if (name.equals("StorageClass")) {
                this.currentObject.setStorageClass(elementText);
            } else if (name.equals("Owner")) {
                this.currentObject.setOwner(this.currentOwner);
            } else if (name.equals("ID")) {
                this.currentOwner.setId(elementText);
            } else if (name.equals("DisplayName")) {
                this.currentOwner.setDisplayName(elementText);
            } else if (name.equals("Prefix") && this.insideCommonPrefixes) {
                this.commonPrefixes.add(elementText);
            } else if (name.equals("CommonPrefixes")) {
                this.objectListing.setCommonPrefixes(this.commonPrefixes);
                this.insideCommonPrefixes = false;
            }
            this.currText.setLength(0);
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.currText.append(ch, start, length);
        }
    }
}

