/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.services.nos.transfer;

import com.netease.cloud.ClientException;
import com.netease.cloud.ServiceException;
import com.netease.cloud.WebServiceRequest;
import com.netease.cloud.auth.Credentials;
import com.netease.cloud.services.nos.Nos;
import com.netease.cloud.services.nos.NosClient;
import com.netease.cloud.services.nos.internal.Mimetypes;
import com.netease.cloud.services.nos.internal.ServiceUtils;
import com.netease.cloud.services.nos.model.AbortMultipartUploadRequest;
import com.netease.cloud.services.nos.model.GetObjectRequest;
import com.netease.cloud.services.nos.model.ListMultipartUploadsRequest;
import com.netease.cloud.services.nos.model.MultipartUpload;
import com.netease.cloud.services.nos.model.MultipartUploadListing;
import com.netease.cloud.services.nos.model.NOSObject;
import com.netease.cloud.services.nos.model.ObjectMetadata;
import com.netease.cloud.services.nos.model.PutObjectRequest;
import com.netease.cloud.services.nos.transfer.Download;
import com.netease.cloud.services.nos.transfer.MultipleFileUpload;
import com.netease.cloud.services.nos.transfer.Transfer;
import com.netease.cloud.services.nos.transfer.TransferManagerConfiguration;
import com.netease.cloud.services.nos.transfer.Upload;
import com.netease.cloud.services.nos.transfer.internal.DownloadImpl;
import com.netease.cloud.services.nos.transfer.internal.DownloadMonitor;
import com.netease.cloud.services.nos.transfer.internal.MultipleFileTransfer;
import com.netease.cloud.services.nos.transfer.internal.MultipleFileTransferMonitor;
import com.netease.cloud.services.nos.transfer.internal.MultipleFileUploadImpl;
import com.netease.cloud.services.nos.transfer.internal.ProgressListenerChain;
import com.netease.cloud.services.nos.transfer.internal.TransferManagerUtils;
import com.netease.cloud.services.nos.transfer.internal.TransferProgressImpl;
import com.netease.cloud.services.nos.transfer.internal.TransferProgressUpdatingListener;
import com.netease.cloud.services.nos.transfer.internal.TransferStateChangeListener;
import com.netease.cloud.services.nos.transfer.internal.UploadCallable;
import com.netease.cloud.services.nos.transfer.internal.UploadImpl;
import com.netease.cloud.services.nos.transfer.internal.UploadMonitor;
import com.netease.cloud.util.VersionInfoUtils;
import java.io.File;
import java.io.InputStream;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;

public class TransferManager {
    private Nos nos;
    private TransferManagerConfiguration configuration;
    private ThreadPoolExecutor threadPool;
    private ScheduledExecutorService timedThreadPool = new ScheduledThreadPoolExecutor(1);
    private static final String USER_AGENT = TransferManager.class.getName() + "/" + VersionInfoUtils.getVersion();

    public TransferManager(Credentials credentials) {
        this(new NosClient(credentials));
    }

    public TransferManager(Nos nos) {
        this(nos, TransferManagerUtils.createDefaultExecutorService());
    }

    public TransferManager(Nos nos, ThreadPoolExecutor threadPool) {
        this.nos = nos;
        this.threadPool = threadPool;
        this.configuration = new TransferManagerConfiguration();
    }

    public void setConfiguration(TransferManagerConfiguration configuration) {
        this.configuration = configuration;
    }

    public TransferManagerConfiguration getConfiguration() {
        return this.configuration;
    }

    public Nos getNosClient() {
        return this.nos;
    }

    public Upload upload(String bucketName, String key, InputStream input, ObjectMetadata objectMetadata) throws ServiceException, ClientException {
        return this.upload(new PutObjectRequest(bucketName, key, input, objectMetadata));
    }

    public Upload upload(String bucketName, String key, File file) throws ServiceException, ClientException {
        return this.upload(new PutObjectRequest(bucketName, key, file));
    }

    public Upload upload(PutObjectRequest putObjectRequest) throws ServiceException, ClientException {
        return this.upload(putObjectRequest, null);
    }

    private Upload upload(PutObjectRequest putObjectRequest, TransferStateChangeListener stateListener) throws ServiceException, ClientException {
        this.appendUserAgent(putObjectRequest, USER_AGENT);
        if (putObjectRequest.getMetadata() == null) {
            putObjectRequest.setMetadata(new ObjectMetadata());
        }
        ObjectMetadata metadata = putObjectRequest.getMetadata();
        if (TransferManagerUtils.getRequestFile(putObjectRequest) != null) {
            File file = TransferManagerUtils.getRequestFile(putObjectRequest);
            metadata.setContentLength(file.length());
            if (metadata.getContentType() == null) {
                metadata.setContentType(Mimetypes.getInstance().getMimetype(file));
            }
        }
        String description = "Uploading to " + putObjectRequest.getBucketName() + "/" + putObjectRequest.getKey();
        TransferProgressImpl transferProgress = new TransferProgressImpl();
        transferProgress.setTotalBytesToTransfer(TransferManagerUtils.getContentLength(putObjectRequest));
        ProgressListenerChain listenerChain = new ProgressListenerChain(new TransferProgressUpdatingListener(transferProgress), putObjectRequest.getProgressListener());
        putObjectRequest.setProgressListener(listenerChain);
        UploadImpl upload = new UploadImpl(description, transferProgress, listenerChain, stateListener);
        UploadCallable uploadCallable = new UploadCallable(this, this.threadPool, upload, putObjectRequest, listenerChain);
        UploadMonitor watcher = new UploadMonitor(this, upload, this.threadPool, uploadCallable, putObjectRequest, listenerChain);
        watcher.setTimedThreadPool(this.timedThreadPool);
        upload.setMonitor(watcher);
        return upload;
    }

    public Download download(String bucket, String key, File file) {
        return this.download(new GetObjectRequest(bucket, key), file);
    }

    public Download download(GetObjectRequest getObjectRequest, File file) {
        return this.download(getObjectRequest, file, null);
    }

    private Download download(final GetObjectRequest getObjectRequest, final File file, TransferStateChangeListener stateListener) {
        this.appendUserAgent(getObjectRequest, USER_AGENT);
        String description = "Downloading from " + getObjectRequest.getBucketName() + "/" + getObjectRequest.getKey();
        TransferProgressImpl transferProgress = new TransferProgressImpl();
        ProgressListenerChain listenerChain = new ProgressListenerChain(new TransferProgressUpdatingListener(transferProgress), getObjectRequest.getProgressListener());
        getObjectRequest.setProgressListener(listenerChain);
        NOSObject nosObject = null;
        ObjectMetadata objectMetadata = this.nos.getObjectMetadata(getObjectRequest.getBucketName(), getObjectRequest.getKey());
        if (objectMetadata != null) {
            nosObject = new NOSObject();
            nosObject.setObjectMetadata(objectMetadata);
            nosObject.setKey(getObjectRequest.getKey());
            nosObject.setBucketName(getObjectRequest.getBucketName());
        }
        final DownloadImpl download = new DownloadImpl(description, transferProgress, listenerChain, nosObject, stateListener);
        if (nosObject == null) {
            download.setState(Transfer.TransferState.Canceled);
            download.setMonitor(new DownloadMonitor(download, null));
            return download;
        }
        long contentLength = nosObject.getObjectMetadata().getContentLength();
        if (getObjectRequest.getRange() != null && getObjectRequest.getRange().length == 2) {
            long startingByte = getObjectRequest.getRange()[0];
            long lastByte = getObjectRequest.getRange()[1];
            contentLength = lastByte - startingByte;
        }
        transferProgress.setTotalBytesToTransfer(contentLength);
        if (file.exists()) {
            file.delete();
        }
        Future<Object> future = this.threadPool.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    download.setState(Transfer.TransferState.InProgress);
                    NOSObject globalNosObject = download.getNosObject();
                    long rangeLength = getObjectRequest.getRangeLength();
                    long innerContentLength = globalNosObject.getObjectMetadata().getContentLength();
                    if (getObjectRequest.getRange() != null && getObjectRequest.getRange().length == 2 && getObjectRequest.getRangeLength() < innerContentLength) {
                        long rangeBegin = getObjectRequest.getRange()[0];
                        long rangeEnd = getObjectRequest.getRange()[1];
                        TransferManager.this.deal(getObjectRequest, download, file, rangeBegin, rangeEnd, rangeLength);
                    } else if (innerContentLength >= rangeLength) {
                        TransferManager.this.deal(getObjectRequest, download, file, 0L, globalNosObject.getObjectMetadata().getContentLength() - 1L, rangeLength);
                    } else {
                        NOSObject nosObject1 = TransferManager.this.nos.getObject(getObjectRequest);
                        download.setNosObjectInputstream(nosObject1.getObjectContent());
                        ServiceUtils.downloadObjectToFile(download.getNosObject(), file);
                    }
                    download.setState(Transfer.TransferState.Completed);
                    return true;
                }
                catch (Exception e) {
                    if (download.getState() != Transfer.TransferState.Canceled) {
                        download.setState(Transfer.TransferState.Failed);
                    }
                    throw e;
                }
            }
        });
        download.setMonitor(new DownloadMonitor(download, future));
        return download;
    }

    private void deal(GetObjectRequest getObjectRequest, DownloadImpl download, File file, long rangeBegin, long rangeEnd, long rangeLength) {
        NOSObject nosObject1;
        long rangeIndex = rangeBegin;
        while (rangeIndex + rangeLength <= rangeEnd && download.getState() == Transfer.TransferState.InProgress) {
            getObjectRequest.setRange(rangeIndex, rangeIndex + rangeLength);
            nosObject1 = this.nos.getObject(getObjectRequest);
            download.setNosObjectInputstream(nosObject1.getObjectContent());
            ServiceUtils.downloadObjectToFile(download, file, rangeIndex, rangeIndex + rangeLength);
            rangeIndex += getObjectRequest.getRangeLength() + 1L;
        }
        if (rangeIndex != rangeEnd && download.getState() == Transfer.TransferState.InProgress) {
            getObjectRequest.setRange(rangeIndex, rangeEnd);
            nosObject1 = this.nos.getObject(getObjectRequest);
            download.setNosObjectInputstream(nosObject1.getObjectContent());
            ServiceUtils.downloadObjectToFile(download, file, rangeIndex, rangeEnd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultipleFileUpload uploadDirectory(String bucketName, String virtualDirectoryKeyPrefix, File directory, boolean includeSubdirectories) {
        if (directory == null || !directory.exists() || !directory.isDirectory()) {
            throw new IllegalArgumentException("Must provide a directory to upload");
        }
        if (virtualDirectoryKeyPrefix == null || virtualDirectoryKeyPrefix.length() == 0) {
            virtualDirectoryKeyPrefix = "";
        } else if (!virtualDirectoryKeyPrefix.endsWith("/")) {
            virtualDirectoryKeyPrefix = virtualDirectoryKeyPrefix + "/";
        }
        TransferProgressImpl transferProgress = new TransferProgressImpl();
        TransferProgressUpdatingListener listener = new TransferProgressUpdatingListener(transferProgress);
        LinkedList<UploadImpl> uploads = new LinkedList<UploadImpl>();
        MultipleFileUploadImpl multipleFileUpload = new MultipleFileUploadImpl("Uploading etc", transferProgress, null, virtualDirectoryKeyPrefix, bucketName, uploads);
        multipleFileUpload.setMonitor(new MultipleFileTransferMonitor(multipleFileUpload, uploads));
        AllDownloadsQueuedLock allTransfersQueuedLock = new AllDownloadsQueuedLock();
        MultipleFileTransferStateChangeListener stateChangeListener = new MultipleFileTransferStateChangeListener(allTransfersQueuedLock, multipleFileUpload);
        long totalSize = 0L;
        LinkedList<File> files = new LinkedList<File>();
        this.listFiles(directory, files, includeSubdirectories);
        for (File f : files) {
            totalSize += f.length();
            String key = f.getAbsolutePath().substring(directory.getAbsolutePath().length() + 1).replaceAll("\\\\", "/");
            uploads.add((UploadImpl)this.upload(new PutObjectRequest(bucketName, virtualDirectoryKeyPrefix + key, f).withProgressListener(listener), stateChangeListener));
        }
        transferProgress.setTotalBytesToTransfer(totalSize);
        AllDownloadsQueuedLock allDownloadsQueuedLock = allTransfersQueuedLock;
        synchronized (allDownloadsQueuedLock) {
            allTransfersQueuedLock.allQueued = true;
            allTransfersQueuedLock.notifyAll();
        }
        return multipleFileUpload;
    }

    private void listFiles(File dir, List<File> results, boolean includeSubDirectories) {
        File[] found = dir.listFiles();
        if (found != null) {
            for (File f : found) {
                if (f.isDirectory()) {
                    if (!includeSubDirectories) continue;
                    this.listFiles(f, results, includeSubDirectories);
                    continue;
                }
                results.add(f);
            }
        }
    }

    public void abortMultipartUploads(String bucketName, Date date) throws ServiceException, ClientException {
        ListMultipartUploadsRequest request;
        MultipartUploadListing uploadListing = this.nos.listMultipartUploads(this.appendUserAgent(new ListMultipartUploadsRequest(bucketName), USER_AGENT));
        do {
            for (MultipartUpload upload : uploadListing.getMultipartUploads()) {
                if (upload.getInitiated().compareTo(date) >= 0) continue;
                this.nos.abortMultipartUpload(this.appendUserAgent(new AbortMultipartUploadRequest(bucketName, upload.getKey(), upload.getUploadId()), USER_AGENT));
            }
        } while ((uploadListing = this.nos.listMultipartUploads(this.appendUserAgent(request = new ListMultipartUploadsRequest(bucketName).withUploadIdMarker(uploadListing.getNextUploadIdMarker()).withKeyMarker(uploadListing.getNextKeyMarker()), USER_AGENT))).isTruncated());
    }

    public void shutdownNow() {
        this.threadPool.shutdownNow();
        this.timedThreadPool.shutdownNow();
        if (this.nos instanceof NosClient) {
            ((NosClient)this.nos).shutdown();
        }
    }

    public <X extends WebServiceRequest> X appendUserAgent(X request, String userAgent) {
        request.getRequestClientOptions().addClientMarker(USER_AGENT);
        return request;
    }

    private static final class MultipleFileTransferStateChangeListener
    implements TransferStateChangeListener {
        private final AllDownloadsQueuedLock allTransfersQueuedLock;
        private final MultipleFileTransfer multipleFileTransfer;

        public MultipleFileTransferStateChangeListener(AllDownloadsQueuedLock allTransfersQueuedLock, MultipleFileTransfer multipleFileDownload) {
            this.allTransfersQueuedLock = allTransfersQueuedLock;
            this.multipleFileTransfer = multipleFileDownload;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transferStateChanged(Transfer upload, Transfer.TransferState state) {
            Object object = this.allTransfersQueuedLock;
            synchronized (object) {
                if (!this.allTransfersQueuedLock.allQueued) {
                    try {
                        this.allTransfersQueuedLock.wait();
                    }
                    catch (InterruptedException e) {
                        throw new ClientException("Couldn't wait for all downloads to be queued");
                    }
                }
            }
            object = this.multipleFileTransfer;
            synchronized (object) {
                if (this.multipleFileTransfer.getState() == state || this.multipleFileTransfer.isDone()) {
                    return;
                }
                if (state == Transfer.TransferState.InProgress) {
                    this.multipleFileTransfer.setState(state);
                } else if (this.multipleFileTransfer.getMonitor().isDone()) {
                    this.multipleFileTransfer.collateFinalState();
                } else {
                    this.multipleFileTransfer.setState(Transfer.TransferState.InProgress);
                }
            }
        }
    }

    private static final class AllDownloadsQueuedLock {
        private volatile boolean allQueued = false;

        private AllDownloadsQueuedLock() {
        }
    }
}

