/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nrtc.engine.rawapi.toolbox;

import android.content.Context;
import android.media.AudioManager;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.SystemClock;
import android.os.Vibrator;
import android.provider.Settings;
import android.util.Log;

public class Ringer {
    private static final String LOG_TAG = "Ringer";
    private static final int PLAY_RING_ONCE = 1;
    private static final int STOP_RING = 3;
    private static final int VIBRATE_LENGTH = 1000;
    private static final int PAUSE_LENGTH = 1000;
    private static Ringer sInstance;
    Uri mCustomRingtoneUri = Settings.System.DEFAULT_RINGTONE_URI;
    Ringtone mRingtone;
    Vibrator mVibrator;
    PowerManager mPowerManager;
    volatile boolean mContinueVibrating;
    VibratorThread mVibratorThread;
    Context mContext;
    private Worker mRingThread;
    private Handler mRingHandler;
    private long mFirstRingEventTime = -1L;
    private long mFirstRingStartTime = -1L;
    AudioManager mAudioManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Ringer init(Context context) {
        Class<Ringer> clazz = Ringer.class;
        synchronized (Ringer.class) {
            if (sInstance == null) {
                sInstance = new Ringer(context);
            } else {
                Log.wtf((String)LOG_TAG, (String)("init() called multiple times!  sInstance = " + sInstance));
            }
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return sInstance;
        }
    }

    private Ringer(Context context) {
        this.mContext = context;
        this.mPowerManager = (PowerManager)context.getSystemService("power");
        this.mVibrator = (Vibrator)context.getSystemService("vibrator");
        this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isRinging() {
        Ringer ringer = this;
        synchronized (ringer) {
            return this.isRingtonePlaying() || this.isVibrating();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRingtonePlaying() {
        Ringer ringer = this;
        synchronized (ringer) {
            return this.mRingtone != null && this.mRingtone.isPlaying() || this.mRingHandler != null && this.mRingHandler.hasMessages(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isVibrating() {
        Ringer ringer = this;
        synchronized (ringer) {
            return this.mVibratorThread != null;
        }
    }

    public void vibrateShort(int n2) {
        if (this.mVibrator == null) {
            this.mVibrator = (Vibrator)this.mContext.getSystemService("vibrator");
        }
        this.mVibrator.vibrate((long)n2);
    }

    boolean shouldVibrate() {
        AudioManager audioManager = (AudioManager)this.mContext.getSystemService("audio");
        int n2 = audioManager.getRingerMode();
        return n2 == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ring() {
        Ringer ringer = this;
        synchronized (ringer) {
            if (this.shouldVibrate() && this.mVibratorThread == null) {
                this.mContinueVibrating = true;
                this.mVibratorThread = new VibratorThread();
                this.mVibratorThread.start();
            }
            if (this.mAudioManager.getStreamVolume(2) == 0) {
                return;
            }
            this.makeLooper();
            if (this.mFirstRingEventTime < 0L) {
                this.mFirstRingEventTime = SystemClock.elapsedRealtime();
                this.mRingHandler.sendEmptyMessage(1);
            } else if (this.mFirstRingStartTime > 0L) {
                this.mRingHandler.sendEmptyMessageDelayed(1, this.mFirstRingStartTime - this.mFirstRingEventTime);
            } else {
                this.mFirstRingEventTime = SystemClock.elapsedRealtime();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRing() {
        Ringer ringer = this;
        synchronized (ringer) {
            if (this.mRingHandler != null) {
                this.mRingHandler.removeCallbacksAndMessages(null);
                Message message = this.mRingHandler.obtainMessage(3);
                this.mRingHandler.obtainMessage(3).obj = this.mRingtone;
                this.mRingHandler.sendMessage(message);
                this.mAudioManager.setMode(2);
                this.mRingThread = null;
                this.mRingHandler = null;
                this.mRingtone = null;
                this.mFirstRingEventTime = -1L;
                this.mFirstRingStartTime = -1L;
            }
            if (this.mVibratorThread != null) {
                this.mContinueVibrating = false;
                this.mVibratorThread = null;
            }
            this.mVibrator.cancel();
            return;
        }
    }

    public void setCustomRingtoneUri(Uri uri) {
        if (uri != null) {
            this.mCustomRingtoneUri = uri;
        }
    }

    private void makeLooper() {
        if (this.mRingThread == null) {
            this.mRingThread = new Worker("ringer");
            this.mRingHandler = new Handler(this.mRingThread.getLooper()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handleMessage(Message object) {
                    switch (object.what) {
                        case 1: {
                            Ringtone ringtone;
                            if (Ringer.this.mRingtone == null && !this.hasMessages(3)) {
                                ringtone = RingtoneManager.getRingtone((Context)Ringer.this.mContext, (Uri)Ringer.this.mCustomRingtoneUri);
                                object = Ringer.this;
                                synchronized (object) {
                                    if (!this.hasMessages(3)) {
                                        Ringer.this.mRingtone = ringtone;
                                    }
                                }
                            }
                            if ((ringtone = Ringer.this.mRingtone) == null || this.hasMessages(3) || ringtone.isPlaying()) break;
                            Ringer.this.mAudioManager.setMode(1);
                            ringtone.play();
                            object = Ringer.this;
                            synchronized (object) {
                                if (Ringer.this.mFirstRingStartTime < 0L) {
                                    Ringer.this.mFirstRingStartTime = SystemClock.elapsedRealtime();
                                }
                                break;
                            }
                        }
                        case 3: {
                            Ringtone ringtone = (Ringtone)object.obj;
                            if (ringtone != null) {
                                ringtone.stop();
                            } else {
                                Log.d((String)Ringer.LOG_TAG, (String)("- STOP_RING with null ringtone!  msg = " + object));
                            }
                            this.getLooper().quit();
                        }
                    }
                }
            };
        }
    }

    class Worker
    implements Runnable {
        private final Object mLock = new Object();
        private Looper mLooper;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Worker(String string) {
            Ringer.this = new Thread(null, this, string);
            ((Thread)Ringer.this).start();
            Ringer.this = this.mLock;
            synchronized (Ringer.this) {
                while (this.mLooper == null) {
                    try {
                        this.mLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return;
            }
        }

        public Looper getLooper() {
            return this.mLooper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.mLock;
            synchronized (object) {
                Looper.prepare();
                this.mLooper = Looper.myLooper();
                this.mLock.notifyAll();
            }
            Looper.loop();
        }

        public void quit() {
            this.mLooper.quit();
        }
    }

    class VibratorThread
    extends Thread {
        private VibratorThread() {
        }

        @Override
        public void run() {
            while (Ringer.this.mContinueVibrating) {
                Ringer.this.mVibrator.vibrate(1000L);
                SystemClock.sleep((long)2000L);
            }
        }
    }
}

